/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.test.util;

import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;

public class AssetEntryQueryTestUtil {
    public static AssetEntryQuery createAssetEntryQuery(long groupId, long[] classNameIds) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, classNameIds, null, null, null, null, null, null, null, null, null);
    }

    public static AssetEntryQuery createAssetEntryQuery(long groupId, String className, long[] notAllCategoryIds, long[] notAnyCategoryIds, long[] allCategoryIds, long[] anyCategoryIds) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, className, notAllCategoryIds, notAnyCategoryIds, allCategoryIds, anyCategoryIds);
    }

    public static AssetEntryQuery createAssetEntryQuery(long groupId, String className, String[] notAllTagNames, String[] notAnyTagNames, String[] allTagNames, String[] anyTagNames) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, className, notAllTagNames, notAnyTagNames, allTagNames, anyTagNames);
    }

    public static AssetEntryQuery createAssetEntryQuery(long groupId, String[] classNames) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, classNames);
    }

    public static AssetEntryQuery createAssetEntryQuery(long groupId, String[] classNames, long[] classTypeIds) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, classNames, classTypeIds);
    }

    public static AssetEntryQuery createAssetEntryQuery(long groupId, String[] classNames, long[] classTypeIds, long[] notAllCategoryIds, long[] notAnyCategoryIds, long[] allCategoryIds, long[] anyCategoryIds, String[] notAllTagNames, String[] notAnyTagNames, String[] allTagNames, String[] anyTagNames) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(new long[]{groupId}, classNames, classTypeIds, notAllCategoryIds, notAnyCategoryIds, allCategoryIds, anyCategoryIds, notAllTagNames, notAnyTagNames, allTagNames, anyTagNames);
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, long[] classNameIds, long[] classTypeIds, long[] notAllCategoryIds, long[] notAnyCategoryIds, long[] allCategoryIds, long[] anyCategoryIds, String[] notAllTagNames, String[] notAnyTagNames, String[] allTagNames, String[] anyTagNames) throws Exception {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        assetEntryQuery.setClassNameIds(classNameIds);
        if (classTypeIds != null) {
            assetEntryQuery.setClassTypeIds(classTypeIds);
        }
        if (notAllCategoryIds != null) {
            assetEntryQuery.setNotAllCategoryIds(notAllCategoryIds);
        }
        if (notAnyCategoryIds != null) {
            assetEntryQuery.setNotAnyCategoryIds(notAnyCategoryIds);
        }
        if (anyCategoryIds != null) {
            assetEntryQuery.setAnyCategoryIds(anyCategoryIds);
        }
        if (allCategoryIds != null) {
            assetEntryQuery.setAllCategoryIds(allCategoryIds);
        }
        if (ArrayUtil.isNotEmpty(notAllTagNames)) {
            for (String assetTagName : notAllTagNames) {
                long[] notAllAssetTagIds = AssetTagLocalServiceUtil.getTagIds(groupIds, assetTagName);
                assetEntryQuery.addNotAllTagIdsArray(notAllAssetTagIds);
            }
        }
        if (ArrayUtil.isNotEmpty(notAnyTagNames)) {
            assetEntryQuery.setNotAnyTagIds(AssetEntryQueryTestUtil.getAssetTagsIds(groupIds, notAnyTagNames));
        }
        if (ArrayUtil.isNotEmpty(anyTagNames)) {
            assetEntryQuery.setAnyTagIds(AssetEntryQueryTestUtil.getAssetTagsIds(groupIds, anyTagNames));
        }
        if (ArrayUtil.isNotEmpty(allTagNames)) {
            for (String assetTagName : allTagNames) {
                long[] allAssetTagIds = AssetTagLocalServiceUtil.getTagIds(groupIds, assetTagName);
                assetEntryQuery.addAllTagIdsArray(allAssetTagIds);
            }
        }
        assetEntryQuery.setGroupIds(groupIds);
        return assetEntryQuery;
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, String className, long[] notAllCategoryIds, long[] notAnyCategoryIds, long[] allCategoryIds, long[] anyCategoryIds) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(groupIds, new String[]{className}, null, notAllCategoryIds, notAnyCategoryIds, allCategoryIds, anyCategoryIds, null, null, null, null);
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, String className, String[] notAllTagNames, String[] notAnyTagNames, String[] allTagNames, String[] anyTagNames) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(groupIds, new String[]{className}, null, null, null, null, null, notAllTagNames, notAnyTagNames, allTagNames, anyTagNames);
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, String[] classNames) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(groupIds, classNames, null, null, null, null, null, null, null, null, null);
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, String[] classNames, long[] classTypeIds) throws Exception {
        return AssetEntryQueryTestUtil.createAssetEntryQuery(groupIds, classNames, classTypeIds, null, null, null, null, null, null, null, null);
    }

    public static AssetEntryQuery createAssetEntryQuery(long[] groupIds, String[] classNames, long[] classTypeIds, long[] notAllCategoryIds, long[] notAnyCategoryIds, long[] allCategoryIds, long[] anyCategoryIds, String[] notAllTagNames, String[] notAnyTagNames, String[] allTagNames, String[] anyTagNames) throws Exception {
        long[] classNameIds = new long[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            classNameIds[i] = PortalUtil.getClassNameId(classNames[i]);
        }
        return AssetEntryQueryTestUtil.createAssetEntryQuery(groupIds, classNameIds, classTypeIds, notAllCategoryIds, notAnyCategoryIds, allCategoryIds, anyCategoryIds, notAllTagNames, notAnyTagNames, allTagNames, anyTagNames);
    }

    protected static long[] getAssetTagsIds(long[] groupIds, String[] assetTagNames) throws Exception {
        if (ArrayUtil.isEmpty(assetTagNames)) {
            return new long[0];
        }
        return AssetTagLocalServiceUtil.getTagIds(groupIds, assetTagNames);
    }
}

