/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.taglib.servlet.taglib.soy;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagServiceUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolverUtil;
import com.liferay.frontend.taglib.soy.servlet.taglib.ComponentRendererTag;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.AUIUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class AssetTagsSelectorTag
extends ComponentRendererTag {
    private static final Log _log = LogFactoryUtil.getLog(AssetTagsSelectorTag.class);
    private String _className;
    private long _classPK;
    private long[] _groupIds;
    private String _hiddenInput = "assetTagNames";
    private String _id;
    private boolean _ignoreRequestValue;
    private String _namespace;
    private Boolean _showSelectButton = true;
    private String _tagNames;

    @Override
    public int doStartTag() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            this.putValue("eventName", this._getEventName());
            this.putValue("groupIds", this._getGroupIds());
            this.putValue("id", this._getNamespace() + this._getId() + "assetTagsSelector");
            this.putValue("inputName", this._getInputName());
            this.putValue("portletURL", this._getPortletURL());
            ArrayList selectedItems = new ArrayList();
            List<String> tagNames = StringUtil.split(this._getTagNames());
            for (String tagName : tagNames) {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("label", tagName);
                item.put("value", tagName);
                selectedItems.add(item);
            }
            this.putValue("selectedItems", selectedItems);
            this.putValue("showSelectButton", this._showSelectButton);
            String pathThemeImages = themeDisplay.getPathThemeImages();
            this.putValue("spritemap", pathThemeImages.concat("/clay/icons.svg"));
            this.putValue("tagNames", this._getTagNames());
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        this.setTemplateNamespace("com.liferay.asset.taglib.AssetTagsSelector.render");
        return super.doStartTag();
    }

    @Override
    public String getModule() {
        return NPMResolverUtil.resolveModuleName(AssetTagsSelectorTag.class, "asset-taglib/asset_tags_selector/AssetTagsSelector.es");
    }

    public void setAddCallback(String addCallback) {
        this.putValue("addCallback", this._getNamespace() + addCallback);
    }

    public void setAllowAddEntry(boolean allowAddEntry) {
        this.putValue("allowAddEntry", allowAddEntry);
    }

    public void setAutoFocus(boolean autoFocus) {
        this.putValue("autoFocus", autoFocus);
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setGroupIds(long[] groupIds) {
        this.putValue("groupIds", groupIds);
    }

    public void setHiddenInput(String hiddenInput) {
        this._hiddenInput = hiddenInput;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setIgnoreRequestValue(boolean ignoreRequestValue) {
        this._ignoreRequestValue = ignoreRequestValue;
    }

    public void setRemoveCallback(String removeCallback) {
        this.putValue("removeCallback", this._getNamespace() + removeCallback);
    }

    public void setShowSelectButton(boolean showSelectButton) {
        this._showSelectButton = showSelectButton;
    }

    public void setTagNames(String tagNames) {
        this._tagNames = tagNames;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        if (!ServerDetector.isResin()) {
            this._className = null;
            this._classPK = 0L;
            this._groupIds = null;
            this._hiddenInput = "assetTagNames";
            this._id = null;
            this._ignoreRequestValue = false;
            this._namespace = null;
            this._showSelectButton = true;
            this._tagNames = null;
        }
    }

    private String _getEventName() {
        String portletId = PortletProviderUtil.getPortletId(AssetTag.class.getName(), PortletProvider.Action.BROWSE);
        return PortalUtil.getPortletNamespace(portletId) + "selectTag";
    }

    private long[] _getGroupIds() {
        if (this._groupIds != null) {
            return this._groupIds;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] groupIds = null;
        Group group = themeDisplay.getScopeGroup();
        groupIds = group.isLayout() ? new long[]{group.getParentGroupId()} : new long[]{group.getGroupId()};
        if (group.getParentGroupId() != themeDisplay.getCompanyGroupId()) {
            groupIds = ArrayUtil.append(groupIds, themeDisplay.getCompanyGroupId());
        }
        return groupIds;
    }

    private String _getId() {
        if (Validator.isNotNull(this._id)) {
            return this._id;
        }
        String randomKey = PortalUtil.generateRandomKey(this.request, "taglib_ui_asset_tags_selector_page");
        return randomKey + "_";
    }

    private String _getInputName() {
        return this._getNamespace() + this._hiddenInput;
    }

    private String _getNamespace() {
        if (this._namespace != null) {
            return this._namespace;
        }
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        if (portletRequest == null || portletResponse == null) {
            this._namespace = AUIUtil.getNamespace(this.request);
            return this._namespace;
        }
        this._namespace = AUIUtil.getNamespace(portletRequest, portletResponse);
        return this._namespace;
    }

    private String _getPortletURL() {
        try {
            PortletURL portletURL = PortletProviderUtil.getPortletURL(this.request, AssetTag.class.getName(), PortletProvider.Action.BROWSE);
            if (portletURL == null) {
                return null;
            }
            portletURL.setParameter("eventName", this._getEventName());
            portletURL.setParameter("selectedTagNames", "{selectedTagNames}");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            return portletURL.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String _getTagNames() {
        String curTagsParam;
        String tagNames = this._tagNames;
        if (Validator.isNotNull(this._className) && this._classPK > 0L) {
            List<AssetTag> tags = AssetTagServiceUtil.getTags(this._className, this._classPK);
            tagNames = ListUtil.toString(tags, AssetTag.NAME_ACCESSOR);
        }
        if (!this._ignoreRequestValue && Validator.isNotNull(curTagsParam = this.request.getParameter(this._hiddenInput))) {
            tagNames = curTagsParam;
        }
        return tagNames;
    }
}

