/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.taglib.servlet.taglib.soy;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyServiceUtil;
import com.liferay.asset.taglib.internal.util.AssetCategoryUtil;
import com.liferay.asset.taglib.internal.util.AssetVocabularyUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolverUtil;
import com.liferay.frontend.taglib.soy.servlet.taglib.ComponentRendererTag;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.AUIUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class AssetCategoriesSelectorTag
extends ComponentRendererTag {
    private static final Log _log = LogFactoryUtil.getLog(AssetCategoriesSelectorTag.class);
    private String _categoryIds;
    private String _className;
    private long _classPK;
    private long _classTypePK = -1L;
    private long[] _groupIds;
    private String _hiddenInput = "assetCategoryIds";
    private boolean _ignoreRequestValue;
    private String _namespace;
    private boolean _showRequiredLabel = true;
    private boolean _singleSelect;

    @Override
    public int doStartTag() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            this.putValue("eventName", this.getEventName());
            this.putValue("groupIds", ListUtil.toList(this.getGroupIds()));
            this.putValue("id", this._getNamespace() + "assetCategoriesSelector");
            this.putValue("inputName", this._getInputName());
            this.putValue("portletURL", this.getPortletURL().toString());
            String pathThemeImages = themeDisplay.getPathThemeImages();
            this.putValue("spritemap", pathThemeImages.concat("/clay/icons.svg"));
            this.putValue("vocabularies", this.getVocabularies());
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        String templateNamespace = "com.liferay.asset.taglib.AssetCategoriesSelector.render";
        if (Validator.isNull(this._className)) {
            templateNamespace = "com.liferay.asset.taglib.AssetVocabularyCategoriesSelector.render";
        }
        this.setTemplateNamespace(templateNamespace);
        return super.doStartTag();
    }

    @Override
    public String getModule() {
        return NPMResolverUtil.resolveModuleName(AssetCategoriesSelectorTag.class, "asset-taglib/asset_categories_selector/AssetCategoriesSelector.es");
    }

    public void setCategoryIds(String categoryIds) {
        this._categoryIds = categoryIds;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setClassTypePK(long classTypePK) {
        this._classTypePK = classTypePK;
    }

    public void setGroupIds(long[] groupIds) {
        this._groupIds = groupIds;
    }

    public void setHiddenInput(String hiddenInput) {
        this._hiddenInput = hiddenInput;
    }

    public void setIgnoreRequestValue(boolean ignoreRequestValue) {
        this._ignoreRequestValue = ignoreRequestValue;
    }

    public void setShowRequiredLabel(boolean showRequiredLabel) {
        this._showRequiredLabel = showRequiredLabel;
    }

    public void setSingleSelect(boolean singleSelect) {
        this._singleSelect = singleSelect;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._categoryIds = null;
        this._className = null;
        this._classPK = 0L;
        this._classTypePK = -1L;
        this._groupIds = null;
        this._hiddenInput = "assetCategoryIds";
        this._ignoreRequestValue = false;
        this._namespace = null;
        this._showRequiredLabel = true;
        this._singleSelect = false;
    }

    protected List<AssetVocabulary> getAssetVocabularies() {
        List<AssetVocabulary> vocabularies = AssetVocabularyServiceUtil.getGroupVocabularies(this.getGroupIds());
        if (Validator.isNotNull(this._className)) {
            vocabularies = AssetVocabularyUtil.filterVocabularies(vocabularies, this._className, this._classTypePK);
        }
        return ListUtil.filter(vocabularies, vocabulary -> {
            int vocabularyCategoriesCount = AssetCategoryServiceUtil.getVocabularyCategoriesCount(vocabulary.getGroupId(), vocabulary.getVocabularyId());
            return vocabularyCategoriesCount > 0;
        });
    }

    protected List<String[]> getCategoryIdsTitles() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<String[]> categoryIdsTitles = new ArrayList<String[]>();
        String categoryIds = "";
        if (Validator.isNotNull(this._categoryIds)) {
            categoryIds = this._categoryIds;
        }
        if (Validator.isNull(this._className)) {
            String categoryIdsParam;
            if (!this._ignoreRequestValue && (categoryIdsParam = this.request.getParameter(this._hiddenInput)) != null) {
                categoryIds = categoryIdsParam;
            }
            String[] categoryIdsTitle = AssetCategoryUtil.getCategoryIdsTitles(categoryIds, "", 0L, themeDisplay);
            categoryIdsTitles.add(categoryIdsTitle);
            return categoryIdsTitles;
        }
        try {
            for (AssetVocabulary vocabulary : this.getAssetVocabularies()) {
                String categoryIdsParam;
                String categoryNames = "";
                if (Validator.isNotNull(this._className) && this._classPK > 0L) {
                    List<AssetCategory> categories = AssetCategoryServiceUtil.getCategories(this._className, this._classPK);
                    categoryIds = ListUtil.toString(categories, AssetCategory.CATEGORY_ID_ACCESSOR);
                    categoryNames = ListUtil.toString(categories, AssetCategory.NAME_ACCESSOR);
                }
                if (!this._ignoreRequestValue && Validator.isNotNull(categoryIdsParam = this.request.getParameter(this._hiddenInput + "_" + vocabulary.getVocabularyId()))) {
                    categoryIds = categoryIdsParam;
                }
                String[] categoryIdsTitle = AssetCategoryUtil.getCategoryIdsTitles(categoryIds, categoryNames, vocabulary.getVocabularyId(), themeDisplay);
                categoryIdsTitles.add(categoryIdsTitle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return categoryIdsTitles;
    }

    protected String getEventName() {
        String portletId = PortletProviderUtil.getPortletId(AssetCategory.class.getName(), PortletProvider.Action.BROWSE);
        return PortalUtil.getPortletNamespace(portletId) + "selectCategory";
    }

    protected long[] getGroupIds() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            if (ArrayUtil.isEmpty(this._groupIds)) {
                return PortalUtil.getCurrentAndAncestorSiteGroupIds(themeDisplay.getScopeGroupId());
            }
            return PortalUtil.getCurrentAndAncestorSiteGroupIds(this._groupIds);
        }
        catch (Exception exception) {
            return new long[0];
        }
    }

    protected PortletURL getPortletURL() {
        try {
            PortletURL portletURL = PortletProviderUtil.getPortletURL(this.request, AssetCategory.class.getName(), PortletProvider.Action.BROWSE);
            if (portletURL == null) {
                return null;
            }
            portletURL.setParameter("eventName", this.getEventName());
            portletURL.setParameter("selectedCategories", "{selectedCategories}");
            portletURL.setParameter("singleSelect", "{singleSelect}");
            portletURL.setParameter("vocabularyIds", "{vocabularyIds}");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            return portletURL;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected List<Map<String, Object>> getVocabularies() throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<Map<String, Object>> vocabularies = new ArrayList<Map<String, Object>>();
        List<AssetVocabulary> assetVocabularies = this.getAssetVocabularies();
        List<String[]> categoryIdsTitles = this.getCategoryIdsTitles();
        for (int i = 0; i < assetVocabularies.size(); ++i) {
            HashMap<String, Object> vocabulary = new HashMap<String, Object>();
            vocabularies.add(vocabulary);
            AssetVocabulary assetVocabulary = assetVocabularies.get(i);
            vocabulary.put("id", assetVocabulary.getVocabularyId());
            vocabulary.put("title", assetVocabulary.getTitle(themeDisplay.getLocale()));
            String vocabularyGroupName = "";
            if (assetVocabulary.getGroupId() != themeDisplay.getSiteGroupId()) {
                Group vocabularyGroup = GroupLocalServiceUtil.getGroup(assetVocabulary.getGroupId());
                vocabularyGroupName = vocabularyGroup.getDescriptiveName(themeDisplay.getLocale());
            }
            vocabulary.put("group", vocabularyGroupName);
            vocabulary.put("required", assetVocabulary.isRequired(PortalUtil.getClassNameId(this._className), this._classTypePK) && this._showRequiredLabel);
            String selectedCategoryIds = categoryIdsTitles.get(i)[0];
            String selectedCategoryIdTitles = categoryIdsTitles.get(i)[1];
            vocabulary.put("selectedCategoryIds", selectedCategoryIds);
            if (Validator.isNotNull(selectedCategoryIds)) {
                String[] categoryIds = selectedCategoryIds.split(",");
                String[] categoryTitles = selectedCategoryIdTitles.split("_CATEGORY_");
                ArrayList selectedItems = new ArrayList();
                for (int j = 0; j < categoryIds.length; ++j) {
                    HashMap<String, String> category = new HashMap<String, String>();
                    selectedItems.add(category);
                    category.put("label", categoryTitles[j]);
                    category.put("value", categoryIds[j]);
                }
                vocabulary.put("selectedItems", selectedItems);
            }
            vocabulary.put("singleSelect", !assetVocabulary.isMultiValued());
        }
        return vocabularies;
    }

    private String _getInputName() {
        return this._getNamespace() + this._hiddenInput + "_";
    }

    private String _getNamespace() {
        if (this._namespace != null) {
            return this._namespace;
        }
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        if (portletRequest == null || portletResponse == null) {
            this._namespace = AUIUtil.getNamespace(this.request);
            return this._namespace;
        }
        this._namespace = AUIUtil.getNamespace(portletRequest, portletResponse);
        return this._namespace;
    }
}

