/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.taglib.servlet.taglib;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.taglib.internal.servlet.ServletContextUtil;
import com.liferay.asset.taglib.servlet.taglib.AssetLinksTag;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class InputAssetLinksTag
extends AssetLinksTag {
    private static final String _PAGE = "/input_asset_links/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(InputAssetLinksTag.class);

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        String className;
        long assetEntryId;
        block4: {
            assetEntryId = this.getAssetEntryId();
            className = this.getClassName();
            long classPK = this.getClassPK();
            if (assetEntryId <= 0L && classPK > 0L) {
                try {
                    AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry(className, classPK);
                    if (assetEntry != null) {
                        assetEntryId = assetEntry.getEntryId();
                    }
                }
                catch (SystemException se) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug(se, se);
                }
            }
        }
        httpServletRequest.setAttribute("liferay-asset:input-asset-links:assetEntryId", (Object)String.valueOf(assetEntryId));
        httpServletRequest.setAttribute("liferay-asset:input-asset-links:className", (Object)className);
    }
}

