/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.taglib.servlet.taglib;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.taglib.internal.servlet.ServletContextUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.taglib.util.IncludeTag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class AssetMetadataTag
extends IncludeTag {
    private static final String _PAGE = "/asset_metadata/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(AssetMetadataTag.class);
    private String _className = "";
    private long _classPK;
    private boolean _filterByMetadata;
    private boolean _hasMetadata;
    private String[] _metadataFields;

    @Override
    public int doEndTag() throws JspException {
        if (this._hasMetadata) {
            return super.doEndTag();
        }
        return 6;
    }

    @Override
    public int doStartTag() throws JspException {
        if (ArrayUtil.isEmpty(this._metadataFields)) {
            return 0;
        }
        this._hasMetadata = true;
        return super.doStartTag();
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public String[] getMetadataFields() {
        return this._metadataFields;
    }

    public boolean isFilterByMetadata() {
        return this._filterByMetadata;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setFilterByMetadata(boolean filterByMetadata) {
        this._filterByMetadata = filterByMetadata;
    }

    public void setMetadataFields(String[] metadataFields) {
        this._metadataFields = metadataFields;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._className = "";
        this._classPK = 0L;
        this._filterByMetadata = false;
        this._hasMetadata = false;
        this._metadataFields = null;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry(this._className, this._classPK);
        httpServletRequest.setAttribute("liferay-asset:asset-metadata:assetEntry", (Object)assetEntry);
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(this._className);
        try {
            AssetRenderer<?> assetRenderer = assetRendererFactory.getAssetRenderer(this._classPK);
            httpServletRequest.setAttribute("liferay-asset:asset-metadata:assetRenderer", assetRenderer);
        }
        catch (PortalException pe) {
            _log.error(pe, pe);
        }
        httpServletRequest.setAttribute("liferay-asset:asset-metadata:className", (Object)this._className);
        httpServletRequest.setAttribute("liferay-asset:asset-metadata:classPK", (Object)this._classPK);
        httpServletRequest.setAttribute("liferay-asset:asset-metadata:filterByMetadata", (Object)this._filterByMetadata);
        httpServletRequest.setAttribute("liferay-asset:asset-metadata:metadataFields", (Object)this._metadataFields);
    }
}

