/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.taglib.servlet.taglib;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetLinkLocalServiceUtil;
import com.liferay.asset.taglib.internal.servlet.ServletContextUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class AssetLinksTag
extends IncludeTag {
    private static final String _PAGE = "/asset_links/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(AssetLinksTag.class);
    private long _assetEntryId;
    private String _className = "";
    private long _classPK;
    private String _page = "/asset_links/page.jsp";
    private PortletURL _portletURL;
    private boolean _viewInContext = true;

    public long getAssetEntryId() {
        return this._assetEntryId;
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public PortletURL getPortletURL() {
        return this._portletURL;
    }

    public boolean getViewInContext() {
        return this._viewInContext;
    }

    public boolean isViewInContext() {
        return this._viewInContext;
    }

    public void setAssetEntryId(long assetEntryId) {
        this._assetEntryId = assetEntryId;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    public void setPortletURL(PortletURL portletURL) {
        this._portletURL = portletURL;
    }

    public void setViewInContext(boolean viewInContext) {
        this._viewInContext = viewInContext;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._assetEntryId = 0L;
        this._className = "";
        this._classPK = 0L;
        this._page = _PAGE;
        this._portletURL = null;
        this._viewInContext = true;
    }

    @Override
    protected String getPage() {
        return this._page;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        block9: {
            if (this._page == null) {
                return;
            }
            if (this._assetEntryId <= 0L && this._classPK > 0L) {
                try {
                    AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry(this._className, this._classPK);
                    if (assetEntry != null) {
                        this._assetEntryId = assetEntry.getEntryId();
                    }
                }
                catch (SystemException se) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug(se, se);
                }
            }
        }
        if (this._assetEntryId <= 0L) {
            this._page = null;
            return;
        }
        List<Tuple> assetLinkEntries = null;
        try {
            assetLinkEntries = this._getAssetLinkEntries();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ListUtil.isEmpty(assetLinkEntries)) {
            this._page = null;
            return;
        }
        httpServletRequest.setAttribute("liferay-asset:asset-links:assetLinkEntries", assetLinkEntries);
    }

    private List<Tuple> _getAssetLinkEntries() throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        LiferayPortletRequest liferayPortletRequest = PortalUtil.getLiferayPortletRequest(portletRequest);
        PortletResponse portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse(portletResponse);
        ArrayList<Tuple> assetLinkEntries = new ArrayList<Tuple>();
        List<AssetLink> assetLinks = AssetLinkLocalServiceUtil.getDirectLinks(this._assetEntryId);
        for (AssetLink assetLink : assetLinks) {
            AssetRenderer<?> assetRenderer;
            AssetEntry assetLinkEntry = null;
            assetLinkEntry = assetLink.getEntryId1() == this._assetEntryId ? AssetEntryLocalServiceUtil.getEntry(assetLink.getEntryId2()) : AssetEntryLocalServiceUtil.getEntry(assetLink.getEntryId1());
            if (!assetLinkEntry.isVisible()) continue;
            AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId(assetLinkEntry.getClassNameId());
            if (assetRendererFactory == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("No asset renderer factory found for class " + PortalUtil.getClassName(assetLinkEntry.getClassNameId()));
                continue;
            }
            if (!assetRendererFactory.isActive(themeDisplay.getCompanyId()) || !(assetRenderer = assetRendererFactory.getAssetRenderer(assetLinkEntry.getClassPK())).hasViewPermission(themeDisplay.getPermissionChecker())) continue;
            Group group = GroupLocalServiceUtil.getGroup(assetLinkEntry.getGroupId());
            Group scopeGroup = themeDisplay.getScopeGroup();
            if (group.isStaged() && group.isStagingGroup() ^ scopeGroup.isStagingGroup()) continue;
            String viewURL = this._getViewURL(assetLinkEntry, assetRenderer, assetRendererFactory.getType(), liferayPortletRequest, liferayPortletResponse, themeDisplay);
            assetLinkEntries.add(new Tuple(assetLinkEntry, viewURL));
        }
        return assetLinkEntries;
    }

    private String _getViewURL(AssetEntry assetLinkEntry, AssetRenderer assetRenderer, String type, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, ThemeDisplay themeDisplay) throws Exception {
        PortletURL viewAssetURL = null;
        if (this._portletURL != null) {
            viewAssetURL = PortletURLUtil.clone(this._portletURL, liferayPortletResponse);
        } else {
            viewAssetURL = PortletProviderUtil.getPortletURL(this.request, assetRenderer.getClassName(), PortletProvider.Action.VIEW);
            viewAssetURL.setParameter("redirect", themeDisplay.getURLCurrent());
            viewAssetURL.setWindowState(WindowState.MAXIMIZED);
        }
        viewAssetURL.setParameter("assetEntryId", String.valueOf(assetLinkEntry.getEntryId()));
        viewAssetURL.setParameter("type", type);
        String urlTitle = assetRenderer.getUrlTitle(themeDisplay.getLocale());
        if (Validator.isNotNull(urlTitle)) {
            if (assetRenderer.getGroupId() != themeDisplay.getSiteGroupId()) {
                viewAssetURL.setParameter("groupId", String.valueOf(assetRenderer.getGroupId()));
            }
            viewAssetURL.setParameter("urlTitle", urlTitle);
        }
        String viewURL = null;
        if (this._viewInContext) {
            String noSuchEntryRedirect = viewAssetURL.toString();
            String urlViewInContext = assetRenderer.getURLViewInContext(liferayPortletRequest, liferayPortletResponse, noSuchEntryRedirect);
            if (Validator.isNotNull(urlViewInContext) && !Objects.equals(urlViewInContext, noSuchEntryRedirect)) {
                urlViewInContext = HttpUtil.setParameter(urlViewInContext, "inheritRedirect", Boolean.TRUE);
                urlViewInContext = HttpUtil.setParameter(urlViewInContext, "redirect", themeDisplay.getURLCurrent());
            }
            viewURL = urlViewInContext;
        }
        if (Validator.isNull(viewURL)) {
            viewURL = viewAssetURL.toString();
        }
        return viewURL;
    }
}

