/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.taglib.servlet.taglib;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.taglib.internal.servlet.ServletContextUtil;
import com.liferay.asset.util.AssetEntryUsageRecorder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.taglib.util.IncludeTag;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class AssetEntryUsagesTag
extends IncludeTag {
    private static final String _PAGE = "/asset_entry_usages/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryUsagesTag.class);
    private String _className;
    private long _classPK;

    @Override
    public int doStartTag() throws JspException {
        block3: {
            AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry(this._className, this._classPK);
            try {
                Map<String, AssetEntryUsageRecorder> assetEntryUsageRecorders = ServletContextUtil.getAssetEntryUsageRecorders();
                AssetEntryUsageRecorder assetEntryUsageRecorder = assetEntryUsageRecorders.get(assetEntry.getClassName());
                if (assetEntryUsageRecorder != null) {
                    assetEntryUsageRecorder.record(assetEntry);
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug(StringBundler.concat("Unable to check asset entry usages for class name ", this._className, " and class PK ", this._classPK), pe);
            }
        }
        this.request.setAttribute("FRAGMENT_COLLECTION_CONTRIBUTOR_TRACKER", (Object)ServletContextUtil.getFragmentCollectionContributorTracker());
        this.request.setAttribute("FRAGMENT_RENDERER_TRACKER", (Object)ServletContextUtil.getFragmentRendererTracker());
        return super.doStartTag();
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._className = null;
        this._classPK = 0L;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("liferay-asset:asset-entry-usages:className", (Object)this._className);
        httpServletRequest.setAttribute("liferay-asset:asset-entry-usages:classPK", (Object)String.valueOf(this._classPK));
    }
}

