/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.taglib.servlet.taglib;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.Renderer;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.taglib.internal.servlet.ServletContextUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class AssetDisplayTag
extends IncludeTag {
    private static final Log _log = LogFactoryUtil.getLog(AssetDisplayTag.class);
    private int _abstractLength = 200;
    private AssetEntry _assetEntry;
    private AssetRendererFactory<?> _assetRendererFactory;
    private String _className;
    private long _classPK;
    private String _page;
    private Renderer _renderer;
    private boolean _showComments;
    private boolean _showExtraInfo;
    private boolean _showHeader;
    private String _template = "full_content";
    private String _viewURL;

    @Override
    public int doEndTag() throws JspException {
        try {
            this.callSetAttributes();
            this.doInclude(null, false);
            int n = 6;
            return n;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.clearDynamicAttributes();
            this.clearParams();
            this.clearProperties();
            this.cleanUpSetAttributes();
            if (!ServerDetector.isResin()) {
                this.setPage(null);
                this.setUseCustomPage(true);
                this.cleanUp();
            }
        }
    }

    public int getAbstractLength() {
        return this._abstractLength;
    }

    public AssetEntry getAssetEntry() {
        return this._assetEntry;
    }

    public AssetRenderer<?> getAssetRenderer() {
        if (this._renderer instanceof AssetRenderer) {
            return (AssetRenderer)this._renderer;
        }
        return null;
    }

    public AssetRendererFactory<?> getAssetRendererFactory() {
        return this._assetRendererFactory;
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public Renderer getRenderer() {
        return this._renderer;
    }

    public String getTemplate() {
        return this._template;
    }

    public String getViewURL() {
        return this._viewURL;
    }

    public boolean isShowComments() {
        return this._showComments;
    }

    public boolean isShowExtraInfo() {
        return this._showExtraInfo;
    }

    public boolean isShowHeader() {
        return this._showHeader;
    }

    public void setAbstractLength(int abstractLength) {
        this._abstractLength = abstractLength;
    }

    public void setAssetEntry(AssetEntry assetEntry) {
        this._assetEntry = assetEntry;
    }

    public void setAssetRenderer(AssetRenderer<?> assetRenderer) {
        this._renderer = assetRenderer;
    }

    public void setAssetRendererFactory(AssetRendererFactory<?> assetRendererFactory) {
        this._assetRendererFactory = assetRendererFactory;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    public void setRenderer(Renderer renderer) {
        this._renderer = renderer;
    }

    public void setShowComments(boolean showComments) {
        this._showComments = showComments;
    }

    public void setShowExtraInfo(boolean showExtraInfo) {
        this._showExtraInfo = showExtraInfo;
    }

    public void setShowHeader(boolean showHeader) {
        this._showHeader = showHeader;
    }

    public void setTemplate(String template) {
        this._template = template;
    }

    public void setViewURL(String viewURL) {
        this._viewURL = viewURL;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._abstractLength = 200;
        this._assetEntry = null;
        this._assetRendererFactory = null;
        this._className = null;
        this._classPK = 0L;
        this._page = null;
        this._renderer = null;
        this._showComments = false;
        this._showExtraInfo = false;
        this._showHeader = false;
        this._template = "full_content";
        this._viewURL = null;
    }

    @Override
    protected String getPage() {
        return this._page;
    }

    @Override
    protected void includePage(String page, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            boolean include = this._renderer.include(this.request, httpServletResponse, this._template);
            if (include) {
                return;
            }
        }
        catch (Exception e) {
            _log.error("Unable to include asset renderer template", e);
        }
        super.includePage("/asset_display/" + this._template + ".jsp", httpServletResponse);
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("ASSET_ENTRY_ABSTRACT_LENGTH", (Object)this._abstractLength);
        AssetEntry assetEntry = this._assetEntry;
        if (assetEntry == null) {
            if (Validator.isNotNull(this._className) && this._classPK > 0L) {
                assetEntry = AssetEntryLocalServiceUtil.fetchEntry(this._className, this._classPK);
            } else if (this._renderer != null) {
                assetEntry = AssetEntryLocalServiceUtil.fetchEntry(this._renderer.getClassName(), this._renderer.getClassPK());
            }
        }
        httpServletRequest.setAttribute("liferay-asset:asset-display:assetEntry", (Object)assetEntry);
        if (this._renderer == null && assetEntry != null) {
            this._renderer = assetEntry.getAssetRenderer();
        }
        if (this._renderer instanceof AssetRenderer) {
            AssetRenderer assetRenderer = (AssetRenderer)this._renderer;
            httpServletRequest.setAttribute("ASSET_RENDERER", (Object)assetRenderer);
        } else {
            httpServletRequest.setAttribute("liferay-asset:asset-display:renderer", (Object)this._renderer);
        }
        AssetRendererFactory<?> assetRendererFactory = this._assetRendererFactory;
        if (assetRendererFactory == null && assetEntry != null) {
            assetRendererFactory = assetEntry.getAssetRendererFactory();
        }
        if (assetRendererFactory != null) {
            httpServletRequest.setAttribute("ASSET_RENDERER_FACTORY", assetRendererFactory);
        }
        httpServletRequest.setAttribute("ASSET_ENTRY_VIEW_URL", (Object)this._viewURL);
        this.addParam("showComments", String.valueOf(this._showComments));
        this.addParam("showExtraInfo", String.valueOf(this._showExtraInfo));
        this.addParam("showHeader", String.valueOf(this._showHeader));
    }
}

