/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.taglib.internal.display.context;

import com.liferay.asset.display.page.item.selector.criterion.AssetDisplayPageSelectorCriterion;
import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalServiceUtil;
import com.liferay.asset.display.page.util.AssetDisplayPageHelper;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.taglib.internal.info.display.contributor.InfoDisplayContributorTrackerUtil;
import com.liferay.asset.taglib.internal.item.selector.ItemSelectorUtil;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayContributorTracker;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.item.selector.BaseItemSelectorCriterion;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.criteria.UUIDItemSelectorReturnType;
import com.liferay.layout.item.selector.criterion.LayoutItemSelectorCriterion;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SelectAssetDisplayPageDisplayContext {
    private AssetDisplayPageEntry _assetDisplayPageEntry;
    private Long _assetDisplayPageId;
    private final Long _classNameId;
    private Long _classPK;
    private final Long _classTypeId;
    private Integer _displayPageType;
    private final String _eventName;
    private final long _groupId;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final boolean _showPortletLayouts;
    private final boolean _showViewInContextLink;

    public SelectAssetDisplayPageDisplayContext(HttpServletRequest httpServletRequest, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._httpServletRequest = httpServletRequest;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._classNameId = GetterUtil.getLong(this._httpServletRequest.getAttribute("liferay-asset:select-asset-display-page:classNameId"));
        this._classPK = GetterUtil.getLong(this._httpServletRequest.getAttribute("liferay-asset:select-asset-display-page:classPK"));
        this._classTypeId = GetterUtil.getLong(this._httpServletRequest.getAttribute("liferay-asset:select-asset-display-page:classTypeId"));
        this._eventName = GetterUtil.getString(this._httpServletRequest.getAttribute("liferay-asset:select-asset-display-page:eventName"), this._liferayPortletResponse.getNamespace() + "selectDisplayPage");
        this._groupId = GetterUtil.getLong(this._httpServletRequest.getAttribute("liferay-asset:select-asset-display-page:groupId"));
        this._showPortletLayouts = GetterUtil.getBoolean(this._httpServletRequest.getAttribute("liferay-asset:select-asset-display-page:showPortletLayouts"));
        this._showViewInContextLink = GetterUtil.getBoolean(this._httpServletRequest.getAttribute("liferay-asset:select-asset-display-page:showViewInContextLink"));
    }

    public long getAssetDisplayPageId() {
        if (this._assetDisplayPageId != null) {
            return this._assetDisplayPageId;
        }
        this._assetDisplayPageId = 0L;
        AssetDisplayPageEntry assetDisplayPageEntry = this._getAssetDisplayPageEntry();
        if (assetDisplayPageEntry != null) {
            this._assetDisplayPageId = assetDisplayPageEntry.getLayoutPageTemplateEntryId();
        }
        return this._assetDisplayPageId;
    }

    public String getAssetDisplayPageItemSelectorURL() throws PortalException {
        ItemSelector itemSelector = ItemSelectorUtil.getItemSelector();
        ArrayList<BaseItemSelectorCriterion> itemSelectorCriteria = new ArrayList<BaseItemSelectorCriterion>();
        AssetDisplayPageSelectorCriterion assetDisplayPageSelectorCriterion = new AssetDisplayPageSelectorCriterion();
        assetDisplayPageSelectorCriterion.setClassNameId(this._classNameId);
        assetDisplayPageSelectorCriterion.setClassTypeId(this._classTypeId);
        assetDisplayPageSelectorCriterion.setDesiredItemSelectorReturnTypes(new UUIDItemSelectorReturnType());
        itemSelectorCriteria.add(assetDisplayPageSelectorCriterion);
        if (this._showPortletLayouts) {
            LayoutItemSelectorCriterion layoutItemSelectorCriterion = new LayoutItemSelectorCriterion();
            layoutItemSelectorCriterion.setCheckDisplayPage(true);
            layoutItemSelectorCriterion.setDesiredItemSelectorReturnTypes(new UUIDItemSelectorReturnType());
            layoutItemSelectorCriterion.setShowHiddenPages(true);
            itemSelectorCriteria.add(layoutItemSelectorCriterion);
        }
        PortletURL itemSelectorURL = itemSelector.getItemSelectorURL(RequestBackedPortletURLFactoryUtil.create(this._liferayPortletRequest), this._eventName, itemSelectorCriteria.toArray(new ItemSelectorCriterion[0]));
        itemSelectorURL.setParameter("layoutUuid", this.getLayoutUuid());
        return itemSelectorURL.toString();
    }

    public int getAssetDisplayPageType() {
        if (this._displayPageType != null) {
            return this._displayPageType;
        }
        if (this._classPK == 0L) {
            this._displayPageType = 1;
            return this._displayPageType;
        }
        AssetDisplayPageEntry assetDisplayPageEntry = this._getAssetDisplayPageEntry();
        this._displayPageType = assetDisplayPageEntry == null ? Integer.valueOf(0) : Integer.valueOf(assetDisplayPageEntry.getType());
        return this._displayPageType;
    }

    public String getDefaultAssetDisplayPageName() {
        LayoutPageTemplateEntry defaultAssetDisplayPage = LayoutPageTemplateEntryServiceUtil.fetchDefaultLayoutPageTemplateEntry(this._groupId, this._classNameId, this._classTypeId);
        if (defaultAssetDisplayPage != null) {
            return defaultAssetDisplayPage.getName();
        }
        return null;
    }

    public String getEventName() {
        return this._eventName;
    }

    public String getLayoutUuid() {
        if (this._classPK == 0L) {
            return null;
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)this._classNameId, (long)this._classPK);
        if (assetEntry == null) {
            return null;
        }
        return assetEntry.getLayoutUuid();
    }

    public String getSpecificAssetDisplayPageName() throws Exception {
        String assetDisplayPageName = this._getAssetDisplayPageName();
        if (Validator.isNotNull(assetDisplayPageName)) {
            return assetDisplayPageName;
        }
        String layoutUuid = this.getLayoutUuid();
        if (Validator.isNull(layoutUuid)) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout selLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId(layoutUuid, themeDisplay.getSiteGroupId(), false);
        if (selLayout == null) {
            selLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId(layoutUuid, themeDisplay.getSiteGroupId(), true);
        }
        if (selLayout != null) {
            return this._getLayoutBreadcrumb(selLayout);
        }
        return null;
    }

    public String getURLViewInContext() {
        if (this._classPK <= 0L) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId(this._classNameId);
        try {
            AssetRenderer<?> assetRenderer = assetRendererFactory.getAssetRenderer(this._classPK);
            String viewInContextURL = assetRenderer.getURLViewInContext(this._liferayPortletRequest, this._liferayPortletResponse, themeDisplay.getURLCurrent());
            return HttpUtil.addParameter(viewInContextURL, "p_l_mode", "preview");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean isAssetDisplayPageTypeDefault() {
        return this.getAssetDisplayPageType() == 1;
    }

    public boolean isAssetDisplayPageTypeSpecific() {
        return this.getAssetDisplayPageType() == 2;
    }

    public boolean isShowViewInContextLink() {
        if (!this._showViewInContextLink) {
            return false;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            InfoDisplayContributorTracker infoDisplayContributorTracker = InfoDisplayContributorTrackerUtil.getInfoDisplayContributorTracker();
            InfoDisplayContributor infoDisplayContributor = infoDisplayContributorTracker.getInfoDisplayContributor(PortalUtil.getClassName(this._classNameId));
            if (infoDisplayContributor == null) {
                return false;
            }
            InfoDisplayObjectProvider infoDisplayObjectProvider = infoDisplayContributor.getInfoDisplayObjectProvider(this._classPK);
            if (infoDisplayObjectProvider == null) {
                return false;
            }
            if (!AssetDisplayPageHelper.hasAssetDisplayPage(themeDisplay.getScopeGroupId(), infoDisplayObjectProvider.getClassNameId(), infoDisplayObjectProvider.getClassPK(), infoDisplayObjectProvider.getClassTypeId())) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean isURLViewInContext() throws Exception {
        if (this._classPK == 0L) {
            return false;
        }
        return !Validator.isNull(this.getLayoutUuid()) || !Validator.isNull(this.getURLViewInContext());
    }

    private AssetDisplayPageEntry _getAssetDisplayPageEntry() {
        if (this._assetDisplayPageEntry != null) {
            return this._assetDisplayPageEntry;
        }
        AssetDisplayPageEntry assetDisplayPageEntry = AssetDisplayPageEntryLocalServiceUtil.fetchAssetDisplayPageEntry(this._groupId, this._classNameId, this._classPK);
        if (assetDisplayPageEntry != null) {
            this._assetDisplayPageEntry = assetDisplayPageEntry;
        }
        return this._assetDisplayPageEntry;
    }

    private String _getAssetDisplayPageName() {
        long assetDisplayPageId = this.getAssetDisplayPageId();
        if (assetDisplayPageId == 0L) {
            return "";
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntry(assetDisplayPageId);
        if (layoutPageTemplateEntry == null) {
            return "";
        }
        return layoutPageTemplateEntry.getName();
    }

    private String _getLayoutBreadcrumb(Layout layout) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Locale locale = themeDisplay.getLocale();
        List<Layout> ancestors = layout.getAncestors();
        StringBundler sb = new StringBundler(4 * ancestors.size() + 5);
        if (layout.isPrivateLayout()) {
            sb.append(LanguageUtil.get(this._httpServletRequest, "private-pages"));
        } else {
            sb.append(LanguageUtil.get(this._httpServletRequest, "public-pages"));
        }
        sb.append(" ");
        sb.append(">");
        sb.append(" ");
        Collections.reverse(ancestors);
        for (Layout ancestor : ancestors) {
            sb.append(HtmlUtil.escape(ancestor.getName(locale)));
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
        }
        sb.append(HtmlUtil.escape(layout.getName(locale)));
        return sb.toString();
    }
}

