/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.taglib.internal.display.context;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.model.AssetEntryUsage;
import com.liferay.asset.service.AssetEntryUsageLocalServiceUtil;
import com.liferay.asset.util.AssetEntryUsageActionMenuContributor;
import com.liferay.asset.util.AssetEntryUsageActionMenuContributorRegistryUtil;
import com.liferay.asset.util.comparator.AssetEntryUsageModifiedDateComparator;
import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class AssetEntryUsagesDisplayContext {
    private final AssetEntry _assetEntry;
    private final FragmentCollectionContributorTracker _fragmentCollectionContributorTracker;
    private final FragmentRendererTracker _fragmentRendererTracker;
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private String _redirect;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final ResourceBundle _resourceBundle;
    private SearchContainer _searchContainer;
    private final ThemeDisplay _themeDisplay;

    public AssetEntryUsagesDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, String className, long classPK) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._assetEntry = AssetEntryLocalServiceUtil.fetchEntry(className, classPK);
        this._fragmentCollectionContributorTracker = (FragmentCollectionContributorTracker)renderRequest.getAttribute("FRAGMENT_COLLECTION_CONTRIBUTOR_TRACKER");
        this._fragmentRendererTracker = (FragmentRendererTracker)renderRequest.getAttribute("FRAGMENT_RENDERER_TRACKER");
        this._themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._resourceBundle = ResourceBundleUtil.getBundle("content.Language", this._themeDisplay.getLocale(), this.getClass());
    }

    public int getAllUsageCount() {
        return AssetEntryUsageLocalServiceUtil.getAssetEntryUsagesCount(this._assetEntry.getEntryId());
    }

    public List<DropdownItem> getAssetEntryUsageActionDropdownItems(AssetEntryUsage assetEntryUsage) {
        if (!this.isShowPreview(assetEntryUsage)) {
            return Collections.emptyList();
        }
        AssetEntryUsageActionMenuContributor assetEntryUsageActionMenuContributor = AssetEntryUsageActionMenuContributorRegistryUtil.getAssetEntryUsageActionMenuContributor(this._assetEntry.getClassName());
        if (assetEntryUsageActionMenuContributor == null) {
            return Collections.emptyList();
        }
        return assetEntryUsageActionMenuContributor.getAssetEntryUsageActionMenu(assetEntryUsage, PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest));
    }

    public String getAssetEntryUsageName(AssetEntryUsage assetEntryUsage) {
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        if (assetEntryUsage.getType() == 2) {
            Layout layout = LayoutLocalServiceUtil.fetchLayout(assetEntryUsage.getPlid());
            if (layout == null) {
                return "";
            }
            if (!this._isDraft(layout)) {
                return layout.getName(this._themeDisplay.getLocale());
            }
            StringBundler sb = new StringBundler(4);
            sb.append(layout.getName(this._themeDisplay.getLocale()));
            sb.append(" (");
            sb.append(LanguageUtil.get(this._themeDisplay.getLocale(), "draft"));
            sb.append(")");
            return sb.toString();
        }
        long plid = assetEntryUsage.getPlid();
        Layout layout = LayoutLocalServiceUtil.fetchLayout(assetEntryUsage.getPlid());
        if (layout.getClassNameId() > 0L && layout.getClassPK() > 0L) {
            plid = layout.getClassPK();
        }
        if ((layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByPlid(plid)) == null) {
            return "";
        }
        if (!this._isDraft(layout)) {
            return layoutPageTemplateEntry.getName();
        }
        StringBundler sb = new StringBundler(4);
        sb.append(layoutPageTemplateEntry.getName());
        sb.append(" (");
        sb.append(LanguageUtil.get(this._themeDisplay.getLocale(), "draft"));
        sb.append(")");
        return sb.toString();
    }

    public String getAssetEntryUsageTypeLabel(AssetEntryUsage assetEntryUsage) {
        if (assetEntryUsage.getType() == 1) {
            return "display-page-template";
        }
        if (assetEntryUsage.getType() == 2) {
            return "page";
        }
        return "page-template";
    }

    public String getAssetEntryUsageWhereLabel(AssetEntryUsage assetEntryUsage) throws PortalException {
        if (assetEntryUsage.getContainerType() != PortalUtil.getClassNameId(FragmentEntryLink.class)) {
            String portletTitle = PortalUtil.getPortletTitle(PortletIdCodec.decodePortletName(assetEntryUsage.getContainerKey()), this._themeDisplay.getLocale());
            return LanguageUtil.format(this._resourceBundle, "x-widget", (Object)portletTitle);
        }
        FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.getFragmentEntryLink(GetterUtil.getLong(assetEntryUsage.getContainerKey()));
        String name = this._getFragmentEntryName(fragmentEntryLink);
        if (Validator.isNull(name)) {
            return "";
        }
        if (this._getType(fragmentEntryLink) == 1) {
            return LanguageUtil.format(this._resourceBundle, "x-element", (Object)name);
        }
        return LanguageUtil.format(this._resourceBundle, "x-section", (Object)name);
    }

    public int getDisplayPagesUsageCount() {
        return AssetEntryUsageLocalServiceUtil.getAssetEntryUsagesCount(this._assetEntry.getEntryId(), 1);
    }

    public String getNavigation() {
        if (Validator.isNotNull(this._navigation)) {
            return this._navigation;
        }
        this._navigation = ParamUtil.getString((PortletRequest)this._renderRequest, "navigation", "all");
        return this._navigation;
    }

    public int getPagesUsageCount() {
        return AssetEntryUsageLocalServiceUtil.getAssetEntryUsagesCount(this._assetEntry.getEntryId(), 2);
    }

    public int getPageTemplatesUsageCount() {
        return AssetEntryUsageLocalServiceUtil.getAssetEntryUsagesCount(this._assetEntry.getEntryId(), 3);
    }

    public PortletURL getPortletURL() throws PortletException {
        PortletURL currentURLObj = PortletURLUtil.getCurrent((PortletRequest)this._renderRequest, (MimeResponse)this._renderResponse);
        return PortletURLUtil.clone(currentURLObj, (MimeResponse)this._renderResponse);
    }

    public String getPreviewURL(AssetEntryUsage assetEntryUsage) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String layoutURL = null;
        if (assetEntryUsage.getContainerType() == PortalUtil.getClassNameId(FragmentEntryLink.class)) {
            Layout layout = LayoutLocalServiceUtil.fetchLayout(assetEntryUsage.getPlid());
            layoutURL = PortalUtil.getLayoutFriendlyURL(layout, themeDisplay);
            layoutURL = HttpUtil.setParameter(layoutURL, "previewAssetEntryId", String.valueOf(assetEntryUsage.getAssetEntryId()));
            layoutURL = HttpUtil.setParameter(layoutURL, "previewAssetEntryType", String.valueOf(0));
        } else {
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)this._renderRequest, assetEntryUsage.getContainerKey(), assetEntryUsage.getPlid(), "RENDER_PHASE");
            portletURL.setParameter("previewAssetEntryId", String.valueOf(assetEntryUsage.getAssetEntryId()));
            portletURL.setParameter("previewAssetEntryType", String.valueOf(0));
            layoutURL = portletURL.toString();
        }
        String portletURLString = HttpUtil.addParameter(layoutURL, "p_l_mode", "preview");
        return portletURLString + "#portlet_" + assetEntryUsage.getContainerKey();
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this._renderRequest, "redirect");
        return this._redirect;
    }

    public SearchContainer getSearchContainer() throws PortletException {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        SearchContainer<AssetEntryUsage> assetEntryUsagesSearchContainer = new SearchContainer<AssetEntryUsage>((PortletRequest)this._renderRequest, this.getPortletURL(), null, "there-are-no-asset-entry-usages");
        boolean orderByAsc = false;
        String orderByType = this._getOrderByType();
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        AssetEntryUsageModifiedDateComparator orderByComparator = new AssetEntryUsageModifiedDateComparator(orderByAsc);
        assetEntryUsagesSearchContainer.setOrderByCol(this._getOrderByCol());
        assetEntryUsagesSearchContainer.setOrderByComparator(orderByComparator);
        assetEntryUsagesSearchContainer.setOrderByType(this._getOrderByType());
        List<AssetEntryUsage> assetEntryUsages = null;
        int assetEntryUsagesCount = 0;
        if (Objects.equals(this.getNavigation(), "pages")) {
            assetEntryUsages = AssetEntryUsageLocalServiceUtil.getAssetEntryUsages(this._assetEntry.getEntryId(), 2, assetEntryUsagesSearchContainer.getStart(), assetEntryUsagesSearchContainer.getEnd(), orderByComparator);
            assetEntryUsagesCount = this.getPagesUsageCount();
        } else if (Objects.equals(this.getNavigation(), "page-templates")) {
            assetEntryUsages = AssetEntryUsageLocalServiceUtil.getAssetEntryUsages(this._assetEntry.getEntryId(), 3, assetEntryUsagesSearchContainer.getStart(), assetEntryUsagesSearchContainer.getEnd(), orderByComparator);
            assetEntryUsagesCount = this.getPageTemplatesUsageCount();
        } else if (Objects.equals(this.getNavigation(), "display-page-templates")) {
            assetEntryUsages = AssetEntryUsageLocalServiceUtil.getAssetEntryUsages(this._assetEntry.getEntryId(), 1, assetEntryUsagesSearchContainer.getStart(), assetEntryUsagesSearchContainer.getEnd(), orderByComparator);
            assetEntryUsagesCount = this.getDisplayPagesUsageCount();
        } else {
            assetEntryUsages = AssetEntryUsageLocalServiceUtil.getAssetEntryUsages(this._assetEntry.getEntryId(), assetEntryUsagesSearchContainer.getStart(), assetEntryUsagesSearchContainer.getEnd(), orderByComparator);
            assetEntryUsagesCount = this.getAllUsageCount();
        }
        assetEntryUsagesSearchContainer.setResults(assetEntryUsages);
        assetEntryUsagesSearchContainer.setTotal(assetEntryUsagesCount);
        this._searchContainer = assetEntryUsagesSearchContainer;
        return this._searchContainer;
    }

    public boolean isShowPreview(AssetEntryUsage assetEntryUsage) {
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        if (assetEntryUsage.getType() == 2) {
            return true;
        }
        if (assetEntryUsage.getType() == 1) {
            return false;
        }
        if (assetEntryUsage.getType() != 3) {
            return false;
        }
        long plid = assetEntryUsage.getPlid();
        Layout layout = LayoutLocalServiceUtil.fetchLayout(plid);
        if (layout.getClassNameId() > 0L && layout.getClassPK() > 0L) {
            plid = layout.getClassPK();
        }
        if ((layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByPlid(plid)) == null) {
            return false;
        }
        return layoutPageTemplateEntry.getType() != 2;
    }

    private String _getFragmentEntryName(FragmentEntryLink fragmentEntryLink) {
        FragmentEntry fragmentEntry = FragmentEntryLocalServiceUtil.fetchFragmentEntry(fragmentEntryLink.getFragmentEntryId());
        if (fragmentEntry != null) {
            return fragmentEntry.getName();
        }
        String rendererKey = fragmentEntryLink.getRendererKey();
        if (Validator.isNull(rendererKey)) {
            return "";
        }
        Map<String, FragmentEntry> fragmentEntries = this._fragmentCollectionContributorTracker.getFragmentEntries();
        FragmentEntry contributedFragmentEntry = fragmentEntries.get(rendererKey);
        if (contributedFragmentEntry != null) {
            return contributedFragmentEntry.getName();
        }
        FragmentRenderer fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer(fragmentEntryLink.getRendererKey());
        if (fragmentRenderer != null) {
            return fragmentRenderer.getLabel(this._themeDisplay.getLocale());
        }
        return "";
    }

    private String _getOrderByCol() {
        if (Validator.isNotNull(this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, "orderByCol", "modified-date");
        return this._orderByCol;
    }

    private String _getOrderByType() {
        if (Validator.isNotNull(this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, "orderByType", "asc");
        return this._orderByType;
    }

    private int _getType(FragmentEntryLink fragmentEntryLink) {
        FragmentEntry fragmentEntry = FragmentEntryLocalServiceUtil.fetchFragmentEntry(fragmentEntryLink.getFragmentEntryId());
        if (fragmentEntry != null) {
            return fragmentEntry.getType();
        }
        String rendererKey = fragmentEntryLink.getRendererKey();
        if (Validator.isNull(rendererKey)) {
            return 0;
        }
        Map<String, FragmentEntry> fragmentEntries = this._fragmentCollectionContributorTracker.getFragmentEntries();
        FragmentEntry contributedFragmentEntry = fragmentEntries.get(rendererKey);
        if (contributedFragmentEntry != null) {
            return contributedFragmentEntry.getType();
        }
        FragmentRenderer fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer(fragmentEntryLink.getRendererKey());
        if (fragmentRenderer != null) {
            return fragmentRenderer.getType();
        }
        return 0;
    }

    private boolean _isDraft(Layout layout) {
        return layout.getClassNameId() == PortalUtil.getClassNameId(Layout.class.getName());
    }
}

