/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.display.url.provider;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.info.display.url.provider.InfoEditURLProvider;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BaseAssetInfoEditURLProvider
implements InfoEditURLProvider<AssetEntry> {
    @Override
    public String getURL(AssetEntry assetEntry, HttpServletRequest httpServletRequest) throws Exception {
        if (assetEntry == null) {
            return "";
        }
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(assetEntry.getClassName());
        if (assetRendererFactory == null) {
            return "";
        }
        AssetRenderer<?> assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
        if (assetRenderer == null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!assetRenderer.hasEditPermission(themeDisplay.getPermissionChecker())) {
            return "";
        }
        PortletURL editAssetEntryURL = assetRenderer.getURLEdit(httpServletRequest, LiferayWindowState.NORMAL, themeDisplay.getURLCurrent());
        if (editAssetEntryURL == null) {
            return "";
        }
        editAssetEntryURL.setParameter("portletResource", assetRendererFactory.getPortletId());
        return editAssetEntryURL.toString();
    }
}

