/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.display.contributor;

import com.liferay.asset.info.display.contributor.AssetInfoDisplayContributor;
import com.liferay.asset.info.display.contributor.AssetInfoDisplayObjectProvider;
import com.liferay.asset.info.display.contributor.util.AssetInfoDisplayContributorFieldUtil;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.exception.NoSuchEntryException;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.model.VersionedAssetEntry;
import com.liferay.info.display.contributor.InfoDisplayField;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.info.display.contributor.field.InfoDisplayContributorField;
import com.liferay.info.display.contributor.field.InfoDisplayContributorFieldType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class BaseAssetInfoDisplayContributor<T>
implements AssetInfoDisplayContributor {
    @Override
    public Set<InfoDisplayField> getInfoDisplayFields(long classTypeId, Locale locale) throws PortalException {
        Set<InfoDisplayField> infoDisplayFields = this._getInfoDisplayFields(AssetEntry.class.getName(), locale);
        Set<InfoDisplayField> assetTypeInfoDisplayFields = this._getInfoDisplayFields(this.getClassName(), locale);
        infoDisplayFields.addAll(assetTypeInfoDisplayFields);
        List<InfoDisplayField> classTypeInfoDisplayFields = this.getClassTypeInfoDisplayFields(classTypeId, locale);
        infoDisplayFields.addAll(classTypeInfoDisplayFields);
        return infoDisplayFields;
    }

    @Override
    public Map<String, Object> getInfoDisplayFieldsValues(AssetEntry assetEntry, Locale locale) throws PortalException {
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId(assetEntry.getClassNameId());
        AssetRenderer<Object> assetRenderer = null;
        if (assetEntry instanceof VersionedAssetEntry) {
            VersionedAssetEntry versionedAssetEntry = (VersionedAssetEntry)assetEntry;
            assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK(), versionedAssetEntry.getVersionType());
        } else {
            assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
        }
        Object assetObject = assetRenderer.getAssetObject();
        return this._getParameterMap(assetEntry, assetObject, locale);
    }

    @Override
    public Object getInfoDisplayFieldValue(AssetEntry assetEntry, String fieldName, Locale locale) throws PortalException {
        Map<String, Object> infoDisplayFieldsValues = this.getInfoDisplayFieldsValues(assetEntry, locale);
        return infoDisplayFieldsValues.getOrDefault(fieldName, "");
    }

    @Override
    public InfoDisplayObjectProvider getInfoDisplayObjectProvider(long classPK) {
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId(PortalUtil.getClassNameId(this.getClassName()));
        try {
            AssetRenderer<?> assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
            AssetEntry assetEntry = assetRendererFactory.getAssetEntry(this.getClassName(), assetRenderer.getClassPK());
            return new AssetInfoDisplayObjectProvider(assetEntry);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public InfoDisplayObjectProvider<AssetEntry> getInfoDisplayObjectProvider(long groupId, String urlTitle) throws PortalException {
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId(PortalUtil.getClassNameId(this.getClassName()));
        AssetRenderer<?> assetRenderer = assetRendererFactory.getAssetRenderer(groupId, urlTitle);
        AssetEntry assetEntry = assetRendererFactory.getAssetEntry(this.getClassName(), assetRenderer.getClassPK());
        return new AssetInfoDisplayObjectProvider(assetEntry);
    }

    @Override
    public String getLabel(Locale locale) {
        return ResourceActionsUtil.getModelResource(locale, this.getClassName());
    }

    @Override
    public Map<String, Object> getVersionInfoDisplayFieldsValues(AssetEntry assetEntry, long versionClassPK, Locale locale) throws PortalException {
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId(assetEntry.getClassNameId());
        AssetRenderer<?> assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
        Object assetObject = assetRenderer.getAssetObject(versionClassPK);
        if (assetObject == null) {
            throw new NoSuchEntryException("No asset entry exists with version class PK " + versionClassPK);
        }
        return this._getParameterMap(assetEntry, assetObject, locale);
    }

    protected Object getClassTypeFieldValue(T assetEntryObject, String fieldName, Locale locale) {
        Map<String, Object> classTypeValues = this.getClassTypeValues(assetEntryObject, locale);
        return classTypeValues.getOrDefault(fieldName, "");
    }

    protected abstract Map<String, Object> getClassTypeValues(T var1, Locale var2);

    private Map<String, Object> _getAssetEntryInfoDisplayFieldsValues(AssetEntry assetEntry, Locale locale) throws PortalException {
        HashMap<String, Object> infoDisplayFieldsValues = new HashMap<String, Object>();
        for (InfoDisplayContributorField infoDisplayContributorField : this._getInfoDisplayContributorFields(AssetEntry.class.getName())) {
            infoDisplayFieldsValues.putIfAbsent(infoDisplayContributorField.getKey(), this._getInfoDisplayFieldValue(assetEntry, assetEntry, infoDisplayContributorField, locale));
        }
        return infoDisplayFieldsValues;
    }

    private List<InfoDisplayContributorField> _getInfoDisplayContributorFields(String className) {
        return AssetInfoDisplayContributorFieldUtil.getInfoDisplayContributorFields(className);
    }

    private Set<InfoDisplayField> _getInfoDisplayFields(String className, Locale locale) {
        LinkedHashSet<InfoDisplayField> infoDisplayFields = new LinkedHashSet<InfoDisplayField>();
        for (InfoDisplayContributorField infoDisplayContributorField : this._getInfoDisplayContributorFields(className)) {
            InfoDisplayContributorFieldType infoDisplayContributorFieldType = infoDisplayContributorField.getType();
            infoDisplayFields.add(new InfoDisplayField(infoDisplayContributorField.getKey(), infoDisplayContributorField.getLabel(locale), infoDisplayContributorFieldType.getValue()));
        }
        return infoDisplayFields;
    }

    private <T> Object _getInfoDisplayFieldValue(T model, AssetEntry assetEntry, InfoDisplayContributorField infoDisplayContributorField, Locale locale) throws SanitizerException {
        InfoDisplayContributorFieldType infoDisplayContributorFieldType = infoDisplayContributorField.getType();
        Object value = infoDisplayContributorField.getValue(model, locale);
        if (!Objects.equals((Object)InfoDisplayContributorFieldType.URL, (Object)infoDisplayContributorFieldType) && value instanceof String) {
            return SanitizerUtil.sanitize(assetEntry.getCompanyId(), assetEntry.getGroupId(), assetEntry.getUserId(), AssetEntry.class.getName(), assetEntry.getEntryId(), "text/html", "ALL", (String)value, null);
        }
        return value;
    }

    private Map<String, Object> _getParameterMap(AssetEntry assetEntry, T assetObject, Locale locale) throws PortalException {
        Map<String, Object> parameterMap = this._getAssetEntryInfoDisplayFieldsValues(assetEntry, locale);
        List<InfoDisplayContributorField> infoDisplayContributorFields = AssetInfoDisplayContributorFieldUtil.getInfoDisplayContributorFields(this.getClassName());
        for (InfoDisplayContributorField infoDisplayContributorField : infoDisplayContributorFields) {
            Object fieldValue = this._getInfoDisplayFieldValue(assetObject, assetEntry, infoDisplayContributorField, locale);
            parameterMap.putIfAbsent(infoDisplayContributorField.getKey(), fieldValue);
        }
        Map<String, Object> classTypeValues = this.getClassTypeValues(assetObject, locale);
        parameterMap.putAll(classTypeValues);
        return parameterMap;
    }
}

