/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.display.contributor;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;

public class AssetInfoDisplayObjectProvider
implements InfoDisplayObjectProvider<AssetEntry> {
    private final AssetEntry _assetEntry;

    public AssetInfoDisplayObjectProvider(AssetEntry assetEntry) {
        this._assetEntry = assetEntry;
    }

    @Override
    public long getClassNameId() {
        return this._assetEntry.getClassNameId();
    }

    @Override
    public long getClassPK() {
        return this._assetEntry.getClassPK();
    }

    @Override
    public long getClassTypeId() {
        return this._assetEntry.getClassTypeId();
    }

    @Override
    public String getDescription(Locale locale) {
        return this._assetEntry.getDescription(locale);
    }

    @Override
    public AssetEntry getDisplayObject() {
        return this._assetEntry;
    }

    @Override
    public long getGroupId() {
        return this._assetEntry.getGroupId();
    }

    @Override
    public String getKeywords(Locale locale) {
        Object[] assetTagNames = AssetTagLocalServiceUtil.getTagNames(this._assetEntry.getClassName(), this._assetEntry.getClassPK());
        Object[] assetCategoryNames = AssetCategoryLocalServiceUtil.getCategoryNames(this._assetEntry.getClassName(), this._assetEntry.getClassPK());
        Object[] keywords = new String[assetTagNames.length + assetCategoryNames.length];
        ArrayUtil.combine(assetTagNames, assetCategoryNames, keywords);
        return StringUtil.merge(keywords);
    }

    @Override
    public String getTitle(Locale locale) {
        return this._assetEntry.getTitle(locale);
    }

    @Override
    public String getURLTitle(Locale locale) {
        AssetRenderer<?> assetRenderer = this._assetEntry.getAssetRenderer();
        return assetRenderer.getUrlTitle(locale);
    }
}

