/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.portlet;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.asset.util.AssetHelper;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayContributorTracker;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.info.display.url.provider.InfoEditURLProvider;
import com.liferay.info.display.url.provider.InfoEditURLProviderTracker;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAssetDisplayPageFriendlyURLResolver
implements FriendlyURLResolver {
    @Reference
    protected AssetDisplayPageEntryLocalService assetDisplayPageEntryLocalService;
    @Reference
    protected AssetHelper assetHelper;
    @Reference
    protected Http http;
    @Reference
    protected InfoDisplayContributorTracker infoDisplayContributorTracker;
    @Reference
    protected InfoEditURLProviderTracker infoEditURLProviderTracker;
    @Reference
    protected LayoutLocalService layoutLocalService;
    @Reference
    protected LayoutPageTemplateEntryService layoutPageTemplateEntryService;
    @Reference
    protected Portal portal;

    @Override
    public String getActualURL(long companyId, long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)requestContext.get("request");
        InfoDisplayContributor infoDisplayContributor = this._getInfoDisplayContributor(friendlyURL);
        InfoDisplayObjectProvider infoDisplayObjectProvider = this._getInfoDisplayObjectProvider(infoDisplayContributor, groupId, friendlyURL);
        if (infoDisplayObjectProvider != null) {
            httpServletRequest.setAttribute("INFO_DISPLAY_OBJECT_PROVIDER", (Object)infoDisplayObjectProvider);
            InfoEditURLProvider infoEditURLProvider = this.infoEditURLProviderTracker.getInfoEditURLProvider(this.portal.getClassName(infoDisplayObjectProvider.getClassNameId()));
            httpServletRequest.setAttribute("INFO_EDIT_URL_PROVIDER", (Object)infoEditURLProvider);
        }
        httpServletRequest.setAttribute("INFO_DISPLAY_CONTRIBUTOR", (Object)infoDisplayContributor);
        httpServletRequest.setAttribute("VERSION_CLASS_PK", (Object)this._getVersionClassPK(friendlyURL));
        Locale locale = this.portal.getLocale(httpServletRequest);
        this.portal.setPageDescription(infoDisplayObjectProvider.getDescription(locale), httpServletRequest);
        this.portal.setPageKeywords(infoDisplayObjectProvider.getKeywords(locale), httpServletRequest);
        this.portal.setPageTitle(infoDisplayObjectProvider.getTitle(locale), httpServletRequest);
        httpServletRequest.setAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY", infoDisplayObjectProvider.getDisplayObject());
        Layout layout = this._getInfoDisplayObjectProviderLayout(infoDisplayObjectProvider);
        return this.portal.getLayoutActualURL(layout, mainPath);
    }

    @Override
    public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(long companyId, long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        InfoDisplayContributor infoDisplayContributor = this._getInfoDisplayContributor(friendlyURL);
        InfoDisplayObjectProvider infoDisplayObjectProvider = this._getInfoDisplayObjectProvider(infoDisplayContributor, groupId, friendlyURL);
        if (infoDisplayObjectProvider == null) {
            throw new PortalException();
        }
        Layout layout = this._getInfoDisplayObjectProviderLayout(infoDisplayObjectProvider);
        return new LayoutFriendlyURLComposite(layout, friendlyURL);
    }

    private InfoDisplayContributor _getInfoDisplayContributor(String friendlyURL) throws PortalException {
        String infoURLSeparator = this._getInfoURLSeparator(friendlyURL);
        InfoDisplayContributor infoDisplayContributor = this.infoDisplayContributorTracker.getInfoDisplayContributorByURLSeparator(infoURLSeparator);
        if (infoDisplayContributor == null) {
            throw new PortalException("Info display contributor is not available for " + infoURLSeparator);
        }
        return infoDisplayContributor;
    }

    private InfoDisplayObjectProvider _getInfoDisplayObjectProvider(InfoDisplayContributor infoDisplayContributor, long groupId, String friendlyURL) throws PortalException {
        return infoDisplayContributor.getInfoDisplayObjectProvider(groupId, this._getUrlTitle(friendlyURL));
    }

    private Layout _getInfoDisplayObjectProviderLayout(InfoDisplayObjectProvider infoDisplayObjectProvider) {
        AssetDisplayPageEntry assetDisplayPageEntry = this.assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(infoDisplayObjectProvider.getGroupId(), infoDisplayObjectProvider.getClassNameId(), infoDisplayObjectProvider.getClassPK());
        if (assetDisplayPageEntry == null) {
            return null;
        }
        if (assetDisplayPageEntry.getType() != 1) {
            return this.layoutLocalService.fetchLayout(assetDisplayPageEntry.getPlid());
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryService.fetchDefaultLayoutPageTemplateEntry(infoDisplayObjectProvider.getGroupId(), infoDisplayObjectProvider.getClassNameId(), infoDisplayObjectProvider.getClassTypeId());
        if (layoutPageTemplateEntry != null) {
            return this.layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        }
        return null;
    }

    private String _getInfoURLSeparator(String friendlyURL) {
        List<String> paths = StringUtil.split(friendlyURL, '/');
        return '/' + paths.get(0) + '/';
    }

    private String _getUrlTitle(String friendlyURL) {
        List<String> paths = StringUtil.split(friendlyURL, '/');
        return this.http.encodePath(paths.get(1));
    }

    private long _getVersionClassPK(String friendlyURL) {
        List<String> paths = StringUtil.split(friendlyURL, '/');
        if (paths.size() < 3) {
            return 0L;
        }
        return GetterUtil.getLong(paths.get(2));
    }
}

