/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.arquillian.extension.junit.bridge.observer;

import com.liferay.arquillian.extension.junit.bridge.util.FrameworkMethodComparator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class JUnitBridgeObserver {
    public void aroundTest(final @Observes EventContext<org.jboss.arquillian.test.spi.event.suite.Test> eventContext) throws Throwable {
        org.jboss.arquillian.test.spi.event.suite.Test test = (org.jboss.arquillian.test.spi.event.suite.Test)eventContext.getEvent();
        Statement statement = new InvokeMethod(null, test.getTestInstance()){

            @Override
            public void evaluate() {
                eventContext.proceed();
            }
        };
        org.jboss.arquillian.test.spi.TestClass arquillianTestClass = test.getTestClass();
        Class clazz = arquillianTestClass.getJavaClass();
        TestClass junitTestClass = new TestClass(clazz);
        Object target = test.getTestInstance();
        statement = this.withBefores(statement, Before.class, junitTestClass, target);
        statement = this.withAfters(statement, After.class, junitTestClass, target);
        Method method = test.getTestMethod();
        statement = this.withRules(statement, Rule.class, junitTestClass, target, Description.createTestDescription(clazz, method.getName(), method.getAnnotations()));
        ArrayList<FrameworkMethod> frameworkMethods = new ArrayList<FrameworkMethod>(junitTestClass.getAnnotatedMethods(Test.class));
        frameworkMethods.removeAll(junitTestClass.getAnnotatedMethods(Ignore.class));
        Collections.sort(frameworkMethods, FrameworkMethodComparator.INSTANCE);
        FrameworkMethod firstFrameworkMethod = (FrameworkMethod)frameworkMethods.get(0);
        boolean firstMethod = false;
        if (method.equals(firstFrameworkMethod.getMethod())) {
            firstMethod = true;
            statement = this.withBefores(statement, BeforeClass.class, junitTestClass, null);
        }
        FrameworkMethod lastFrameworkMethod = (FrameworkMethod)frameworkMethods.get(frameworkMethods.size() - 1);
        boolean lastMethod = false;
        if (method.equals(lastFrameworkMethod.getMethod())) {
            lastMethod = true;
            statement = this.withAfters(statement, AfterClass.class, junitTestClass, null);
        }
        this.evaluateWithClassRule(statement, junitTestClass, target, Description.createSuiteDescription(clazz), firstMethod, lastMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateWithClassRule(Statement statement, TestClass junitTestClass, Object target, Description description, boolean firstMethod, boolean lastMethod) throws Throwable {
        if (!firstMethod && !lastMethod) {
            statement.evaluate();
            return;
        }
        List<TestRule> testRules = junitTestClass.getAnnotatedMethodValues(target, ClassRule.class, TestRule.class);
        testRules.addAll(junitTestClass.getAnnotatedFieldValues(target, ClassRule.class, TestRule.class));
        if (testRules.isEmpty()) {
            statement.evaluate();
            return;
        }
        this.handleClassRules(testRules, firstMethod, lastMethod, true);
        statement = new RunRules(statement, testRules, description);
        try {
            statement.evaluate();
        }
        finally {
            this.handleClassRules(testRules, firstMethod, lastMethod, false);
        }
    }

    protected void handleClassRules(List<TestRule> testRules, boolean firstMethod, boolean lastMethod, boolean enable) {
        for (TestRule testRule : testRules) {
            Class<?> testRuleClass = testRule.getClass();
            if (firstMethod) {
                try {
                    Method handleBeforeClassMethod = testRuleClass.getMethod("handleBeforeClass", Boolean.TYPE);
                    handleBeforeClassMethod.invoke((Object)testRule, enable);
                }
                catch (ReflectiveOperationException roe) {
                    continue;
                }
            }
            if (!lastMethod) continue;
            try {
                Method handleAfterClassMethod = testRuleClass.getMethod("handleAfterClass", Boolean.TYPE);
                handleAfterClassMethod.invoke((Object)testRule, enable);
            }
            catch (ReflectiveOperationException roe) {}
        }
    }

    protected Statement withAfters(Statement statement, Class<? extends Annotation> afterClass, TestClass junitTestClass, Object target) {
        List<FrameworkMethod> frameworkMethods = junitTestClass.getAnnotatedMethods(afterClass);
        if (!frameworkMethods.isEmpty()) {
            statement = new RunAfters(statement, frameworkMethods, target);
        }
        return statement;
    }

    protected Statement withBefores(Statement statement, Class<? extends Annotation> beforeClass, TestClass junitTestClass, Object target) {
        List<FrameworkMethod> frameworkMethods = junitTestClass.getAnnotatedMethods(beforeClass);
        if (!frameworkMethods.isEmpty()) {
            statement = new RunBefores(statement, frameworkMethods, target);
        }
        return statement;
    }

    protected Statement withRules(Statement statement, Class<? extends Annotation> ruleClass, TestClass junitTestClass, Object target, Description description) {
        List<TestRule> testRules = junitTestClass.getAnnotatedMethodValues(target, ruleClass, TestRule.class);
        testRules.addAll(junitTestClass.getAnnotatedFieldValues(target, ruleClass, TestRule.class));
        if (!testRules.isEmpty()) {
            statement = new RunRules(statement, testRules, description);
        }
        return statement;
    }
}

