/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.taglib.servlet.taglib;

import com.liferay.application.list.PanelApp;
import com.liferay.application.list.taglib.servlet.taglib.BasePanelTag;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class PanelAppTag
extends BasePanelTag {
    private static final Log _log = LogFactoryUtil.getLog(PanelAppTag.class);
    private Boolean _active;
    private Map<String, Object> _data;
    private String _id;
    private String _label;
    private PanelApp _panelApp;
    private String _url;

    @Override
    public int doEndTag() throws JspException {
        if (this._panelApp != null) {
            this.request.setAttribute("PANEL_APP", (Object)this._panelApp);
            try {
                boolean include = this._panelApp.include(this.request, PipingServletResponse.createPipingServletResponse(this.pageContext));
                if (include) {
                    this.doClearTag();
                    return 6;
                }
            }
            catch (IOException ioe) {
                _log.error("Unable to include panel app", ioe);
            }
        }
        return super.doEndTag();
    }

    @Override
    public int doStartTag() throws JspException {
        return 1;
    }

    public Map<String, Object> getData() {
        return this._data;
    }

    public String getId() {
        return this._id;
    }

    public String getLabel() {
        return this._label;
    }

    public PanelApp getPanelApp() {
        return this._panelApp;
    }

    public String getUrl() {
        return this._url;
    }

    public Boolean isActive() {
        return this._active;
    }

    public void setActive(Boolean active) {
        this._active = active;
    }

    public void setData(Map<String, Object> data) {
        this._data = data;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public void setPanelApp(PanelApp panelApp) {
        this._panelApp = panelApp;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._active = null;
        this._data = null;
        this._id = null;
        this._label = null;
        this._panelApp = null;
        this._url = null;
    }

    @Override
    protected String getPage() {
        return "/panel_app/page.jsp";
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        boolean active = false;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        active = this._active != null ? this._active : Objects.equals(themeDisplay.getPpid(), this._panelApp.getPortletId());
        httpServletRequest.setAttribute("liferay-application-list:panel-app:active", (Object)active);
        if (this._data == null) {
            this._data = new HashMap<String, Object>();
        }
        if (Validator.isNull(this._label) && this._panelApp != null) {
            Portlet portlet = PortletLocalServiceUtil.getPortletById(themeDisplay.getCompanyId(), this._panelApp.getPortletId());
            this._label = PortalUtil.getPortletTitle(portlet, this.servletContext, themeDisplay.getLocale());
            if (!this._data.containsKey("qa-id")) {
                this._data.put("qa-id", "app");
            }
        }
        if (!this._data.containsKey("title")) {
            this._data.put("title", this._label);
        }
        httpServletRequest.setAttribute("liferay-application-list:panel-app:data", this._data);
        if (Validator.isNull(this._id)) {
            this._id = "portlet_" + this._panelApp.getPortletId();
        }
        httpServletRequest.setAttribute("liferay-application-list:panel-app:id", (Object)this._id);
        httpServletRequest.setAttribute("liferay-application-list:panel-app:label", (Object)this._label);
        int notificationsCount = 0;
        if (this._panelApp != null) {
            notificationsCount = this._panelApp.getNotificationsCount(themeDisplay.getUser());
        }
        httpServletRequest.setAttribute("liferay-application-list:panel-app:notificationsCount", (Object)notificationsCount);
        httpServletRequest.setAttribute("liferay-application-list:panel-app:panelApp", (Object)this._panelApp);
        if (Validator.isNull(this._url) && this._panelApp != null) {
            PortletURL portletURL = null;
            try {
                portletURL = this._panelApp.getPortletURL(httpServletRequest);
            }
            catch (PortalException pe) {
                _log.error("Unable to get portlet URL", pe);
            }
            this._url = portletURL.toString();
        }
        httpServletRequest.setAttribute("liferay-application-list:panel-app:url", (Object)this._url);
    }
}

