/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.taglib.display.context.logic;

import com.liferay.portal.kernel.layoutconfiguration.util.RuntimePageUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.DynamicServletRequestUtil;
import com.liferay.portlet.LiferayPortletUtil;
import java.io.Writer;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PanelAppContentHelper {
    private Long _companyId;
    private final HttpServletRequest _httpServletRequest;
    private final HttpServletResponse _httpServletResponse;
    private Portlet _portlet;
    private String _portletId;

    public PanelAppContentHelper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this._httpServletRequest = httpServletRequest;
        this._httpServletResponse = httpServletResponse;
    }

    public boolean isValidPortletSelected() {
        return this.getPortlet() != null;
    }

    public void writeContent(Writer writer) throws Exception {
        HttpServletRequest httpServletRequest;
        StringBundler sb;
        ThemeDisplay themeDisplay = this._getThemeDisplay();
        String layoutTemplateId = "max";
        if (themeDisplay.isStatePopUp()) {
            layoutTemplateId = "pop_up";
        }
        Theme theme = themeDisplay.getTheme();
        String velocityTemplateId = theme.getThemeId() + "_STANDARD_" + layoutTemplateId;
        String content = LayoutTemplateLocalServiceUtil.getContent(layoutTemplateId, true, theme.getThemeId());
        if (Validator.isNotNull(velocityTemplateId) && Validator.isNotNull(content) && (sb = RuntimePageUtil.getProcessedTemplate(httpServletRequest = this.getOriginalHttpServletRequest(this._httpServletRequest), this._httpServletResponse, this.getPortletId(), new StringTemplateResource(velocityTemplateId, content))) != null) {
            sb.writeTo(writer);
        }
    }

    protected long getCompanyId() {
        if (this._companyId == null) {
            ThemeDisplay themeDisplay = this._getThemeDisplay();
            this._companyId = themeDisplay.getCompanyId();
        }
        return this._companyId;
    }

    protected HttpServletRequest getOriginalHttpServletRequest(HttpServletRequest httpServletRequest) {
        LiferayPortletRequest liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest((PortletRequest)this._httpServletRequest.getAttribute("javax.portlet.request"));
        if (liferayPortletRequest != null) {
            return liferayPortletRequest.getOriginalHttpServletRequest();
        }
        HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest(httpServletRequest);
        Portlet portlet = this.getPortlet();
        return DynamicServletRequestUtil.createDynamicServletRequest(originalHttpServletRequest, portlet, httpServletRequest.getParameterMap(), false);
    }

    protected Portlet getPortlet() {
        if (this._portlet == null && Validator.isNotNull(this.getPortletId())) {
            this._portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(), this.getPortletId());
        }
        return this._portlet;
    }

    protected String getPortletId() {
        if (this._portletId == null) {
            this._portletId = (String)this._httpServletRequest.getAttribute("liferay-application-list:application-content:portletId");
        }
        return this._portletId;
    }

    private ThemeDisplay _getThemeDisplay() {
        return (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }
}

