/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.deploy.hot;

import com.liferay.application.list.PanelApp;
import com.liferay.application.list.adapter.PortletPanelAppAdapter;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.util.PortletCategoryUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={HotDeployListener.class})
public class LegacyPortletPanelAppHotDeployListener
extends BaseHotDeployListener {
    private BundleContext _bundleContext;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;
    private final Map<String, ServiceRegistration<PanelApp>> _serviceRegistrations = new ConcurrentHashMap<String, ServiceRegistration<PanelApp>>();

    public int getServiceRegistrationsSize() {
        return this._serviceRegistrations.size();
    }

    @Override
    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            for (Dictionary<String, Object> properties : this.getPropertiesList(hotDeployEvent)) {
                String portletId = (String)properties.get("panel.app.portlet.id");
                ServiceRegistration serviceRegistration = this._bundleContext.registerService(PanelApp.class, (Object)new PortletPanelAppAdapter(portletId), properties);
                this._serviceRegistrations.put(portletId, (ServiceRegistration<PanelApp>)serviceRegistration);
            }
        }
        catch (DocumentException | IOException e) {
            throw new HotDeployException(e);
        }
    }

    @Override
    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            for (Dictionary<String, Object> properties : this.getPropertiesList(hotDeployEvent)) {
                String portletId = (String)properties.get("panel.app.portlet.id");
                ServiceRegistration<PanelApp> serviceRegistration = this._serviceRegistrations.remove(portletId);
                if (serviceRegistration == null) continue;
                serviceRegistration.unregister();
            }
        }
        catch (DocumentException | IOException e) {
            throw new HotDeployException(e);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    protected String getPortletId(String servletContextName, String portletName) {
        if (servletContextName == null) {
            return portletName;
        }
        return this._portal.getJsSafePortletId(portletName + "_WAR_" + servletContextName);
    }

    protected List<Dictionary<String, Object>> getPropertiesList(HotDeployEvent hotDeployEvent) throws DocumentException, IOException {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String xml = this._http.URLtoString(servletContext.getResource("/WEB-INF/liferay-portlet.xml"));
        if (xml == null) {
            return Collections.emptyList();
        }
        ArrayList<Dictionary<String, Object>> propertiesList = new ArrayList<Dictionary<String, Object>>();
        Document document = UnsecureSAXReaderUtil.read(xml, true);
        Element rootElement = document.getRootElement();
        Iterator<Element> iterator = rootElement.elementIterator("portlet");
        while (iterator.hasNext()) {
            Element portletElement = iterator.next();
            String controlPanelEntryCategory = portletElement.elementText("control-panel-entry-category");
            if (Validator.isNull(controlPanelEntryCategory)) continue;
            controlPanelEntryCategory = PortletCategoryUtil.getPortletCategoryKey(controlPanelEntryCategory);
            HashMapDictionary<String, Object> properties = new HashMapDictionary<String, Object>();
            String portletName = portletElement.elementText("portlet-name");
            String portletId = this.getPortletId(hotDeployEvent.getServletContextName(), portletName);
            ((Dictionary)properties).put("panel.app.portlet.id", portletId);
            ((Dictionary)properties).put("panel.category.key", controlPanelEntryCategory);
            String controlPanelEntryWeight = portletElement.elementText("control-panel-entry-weight");
            if (Validator.isNotNull(controlPanelEntryWeight)) {
                int panelAppOrder = (int)Math.ceil(GetterUtil.getDouble(controlPanelEntryWeight) * 100.0);
                ((Dictionary)properties).put("panel.app.order", panelAppOrder);
            }
            propertiesList.add(properties);
        }
        return propertiesList;
    }
}

