/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list;

import com.liferay.application.list.GroupProvider;
import com.liferay.application.list.PanelApp;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.ControlPanelEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BasePanelApp
implements PanelApp {
    protected GroupProvider groupProvider;
    private Portlet _portlet;
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    @Override
    public String getKey() {
        Class<?> clazz = this.getClass();
        return clazz.getName();
    }

    @Override
    public String getLabel(Locale locale) {
        return LanguageUtil.get(locale, "javax.portlet.title." + this.getPortletId());
    }

    @Override
    public int getNotificationsCount(User user) {
        if (this._userNotificationEventLocalService == null) {
            return 0;
        }
        return this._userNotificationEventLocalService.getUserNotificationEventsCount(user.getUserId(), this._portlet.getPortletId(), 10002, false);
    }

    @Override
    public Portlet getPortlet() {
        return this._portlet;
    }

    @Override
    public PortletURL getPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL(httpServletRequest, this.getGroup(httpServletRequest), this.getPortletId(), 0L, 0L, "RENDER_PHASE");
        Group group = this.groupProvider.getGroup(httpServletRequest);
        if (group == null) {
            return portletURL;
        }
        portletURL.setParameter("p_v_l_s_g_id", String.valueOf(group.getGroupId()));
        return portletURL;
    }

    @Override
    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return false;
    }

    @Override
    public boolean isShow(PermissionChecker permissionChecker, Group group) throws PortalException {
        try {
            ControlPanelEntry controlPanelEntry = this.getControlPanelEntry();
            if (controlPanelEntry == null) {
                return true;
            }
            return controlPanelEntry.hasAccessPermission(permissionChecker, group, this.getPortlet());
        }
        catch (PortalException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    @Override
    public void setGroupProvider(GroupProvider groupProvider) {
        this.groupProvider = groupProvider;
    }

    @Override
    public void setPortlet(Portlet portlet) {
        this._portlet = portlet;
    }

    protected ControlPanelEntry getControlPanelEntry() {
        Portlet portlet = this.getPortlet();
        if (portlet == null) {
            return null;
        }
        return portlet.getControlPanelEntryInstance();
    }

    protected Group getGroup(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = themeDisplay.getScopeGroup();
        if (!group.isControlPanel()) {
            return null;
        }
        Portlet portlet = this.getPortlet();
        String controlPanelEntryCategory = portlet.getControlPanelEntryCategory();
        if (Validator.isNull(controlPanelEntryCategory) || !controlPanelEntryCategory.startsWith("site_administration.")) {
            return null;
        }
        if (this.groupProvider == null) {
            return null;
        }
        return this.groupProvider.getGroup(httpServletRequest);
    }

    protected void setUserNotificationEventLocalService(UserNotificationEventLocalService userNotificationEventLocalService) {
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }
}

