/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.tools.model;

import com.liferay.alloy.tools.model.Attribute;
import com.liferay.alloy.tools.model.BaseModel;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class Component
extends BaseModel {
    private static final String _CLASS_NAME_SUFFIX = "Tag";
    private boolean _alloyComponent;
    private List<Attribute> _attributes;
    private String[] _authors;
    private boolean _bodyContent;
    private String _className;
    private boolean _componentTaglibOSGIModule;
    private String _description;
    private boolean _dynamicAttributes;
    private List<Attribute> _events;
    private String _module;
    private String _package;
    private String _parentClass;
    private boolean _writeEndJSP;
    private boolean _writeJSP;
    private boolean _writeStartJSP;

    public String getAttributeNamespace() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._package);
        sb.append(":");
        sb.append(this.getUncamelizedName());
        sb.append(":");
        return StringUtil.toLowerCase(sb.toString());
    }

    public List<Attribute> getAttributes() {
        return this._attributes;
    }

    public List<Attribute> getAttributesAndEvents() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.addAll(this._attributes);
        attributes.addAll(this._events);
        return attributes;
    }

    public String[] getAuthors() {
        return this._authors;
    }

    public String getCamelizedName() {
        return TextFormatter.format(this.getName(), 12);
    }

    public String getClassName() {
        String className = this._className;
        if (Validator.isNull(className)) {
            className = this.getSafeName().concat(_CLASS_NAME_SUFFIX);
        }
        return className;
    }

    public String getDescription() {
        return this._description;
    }

    public List<Attribute> getEvents() {
        return this._events;
    }

    public String getModule() {
        return this._module;
    }

    public String getPackage() {
        return this._package;
    }

    public String getParentClass() {
        return this._parentClass;
    }

    public String getSafeName() {
        return StringUtil.replace(this.getName(), ".", "");
    }

    public String getUncamelizedName() {
        String name = this.getName().replaceAll("\\.", "-");
        return TextFormatter.format(name, 16);
    }

    public String getUncamelizedName(String delimiter) {
        return this.getUncamelizedName().replaceAll("\\-", delimiter);
    }

    public boolean getWriteEndJSP() {
        return this._writeEndJSP;
    }

    public boolean getWriteJSP() {
        return this._writeJSP;
    }

    public boolean getWriteStartJSP() {
        return this._writeStartJSP;
    }

    public boolean isAlloyComponent() {
        return this._alloyComponent;
    }

    public boolean isBodyContent() {
        return this._bodyContent;
    }

    public boolean isComponentTaglibOSGIModule() {
        return this._componentTaglibOSGIModule;
    }

    public boolean isDynamicAttributes() {
        return this._dynamicAttributes;
    }

    public void setAlloyComponent(boolean alloyComponent) {
        this._alloyComponent = alloyComponent;
    }

    public void setAttributes(List<Attribute> attributes) {
        this._attributes = attributes;
        for (Attribute attribute : attributes) {
            attribute.setComponent(this);
        }
    }

    public void setAuthors(String[] authors) {
        this._authors = authors;
    }

    public void setBodyContent(boolean bodyContent) {
        this._bodyContent = bodyContent;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setComponentTaglibOSGIModule(boolean componentTaglibOSGIModule) {
        this._componentTaglibOSGIModule = componentTaglibOSGIModule;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setDynamicAttributes(boolean dynamicAttributes) {
        this._dynamicAttributes = dynamicAttributes;
    }

    public void setEvents(List<Attribute> events) {
        this._events = events;
        for (Attribute event : events) {
            event.setComponent(this);
        }
    }

    public void setModule(String type) {
        this._module = type;
    }

    public void setPackage(String componentPackage) {
        this._package = componentPackage;
    }

    public void setParentClass(String parentClass) {
        this._parentClass = parentClass;
    }

    public void setWriteEndJSP(boolean writeEndJSP) {
        this._writeEndJSP = writeEndJSP;
    }

    public void setWriteJSP(boolean writeJSP) {
        this._writeJSP = writeJSP;
    }

    public void setWriteStartJSP(boolean writeStartJSP) {
        this._writeStartJSP = writeStartJSP;
    }
}

