/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.tools.model;

import com.liferay.alloy.tools.model.BaseModel;
import com.liferay.alloy.tools.model.Component;
import com.liferay.alloy.util.ReservedAttributeUtil;
import com.liferay.alloy.util.TypeUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Attribute
extends BaseModel {
    private Component _component;
    private String _defaultValue;
    private String _description;
    private boolean _gettable = true;
    private String _inputType;
    private String _outputType;
    private boolean _required;
    private boolean _settable = true;
    private boolean _writeInJSP = true;

    public String getCapitalizedName() {
        return StringUtils.capitalize((String)this.getSafeName());
    }

    public Component getComponent() {
        return this._component;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public String getDescription() {
        return this._description;
    }

    public String getInputType() {
        return TypeUtil.getInputJavaType(this._inputType, true);
    }

    public String getInputTypeSimpleClassName() {
        return this.getTypeSimpleClassName(this.getRawInputType());
    }

    public String getOutputType() {
        return TypeUtil.getOutputJavaType(this._outputType, true);
    }

    public String getOutputTypeSimpleClassName() {
        return this.getTypeSimpleClassName(this.getRawOutputType());
    }

    public String getRawInputType() {
        return TypeUtil.getInputJavaType(this._inputType, false);
    }

    public String getRawOutputType() {
        return TypeUtil.getOutputJavaType(this._outputType, false);
    }

    public String getSafeName() {
        String safeName = this.getName();
        if (this.getComponent() != null && this.getComponent().isAlloyComponent()) {
            safeName = ReservedAttributeUtil.getSafeName(this);
        }
        if (safeName.indexOf(":") > -1) {
            safeName = StringUtils.substringAfterLast((String)safeName, (String)":");
        }
        return safeName;
    }

    public String getTypeSimpleClassName(String type) {
        if (TypeUtil.isPrimitiveJavaType(type)) {
            return type;
        }
        if (TypeUtil.isJavaType(type)) {
            try {
                type = TypeUtil.removeGenericsType(type);
                type = TypeUtil.removeArrayNotation(type);
                return Class.forName(type).getSimpleName();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return "";
    }

    public boolean getWriteInJSP() {
        return this._writeInJSP;
    }

    public boolean isDefaultInputType() {
        return this._inputType.equals("java.lang.String");
    }

    public boolean isEvent() {
        List<Attribute> events = this._component.getEvents();
        return events.contains(this);
    }

    public boolean isGenericsType(String type) {
        return Validator.isNotNull(type) && Validator.isNotNull(TypeUtil.getGenericsType(type));
    }

    public boolean isGettable() {
        return this._gettable;
    }

    public boolean isRequired() {
        return this._required;
    }

    public boolean isSettable() {
        return this._settable;
    }

    public void setComponent(Component component) {
        this._component = component;
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setGettable(boolean gettable) {
        this._gettable = gettable;
    }

    public void setInputType(String inputType) {
        this._inputType = inputType;
    }

    public void setOutputType(String outputType) {
        this._outputType = outputType;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public void setSettable(boolean settable) {
        this._settable = settable;
    }

    public void setWriteInJSP(boolean writeInJSP) {
        this._writeInJSP = writeInJSP;
    }
}

