/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.taglib.alloy_util;

import com.liferay.alloy.taglib.alloy_util.base.BaseComponentTag;
import com.liferay.alloy.util.ReservedAttributeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class ComponentTag
extends BaseComponentTag {
    private static final String _AFTER = "after";
    private static final String _DYNAMIC_ATTRIBUTES = "dynamicAttributes";
    private static final Pattern _EVENT_AFTER_REGEX = Pattern.compile("after[A-Z]");
    private static final Pattern _EVENT_ON_REGEX = Pattern.compile("on[A-Z]");
    private static final String _ON = "on";

    @Override
    protected void setAttributes(HttpServletRequest request) {
        Map options = this.getOptions();
        HashMap<String, Object> optionsJSON = new HashMap<String, Object>();
        this._proccessAttributes(options, optionsJSON);
        super.setAttributes(request);
        this.setNamespacedAttribute(request, "options", options);
        this.setNamespacedAttribute(request, "optionsJSON", optionsJSON);
    }

    private boolean _isEventAttribute(String key) {
        Matcher afterMatcher = _EVENT_AFTER_REGEX.matcher(key);
        Matcher onMatcher = _EVENT_ON_REGEX.matcher(key);
        return afterMatcher.find() || onMatcher.find();
    }

    private boolean _isValidAttribute(String key) {
        List<Object> excludeAttributes = Collections.emptyList();
        if (this.getExcludeAttributes() != null) {
            excludeAttributes = Arrays.asList(this.getExcludeAttributes().split(","));
        }
        return !excludeAttributes.contains(key) && !key.equals(_DYNAMIC_ATTRIBUTES);
    }

    private void _proccessAttributes(Map<String, Object> options, Map<String, Object> newOptions) {
        HashMap<String, String> afterEventOptionsMap = new HashMap<String, String>();
        HashMap<String, String> onEventOptionsMap = new HashMap<String, String>();
        for (String key : options.keySet()) {
            if (!this._isValidAttribute(key)) continue;
            Object value = options.get(key);
            String originalKey = ReservedAttributeUtil.getOriginalName(this.getName(), key);
            if (value instanceof Map) {
                HashMap<String, Object> childOptionsMap = new HashMap<String, Object>();
                this._proccessAttributes((Map)value, childOptionsMap);
                newOptions.put(originalKey, childOptionsMap);
                continue;
            }
            if (this._isEventAttribute(key)) {
                this._processEventAttribute(key, String.valueOf(value), afterEventOptionsMap, onEventOptionsMap);
                continue;
            }
            newOptions.put(originalKey, value);
        }
        if (afterEventOptionsMap.size() > 0) {
            newOptions.put(_AFTER, afterEventOptionsMap);
        }
        if (onEventOptionsMap.size() > 0) {
            newOptions.put(_ON, onEventOptionsMap);
        }
    }

    private void _processEventAttribute(String key, String value, Map<String, String> afterEventOptionsMap, Map<String, String> onEventsOptionsMap) {
        if (key.startsWith(_AFTER)) {
            String event = StringUtils.uncapitalize((String)key.replaceFirst(_AFTER, ""));
            afterEventOptionsMap.put(event, value);
        } else {
            String event = StringUtils.uncapitalize((String)key.replaceFirst(_ON, ""));
            onEventsOptionsMap.put(event, value);
        }
    }
}

