/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.taglib.servlet.taglib;

import com.liferay.adaptive.media.image.html.AMImageHTMLTagFactory;
import com.liferay.document.library.util.DLURLHelperUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.taglib.util.AttributesTagSupport;
import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTag;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class AMImageImgTag
extends AttributesTagSupport
implements BodyTag {
    private FileVersion _fileVersion;

    @Override
    public int doEndTag() throws JspException {
        try {
            JspWriter jspWriter = this.pageContext.getOut();
            jspWriter.write(this._getHTMLTag());
            return 6;
        }
        catch (PortalException | IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public void setFileVersion(FileVersion fileVersion) {
        this._fileVersion = fileVersion;
    }

    private String _getFallbackTag() throws PortalException {
        Map<String, Object> dynamicAttributes = this.getDynamicAttributes();
        StringBundler sb = new StringBundler(4 + 4 * dynamicAttributes.size());
        sb.append("<img ");
        for (Map.Entry<String, Object> entry : dynamicAttributes.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=\"");
            Object value = entry.getValue();
            sb.append(HtmlUtil.escapeAttribute(value.toString()));
            sb.append("\" ");
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String downloadURL = DLURLHelperUtil.getPreviewURL(this._fileVersion.getFileEntry(), this._fileVersion, themeDisplay, "");
        sb.append("src=\"");
        sb.append(downloadURL);
        sb.append("\" />");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getHTMLTag() throws PortalException {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(AMImageHTMLTagFactory.class);
        if (serviceReference == null) {
            return this._getFallbackTag();
        }
        try {
            AMImageHTMLTagFactory amImageHTMLTagFactory = (AMImageHTMLTagFactory)bundleContext.getService(serviceReference);
            if (amImageHTMLTagFactory == null) {
                String string = this._getFallbackTag();
                return string;
            }
            String string = amImageHTMLTagFactory.create(this._getFallbackTag(), this._fileVersion.getFileEntry());
            return string;
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }
}

