/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

import com.dumbster.smtp.IOSource;
import com.dumbster.smtp.MailMessage;
import com.dumbster.smtp.MailMessageImpl;
import com.dumbster.smtp.MailStore;
import com.dumbster.smtp.Request;
import com.dumbster.smtp.Response;
import com.dumbster.smtp.SmtpState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class ClientSession
implements Runnable {
    private IOSource socket;
    private volatile MailStore mailStore;
    private MailMessage msg;
    private Response smtpResponse;
    private PrintWriter out;
    private BufferedReader input;
    private SmtpState smtpState;
    private String line;
    private String lastHeaderName = null;

    public ClientSession(IOSource socket, MailStore mailStore) {
        this.socket = socket;
        this.mailStore = mailStore;
        this.msg = new MailMessageImpl();
        Request request = Request.initialRequest();
        this.smtpResponse = request.execute(this.mailStore, this.msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.prepareSessionLoop();
            this.sessionLoop();
        }
        catch (Exception ignored) {
        }
        finally {
            try {
                this.socket.close();
            }
            catch (Exception ignored) {}
        }
    }

    private void prepareSessionLoop() throws IOException {
        this.prepareOutput();
        this.prepareInput();
        this.sendResponse();
        this.updateSmtpState();
    }

    private void prepareOutput() throws IOException {
        this.out = this.socket.getOutputStream();
        this.out.flush();
    }

    private void prepareInput() throws IOException {
        this.input = this.socket.getInputStream();
    }

    private void sendResponse() {
        if (this.smtpResponse.getCode() > 0) {
            int code = this.smtpResponse.getCode();
            String message = this.smtpResponse.getMessage();
            this.out.print(code + " " + message + "\r\n");
            this.out.flush();
        }
    }

    private void updateSmtpState() {
        this.smtpState = this.smtpResponse.getNextState();
    }

    private void sessionLoop() throws IOException {
        while (this.smtpState != SmtpState.CONNECT && this.readNextLineReady()) {
            Request request = Request.createRequest(this.smtpState, this.line);
            this.smtpResponse = request.execute(this.mailStore, this.msg);
            this.storeInputInMessage(request);
            this.sendResponse();
            this.updateSmtpState();
            this.saveAndRefreshMessageIfComplete();
        }
    }

    private boolean readNextLineReady() throws IOException {
        this.readLine();
        return this.line != null;
    }

    private void readLine() throws IOException {
        this.line = this.input.readLine();
    }

    private void saveAndRefreshMessageIfComplete() {
        if (this.smtpState == SmtpState.QUIT) {
            this.mailStore.addMessage(this.msg);
            this.msg = new MailMessageImpl();
        }
    }

    private void storeInputInMessage(Request request) {
        String params = request.getParams();
        if (null == params) {
            return;
        }
        if (SmtpState.DATA_HDR.equals((Object)this.smtpResponse.getNextState())) {
            this.addDataHeader(params);
            return;
        }
        if (SmtpState.DATA_BODY == this.smtpResponse.getNextState()) {
            this.msg.appendBody(params);
            return;
        }
    }

    private void addDataHeader(String params) {
        int headerNameEnd = params.indexOf(58);
        if (headerNameEnd > 0 && !this.whiteSpacedLineStart(params)) {
            this.lastHeaderName = params.substring(0, headerNameEnd).trim();
            String value = params.substring(headerNameEnd + 1).trim();
            this.msg.addHeader(this.lastHeaderName, value);
        } else if (this.whiteSpacedLineStart(params) && this.lastHeaderName != null) {
            this.msg.appendHeader(this.lastHeaderName, params);
        }
    }

    private boolean whiteSpacedLineStart(String s) {
        if (s == null || "".equals(s)) {
            return false;
        }
        char c = s.charAt(0);
        return c == ' ' || c == '\u000b' || c == '\n' || c == '\r' || c == '\t' || c == '\f';
    }
}

