/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
'use strict';

Liferay.Loader.define("commerce-frontend-taglib@9.0.0/product_card/ProductCard.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './ProductCard.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ProductCard = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  var _ProductCard = _interopRequireDefault(require("./ProductCard.soy"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function liferayNavigation(url) {
    if (Liferay.SPA) {
      Liferay.SPA.app.navigate(url);
    } else {
      window.location.href = url;
    }
  }

  var ProductCard = /*#__PURE__*/function (_Component) {
    _inherits(ProductCard, _Component);

    function ProductCard() {
      _classCallCheck(this, ProductCard);

      return _possibleConstructorReturn(this, _getPrototypeOf(ProductCard).apply(this, arguments));
    }

    _createClass(ProductCard, [{
      key: "_handleCardKeypress",
      value: function _handleCardKeypress(e) {
        if (e.key === 'Enter' && e.target === this.element) {
          liferayNavigation(this.element.dataset.href);
        }

        if (['A', 'a'].includes(e.key)) {
          e.preventDefault();
          var next = this.element.closest('.minium-product-tiles__item');

          if (e.target !== this.element) {
            next = e.shiftKey ? next.previousElementSibling : next.nextElementSibling;
          }

          if (next) {
            setTimeout(function () {
              return next.querySelector('.commerce-button').focus();
            }, 100);
          }
        }
      }
    }, {
      key: "_handleCheckboxCompareUpdate",
      value: function _handleCheckboxCompareUpdate(newCompareState) {
        this.compareState = _objectSpread({
          checkboxVisible: this.compareState.checkboxVisible
        }, newCompareState);
        return this.compareState;
      }
    }, {
      key: "_handleRemoveProduct",
      value: function _handleRemoveProduct() {
        var formData = new FormData();
        formData.append(this.compareContentNamespace + 'cpDefinitionId', this.productId);
        formData.append(this.compareContentNamespace + this.productId + 'Compare', false);
        formData.append('p_auth', Liferay.authToken);
        return fetch(this.editCompareProductActionURL, {
          body: formData,
          credentials: 'include',
          headers: new Headers({
            'x-csrf-token': Liferay.authToken
          }),
          method: 'post'
        }).then(function () {
          liferayNavigation(window.location.href);
          return Liferay.SPA;
        });
      }
    }, {
      key: "_handleWishListButtonClick",
      value: function _handleWishListButtonClick() {
        this._toggleFavorite();
      }
    }, {
      key: "_toggleFavorite",
      value: function _toggleFavorite() {
        var _this = this;

        if (!this.wishlistAPI) {
          throw new Error('No wishlist API defined.');
        }

        var formData = new FormData();
        formData.append('commerceAccountId', this.accountId ? this.accountId : 0);
        formData.append('groupId', themeDisplay.getScopeGroupId());
        formData.append('productId', this.productId);
        formData.append('skuId', this.skuId ? this.skuId : 0);
        formData.append('options', '[]');
        fetch(this.wishlistAPI + "?p_auth=".concat(window.Liferay.authToken), {
          body: formData,
          credentials: 'include',
          headers: new Headers({
            'x-csrf-token': Liferay.authToken
          }),
          method: 'POST'
        }).then(function (response) {
          return response.json();
        }).then(function (jsonresponse) {
          _this.addedToWishlist = jsonresponse.success;
          return _this.addedToWishlist;
        });
      }
    }]);

    return ProductCard;
  }(_metalComponent["default"]);

  exports.ProductCard = ProductCard;

  _metalSoy["default"].register(ProductCard, _ProductCard["default"]);

  ProductCard.STATE = {
    accountId: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]).value(null),
    addToCartButtonVisible: _metalSoy.Config.bool().value(true),
    addToWishlistButtonVisible: _metalSoy.Config.bool().value(true),
    addedToWishlist: _metalSoy.Config.bool().value(false),
    availability: _metalSoy.Config.string().oneOf(['inStock', 'available', 'notAvailable']),
    cartAPI: _metalSoy.Config.string(),
    categories: _metalSoy.Config.array(_metalSoy.Config.shapeOf({
      link: _metalSoy.Config.string().required(),
      name: _metalSoy.Config.string().required()
    })),
    compareContentNamespace: _metalSoy.Config.string(),
    compareState: _metalSoy.Config.shapeOf({
      checkboxVisible: _metalSoy.Config.bool(),
      compareAvailable: _metalSoy.Config.bool(),
      inCompare: _metalSoy.Config.bool()
    }).value({
      checkboxVisible: true,
      compareAvailable: true,
      inCompare: false
    }),
    deleteButtonVisible: _metalSoy.Config.bool(),
    description: _metalSoy.Config.string(),
    detailsLink: _metalSoy.Config.string(),
    editCompareProductActionURL: _metalSoy.Config.string(),
    minQuantity: _metalSoy.Config.number(),
    name: _metalSoy.Config.string().required(),
    orderId: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]),
    pictureUrl: _metalSoy.Config.string(),
    price: _metalSoy.Config.shapeOf({
      formattedPrice: _metalSoy.Config.string().required(),
      formattedPromoPrice: _metalSoy.Config.string()
    }),
    productId: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]).required(),
    settings: _metalSoy.Config.shapeOf({
      allowedOptions: _metalSoy.Config.array(_metalSoy.Config.number()),
      maxQuantity: _metalSoy.Config.number(),
      minQuantity: _metalSoy.Config.number(),
      multipleQuantity: _metalSoy.Config.number()
    }).value({}),
    sku: _metalSoy.Config.string(),
    skuId: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]),
    spritemap: _metalSoy.Config.string(),
    wishlistAPI: _metalSoy.Config.string()
  };
  var _default = ProductCard;
  exports["default"] = _default;
  //# sourceMappingURL=ProductCard.es.js.map
});
//# sourceMappingURL=ProductCard.es.js.map