/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
'use strict';

Liferay.Loader.define("commerce-frontend-taglib@9.0.0/add_organizations_modal/AddOrganizationsModal.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-debounce', 'frontend-js-metal-web$metal-soy', './AddOrganizationsModal.soy', 'frontend-taglib-clay$clay-modal', './OrganizationInputItem.es', './OrganizationListItem.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.AddOrganizationModal = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDebounce = require("frontend-js-metal-web$metal-debounce");

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  var _AddOrganizationsModal = _interopRequireDefault(require("./AddOrganizationsModal.soy"));

  require("frontend-taglib-clay$clay-modal");

  require("./OrganizationInputItem.es");

  require("./OrganizationListItem.es");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var AddOrganizationModal = /*#__PURE__*/function (_Component) {
    _inherits(AddOrganizationModal, _Component);

    function AddOrganizationModal() {
      _classCallCheck(this, AddOrganizationModal);

      return _possibleConstructorReturn(this, _getPrototypeOf(AddOrganizationModal).apply(this, arguments));
    }

    _createClass(AddOrganizationModal, [{
      key: "created",
      value: function created() {
        this._debouncedFetchOrganizations = (0, _metalDebounce.debounce)(this._fetchOrganizations.bind(this), 300);
      }
    }, {
      key: "attached",
      value: function attached() {
        return this._fetchOrganizations();
      }
    }, {
      key: "syncAddedOrganizations",
      value: function syncAddedOrganizations() {
        var contentWrapper = this.element.querySelector('.autocomplete-input__content');
        this.element.querySelector('.autocomplete-input__box').focus();

        if (contentWrapper.scrollTo) {
          contentWrapper.scrollTo(0, contentWrapper.offsetHeight);
        }
      }
    }, {
      key: "_handleCloseModal",
      value: function _handleCloseModal(e) {
        e.preventDefault();
        this._modalVisible = false;
      }
    }, {
      key: "syncQuery",
      value: function syncQuery() {
        this._loading = true;
        return this._debouncedFetchOrganizations();
      }
    }, {
      key: "_handleFormSubmit",
      value: function _handleFormSubmit(e) {
        e.preventDefault();

        if (this.organizations.length) {
          this._toggleItem(this.organizations[0]);

          this.query = '';
        }

        return e;
      }
    }, {
      key: "_handleInputBox",
      value: function _handleInputBox(e) {
        if (e.keyCode === 8 && !this.query.length) {
          this.selectedOrganizations = this.selectedOrganizations.slice(0, -1);
          return false;
        }

        this.query = e.target.value;
        return this.query;
      }
    }, {
      key: "_toggleItem",
      value: function _toggleItem(organizationToBeToggled) {
        if (!organizationToBeToggled.id) {
          this.query = '';
        }

        var organizationAlreadyAdded = this.selectedOrganizations.reduce(function (alreadyAdded, organization) {
          return alreadyAdded || organization.id === organizationToBeToggled.id;
        }, false);
        this.selectedOrganizations = organizationAlreadyAdded ? this.selectedOrganizations.filter(function (organization) {
          return organization.id !== organizationToBeToggled.id;
        }) : [].concat(_toConsumableArray(this.selectedOrganizations), [organizationToBeToggled]);
        return this.selectedOrganizations;
      }
    }, {
      key: "_fetchOrganizations",
      value: function _fetchOrganizations() {
        var _this = this;

        return fetch(this.organizationsAPI + '?groupId=' + themeDisplay.getScopeGroupId() + '&p_auth=' + Liferay.authToken + '&q=' + this.query, {
          credentials: 'include',
          headers: new Headers({
            'x-csrf-token': Liferay.authToken
          }),
          method: 'GET'
        }).then(function (response) {
          return response.json();
        }).then(function (response) {
          _this._loading = false;
          _this.organizations = _this.addColorToOrganizations(response.organizations);
          return _this.organizations;
        });
      }
    }, {
      key: "addColorToOrganizations",
      value: function addColorToOrganizations(organizations) {
        return organizations.map(function (organization) {
          return _objectSpread({
            colorId: Math.floor(Math.random() * 6) + 1
          }, organization);
        });
      }
    }, {
      key: "_addOrganizations",
      value: function _addOrganizations() {
        if (!this.selectedOrganizations.length) {
          return false;
        }

        return this.emit('addOrganization', this.selectedOrganizations);
      }
    }, {
      key: "toggle",
      value: function toggle() {
        this._modalVisible = !this._modalVisible;
        return this._modalVisible;
      }
    }, {
      key: "open",
      value: function open() {
        this._modalVisible = true;
        return this._modalVisible;
      }
    }, {
      key: "close",
      value: function close() {
        this._modalVisible = false;
        return this._modalVisible;
      }
    }]);

    return AddOrganizationModal;
  }(_metalComponent["default"]);

  exports.AddOrganizationModal = AddOrganizationModal;

  _metalSoy["default"].register(AddOrganizationModal, _AddOrganizationsModal["default"]);

  var ORGANIZATION_SCHEMA = _metalSoy.Config.shapeOf({
    colorId: _metalSoy.Config.number(),
    id: _metalSoy.Config.oneOfType([_metalSoy.Config.number(), _metalSoy.Config.string()]).required(),
    name: _metalSoy.Config.string().required()
  });

  AddOrganizationModal.STATE = {
    _loading: _metalSoy.Config.bool().internal().value(false),
    _modalVisible: _metalSoy.Config.bool().internal().value(false),
    organizations: _metalSoy.Config.array(ORGANIZATION_SCHEMA).value([]),
    organizationsAPI: _metalSoy.Config.string().value(''),
    query: _metalSoy.Config.string().value(''),
    selectedOrganizations: _metalSoy.Config.array(ORGANIZATION_SCHEMA).value([]),
    spritemap: _metalSoy.Config.string()
  };
  var _default = AddOrganizationModal;
  exports["default"] = _default;
  //# sourceMappingURL=AddOrganizationsModal.es.js.map
});
//# sourceMappingURL=AddOrganizationsModal.es.js.map