Liferay.Loader.define("frontend-taglib@4.1.5/translation_manager/TranslationManager.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-dropdown', 'frontend-taglib-clay$clay-modal', 'frontend-js-web', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './TranslationManager.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  require("frontend-taglib-clay$clay-dropdown");

  require("frontend-taglib-clay$clay-modal");

  var _frontendJsWeb = require("frontend-js-web");

  var _metal = require("frontend-js-metal-web$metal");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _TranslationManager = _interopRequireDefault(require("./TranslationManager.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * TranslationManager
   *
   * This class adds functionallity to manage existing language options, and
   * create new ones.
   * @review
   */
  var TranslationManager = /*#__PURE__*/function (_Component) {
    _inherits(TranslationManager, _Component);

    /**
     * @inheritDoc
     */
    function TranslationManager(opt_config, opt_element) {
      var _this;

      _classCallCheck(this, TranslationManager);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(TranslationManager).call(this, opt_config, opt_element));

      _this.resetEditingLocale_();

      _this.startCompatibility_();

      return _this;
    }
    /**
     * Add a language to the available locales list and set it as the
     * current editing language.
     * @param  {MouseEvent} event
     * @review
     */

    _createClass(TranslationManager, [{
      key: "addLocale",
      value: function addLocale(event) {
        var locale = event.data.item;

        if (this.availableLocales.indexOf(locale) === -1) {
          this.availableLocales.push(locale);
        }

        this.availableLocales = this.availableLocales;
        this.editingLocale = locale.id;
      }
      /**
       * Registers another EventTarget as a bubble target.
       * @param  {!Object} target YUI component where events will be emited to
       * @review
       */

    }, {
      key: "addTarget",
      value: function addTarget(target) {
        this.compatibilityEventProxy_.addTarget(target);
      }
      /**
       * Change the default language.
       * @param  {MouseEvent} event
       * @review
       */

    }, {
      key: "changeDefaultLocale",
      value: function changeDefaultLocale(event) {
        var localeId = event.delegateTarget.getAttribute('data-locale-id');
        this.defaultLocale = localeId;
        this.editingLocale = localeId;
      }
      /**
       * Change current editing language.
       * @param  {MouseEvent} event
       * @review
       */

    }, {
      key: "changeLocale",
      value: function changeLocale(event) {
        var localeId = event.delegateTarget.getAttribute('data-locale-id');
        this.editingLocale = localeId;
      }
      /**
       * Returns a property.
       * @param  {String} attr Name of the attribute wanted to get
       * @review
       */

    }, {
      key: "get",
      value: function get(attr) {
        return this[attr];
      }
      /**
       * Remove a language from the available locales list and reset the current
       * editing language to default if removed one was selected.
       * @param  {MouseEvent} event
       * @review
       */

    }, {
      key: "removeAvailableLocale",
      value: function removeAvailableLocale(_ref) {
        var _this2 = this;

        var delegateTarget = _ref.delegateTarget;
        var availableLocales = this.availableLocales;
        var localeId = delegateTarget.dataset.localeId;
        window.event.stopPropagation();
        this.refs.deleteModal.events = {
          clickButton: function clickButton(_ref2) {
            var target = _ref2.target;

            if (target.classList.contains('btn-primary')) {
              _this2.refs.deleteModal.emit('hide');

              _this2.availableLocales = availableLocales.filter(function (_ref3) {
                var id = _ref3.id;
                return id !== localeId;
              });

              if (localeId === _this2.editingLocale) {
                _this2.resetEditingLocale_();
              }

              _this2.emit('deleteAvailableLocale', {
                locale: localeId
              });
            }
          }
        };
        this.refs.deleteModal.show();
      }
      /**
       * Set the current editing locale to the default locale.
       * @private
       * @review
       */

    }, {
      key: "resetEditingLocale_",
      value: function resetEditingLocale_() {
        this.editingLocale = this.defaultLocale;
      }
      /**
       * Configuration to emit yui-based events to maintain
       * backwards compatibility.
       * @private
       * @review
       */

    }, {
      key: "startCompatibility_",
      value: function startCompatibility_() {
        this.destroy = this.dispose;
        this.compatibilityEventProxy_ = new _frontendJsWeb.CompatibilityEventProxy({
          host: this,
          namespace: 'translationmanager'
        });
      }
    }]);

    return TranslationManager;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @ignore
   * @review
   * @static
   * @type {!Object}
   */

  TranslationManager.STATE = {
    /**
     * List of available languages keys.
     * @review
     * @type {Array.<Object>}
     */
    availableLocales: {
      validator: _metal.core.isArray
    },

    /**
     * Indicates if the default language is editable or not.
     * @review
     * @type {Boolean}
     */
    changeableDefaultLanguage: {
      validator: _metal.core.isBoolean
    },

    /**
     * Default language key.
     * @review
     * @type {String}
     */
    defaultLocale: {
      validator: _metal.core.isString
    },

    /**
     * Current editing language key.
     * @review
     * @type {String}
     */
    editingLocale: {
      validator: _metal.core.isString
    },

    /**
     * Map of all languages
     * @review
     * @type {Object}
     */
    locales: {
      validator: _metal.core.isObject
    }
  };

  _metalSoy["default"].register(TranslationManager, _TranslationManager["default"]);

  var _default = TranslationManager;
  exports["default"] = _default;
  //# sourceMappingURL=TranslationManager.es.js.map
});
//# sourceMappingURL=TranslationManager.es.js.map