Liferay.Loader.define("commerce-frontend-taglib@9.1.3/quantity_selector/QuantitySelector.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './QuantitySelector.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.QuantitySelector = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  var _QuantitySelector = _interopRequireDefault(require("./QuantitySelector.soy"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var QuantitySelector = /*#__PURE__*/function (_Component) {
    _inherits(QuantitySelector, _Component);

    function QuantitySelector() {
      _classCallCheck(this, QuantitySelector);

      return _possibleConstructorReturn(this, _getPrototypeOf(QuantitySelector).apply(this, arguments));
    }

    _createClass(QuantitySelector, [{
      key: "attached",
      value: function attached() {
        this.inputDebounceTimeout = null;

        if (!this.quantity) {
          this.quantity = this.allowedQuantities ? this.allowedQuantities[0] : this.minQuantity;

          this._updateQuantity(this.quantity);
        }

        return !!this.quantity;
      }
    }, {
      key: "syncQuantity",
      value: function syncQuantity() {
        this.checkButtonsAvailability(this.quantity);
      }
    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        this.checkButtonsAvailability(state.quantity);
      }
    }, {
      key: "_handleSelectOption",
      value: function _handleSelectOption(e) {
        var quantity = parseInt(e.target.value, 10);
        return this.emit('updateQuantity', quantity);
      }
    }, {
      key: "checkButtonsAvailability",
      value: function checkButtonsAvailability(quantity) {
        this._prevAvailable = this._isPrevButtonAvailable(quantity);
        this._nextAvailable = this._isNextButtonAvailable(quantity);
      }
    }, {
      key: "_isPrevButtonAvailable",
      value: function _isPrevButtonAvailable(quantity) {
        var tempValue = this.multipleQuantity ? quantity - this.multipleQuantity : quantity - 1;
        return tempValue >= this.minQuantity;
      }
    }, {
      key: "_isNextButtonAvailable",
      value: function _isNextButtonAvailable(quantity) {
        var tempValue = this.multipleQuantity ? quantity + this.multipleQuantity : quantity + 1;
        return tempValue <= this.maxQuantity;
      }
    }, {
      key: "_handlePrevQuantityButtonPressed",
      value: function _handlePrevQuantityButtonPressed(e) {
        e.preventDefault();

        if (!this._prevAvailable) {
          this.showError = true;
          return false;
        }

        var quantity = this.quantity;

        if (this.multipleQuantity) {
          quantity -= this.multipleQuantity;
        } else {
          quantity -= 1;
        }

        if (quantity < this.minQuantity) {
          this.inputError = 'MaxAvailableReached';
          return false;
        }

        return this._updateQuantity(quantity);
      }
    }, {
      key: "_handleNextQuantityButtonPressed",
      value: function _handleNextQuantityButtonPressed(e) {
        e.preventDefault();

        if (!this._nextAvailable) {
          this.showError = true;
          return false;
        }

        var quantity = this.quantity;

        if (this.multipleQuantity) {
          quantity += this.multipleQuantity;
        } else {
          quantity += 1;
        }

        if (quantity > this.maxQuantity) {
          this.inputError = 'MaxAvailableReached';
          return false;
        }

        return this._updateQuantity(quantity);
      }
    }, {
      key: "_handleArrowKeys",
      value: function _handleArrowKeys(e) {
        if (e.keyCode == 38) {
          return this._handleNextQuantityButtonPressed(e);
        }

        if (e.keyCode == 40) {
          return this._handlePrevQuantityButtonPressed(e);
        }

        return e;
      }
    }, {
      key: "_handleInputKeyUp",
      value: function _handleInputKeyUp(e) {
        var _this = this;

        clearTimeout(this.inputDebounceTimeout);

        if (!e.target.value) {
          return null;
        }

        this.inputDebounceTimeout = setTimeout(function () {
          _this._submitQuantity(parseInt(e.target.value, 10));
        }, 500);
      }
    }, {
      key: "_handleFormSubmit",
      value: function _handleFormSubmit(e) {
        e.preventDefault();
        this.showError = true;
        return this.emit('submitQuantity', this.quantity);
      }
    }, {
      key: "_submitQuantity",
      value: function _submitQuantity(quantity) {
        var computedQuantity = quantity;

        if (this.multipleQuantity) {
          if (!computedQuantity || computedQuantity % this.multipleQuantity) {
            computedQuantity -= computedQuantity % this.multipleQuantity;
          }
        }

        if (computedQuantity < this.minQuantity) {
          computedQuantity = this.minQuantity;
        }

        if (computedQuantity > this.maxQuantity) {
          computedQuantity = this.maxQuantity;
        }

        this._updateQuantity(computedQuantity);
      }
    }, {
      key: "_updateQuantity",
      value: function _updateQuantity(quantity) {
        this.showError = false;
        return this.emit('updateQuantity', quantity);
      }
    }]);

    return QuantitySelector;
  }(_metalComponent["default"]);

  exports.QuantitySelector = QuantitySelector;
  QuantitySelector.STATE = {
    _nextAvailable: _metalSoy.Config.bool().value(true),
    _prevAvailable: _metalSoy.Config.bool().value(true),
    allowedQuantities: _metalSoy.Config.array(_metalSoy.Config.number()),
    disabled: _metalSoy.Config.bool().value(false),
    inputError: _metalSoy.Config.string(),
    maxQuantity: _metalSoy.Config.number().value(99999999),
    minQuantity: _metalSoy.Config.number().value(1),
    multipleQuantity: _metalSoy.Config.number(),
    quantity: _metalSoy.Config.number(),
    showError: _metalSoy.Config.bool().value(false)
  };

  _metalSoy["default"].register(QuantitySelector, _QuantitySelector["default"]);

  var _default = QuantitySelector;
  exports["default"] = _default;
  //# sourceMappingURL=QuantitySelector.es.js.map
});
//# sourceMappingURL=QuantitySelector.es.js.map