Liferay.Loader.define("frontend-taglib@4.1.5/diff_version_comparator/DiffVersionComparator.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './DiffVersionComparator.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.DiffVersionComparator = exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metal = require("frontend-js-metal-web$metal");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _DiffVersionComparator = _interopRequireDefault(require("./DiffVersionComparator.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * DiffVersionComparator
   *
   * Adds functionality for dynamically comparing the html of differing versions
   * of assets.
   * @review
   */
  var DiffVersionComparator = /*#__PURE__*/function (_Component) {
    _inherits(DiffVersionComparator, _Component);

    function DiffVersionComparator() {
      _classCallCheck(this, DiffVersionComparator);

      return _possibleConstructorReturn(this, _getPrototypeOf(DiffVersionComparator).apply(this, arguments));
    }

    _createClass(DiffVersionComparator, [{
      key: "findDiffVersion_",

      /**
       * Returns diffVerson object of passed version.
       * @param {String} version
       * @protected
       * @return {Object}
       * @review
       */
      value: function findDiffVersion_(version) {
        return this.diffVersions.find(function (diffVersion) {
          return diffVersion.version === version;
        });
      }
      /**
       * Handles click event of close button on version filter header.
       * @protected
       * @review
       */

    }, {
      key: "handleCloseFilterClick_",
      value: function handleCloseFilterClick_() {
        this.selectedVersion = null;
        this.loadDiffHtmlResults_(this.targetVersion);
      }
      /**
       * Handles change event of language select element. Submits form to change
       * language.
       * @protected
       * @review
       */

    }, {
      key: "handleLanguageChange_",
      value: function handleLanguageChange_() {
        submitForm(this.refs.form);
      }
      /**
       * Handles change event of search input. Filters results based on input.
       * @param {Event} event
       * @protected
       * @review
       */

    }, {
      key: "handleSearchChange_",
      value: function handleSearchChange_(event) {
        var query = event.target.value.toLowerCase();
        var resultsLength = 0;
        var diffVersions = this.diffVersions.map(function (diffVersion) {
          var label = diffVersion.label,
              userName = diffVersion.userName;
          var hidden = label.toLowerCase().indexOf(query) === -1 && userName.toLowerCase().indexOf(query) === -1;

          if (!hidden) {
            resultsLength++;
          }

          return _objectSpread({}, diffVersion, {
            hidden: hidden
          });
        });
        this.diffVersions = diffVersions;
        this.resultsLength = resultsLength;
      }
      /**
       * Handles click event of version items. Sets `selectedVersion` and loads
       * new `diffHtmlResults` value based on newly selected version.
       * @param {Event} event
       * @protected
       * @review
       */

    }, {
      key: "handleVersionItemClick_",
      value: function handleVersionItemClick_(event) {
        var targetVersion = event.delegateTarget.getAttribute('data-version');
        this.selectedVersion = this.findDiffVersion_(targetVersion);
        this.loadDiffHtmlResults_(targetVersion);
      }
      /**
       * Submits Ajax request for new `htmlDiffResults` value that will show the
       * diff between the `targetVersion` argument and currently selected
       * `sourceVersion`.
       * @param {String} targetVersion
       * @protected
       * @review
       */

    }, {
      key: "loadDiffHtmlResults_",
      value: function loadDiffHtmlResults_(targetVersion) {
        var _this = this;

        var portletNamespace = this.portletNamespace;
        var url = new URL(this.resourceURL);
        url.searchParams.append("".concat(portletNamespace, "filterSourceVersion"), "".concat(this.sourceVersion));
        url.searchParams.append("".concat(portletNamespace, "filterTargetVersion"), "".concat(targetVersion));
        (0, _frontendJsWeb.fetch)(url).then(function (res) {
          return res.text();
        }).then(function (text) {
          _this.diffHtmlResults = text;
        })["catch"](function () {
          _this.diffHtmlResults = Liferay.Language.get('an-error-occurred-while-processing-the-requested-resource');
        });
      }
      /**
       * Setter for the `diffHtmlResults` STATE property. Necessary because server
       * returns html values as object.
       * @param {Object|String} value
       * @protected
       * @review
       */

    }, {
      key: "setterDiffHtmlResults_",
      value: function setterDiffHtmlResults_(value) {
        if ((0, _metal.isObject)(value)) {
          value = value.value.content;
        }

        return value;
      }
    }]);

    return DiffVersionComparator;
  }(_metalComponent["default"]);

  exports.DiffVersionComparator = DiffVersionComparator;
  DiffVersionComparator.STATE = {
    /**
     * List of locales that are available for the current asset. Used to render
     * locale selector.
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {Array.<Object>}
     */
    availableLocales: _metalState.Config.array(),

    /**
     * HTML diff results that have been calculated by the server.
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {String|Object}
     */
    diffHtmlResults: _metalState.Config.setter('setterDiffHtmlResults_'),

    /**
     * Array of diffVersion objects used for rendering dropdown menus and target
     * list.
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {Array.<Object>}
     */
    diffVersions: _metalState.Config.array(),

    /**
     * Currently selected language id.
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {String}
     */
    languageId: _metalState.Config.string(),

    /**
     * Portlet namespace.
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {String}
     */
    portletNamespace: _metalState.Config.string(),

    /**
     * Portlet resource URL.
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {String}
     */
    resourceURL: _metalState.Config.string(),

    /**
     * Total length of results after search input is used.
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {number}
     */
    resultsLength: _metalState.Config.number(),

    /**
     * Currently selected version. Used for version filter header.
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {Object}
     */
    selectedVersion: _metalState.Config.object(),

    /**
     * Determines if version filter should display.
     * @default false
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {boolean}
     */
    showVersionFilter: _metalState.Config.bool().value(false),

    /**
     * Currently selected source version.
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {String}
     */
    sourceVersion: _metalState.Config.string(),

    /**
     * Currently selected target version.
     * @instance
     * @memberof DiffVersionComparator
     * @review
     * @type {String}
     */
    targetVersion: _metalState.Config.string()
  };

  _metalSoy["default"].register(DiffVersionComparator, _DiffVersionComparator["default"]);

  var _default = DiffVersionComparator;
  exports["default"] = _default;
  //# sourceMappingURL=DiffVersionComparator.es.js.map
});
//# sourceMappingURL=DiffVersionComparator.es.js.map