Liferay.Loader.define("asset-taglib@4.2.27/asset_tags_selector/AssetTagsSelector.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-multi-select', 'frontend-js-web', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './AssetTagsSelector.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.AssetTagsSelector = void 0;

  require("frontend-taglib-clay$clay-multi-select");

  var _frontendJsWeb = require("frontend-js-web");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _AssetTagsSelector = _interopRequireDefault(require("./AssetTagsSelector.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Wraps Clay's existing <code>MultiSelect</code> component that offers the user
   * a tag selection input.
   */
  var AssetTagsSelector = /*#__PURE__*/function (_Component) {
    _inherits(AssetTagsSelector, _Component);

    function AssetTagsSelector() {
      _classCallCheck(this, AssetTagsSelector);

      return _possibleConstructorReturn(this, _getPrototypeOf(AssetTagsSelector).apply(this, arguments));
    }

    _createClass(AssetTagsSelector, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        var _get2;

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        (_get2 = _get(_getPrototypeOf(AssetTagsSelector.prototype), "attached", this)).call.apply(_get2, [this].concat(args));

        this._dataSource = this._handleQuery.bind(this);
      }
      /**
       * Opens the tag selection dialog.
       *
       * @param {!Event} event The event.
       * @private
       */

    }, {
      key: "_handleButtonClicked",
      value: function _handleButtonClicked() {
        var _this = this;

        var uri = function sub(str, obj) {
          return str.replace(/\{([^}]+)\}/g, function (_, m) {
            return obj[m];
          });
        }(decodeURIComponent(this.portletURL), {
          selectedTagNames: this._getTagNames()
        });
        var itemSelectorDialog = new _frontendJsWeb.ItemSelectorDialog({
          buttonAddLabel: Liferay.Language.get('done'),
          eventName: this.eventName,
          title: Liferay.Language.get('tags'),
          url: uri
        });
        itemSelectorDialog.open();
        itemSelectorDialog.on('selectedItemChange', function (event) {
          var selectedItems = event.selectedItem;

          if (selectedItems) {
            var newValues = selectedItems.items.length > 0 ? selectedItems.items.split(',') : [];

            var oldItems = _this.selectedItems.slice();

            var oldValues = oldItems.map(function (item) {
              return item.value;
            });

            var valueMapper = function valueMapper(item) {
              return {
                label: item,
                value: item
              };
            };

            var addedItems = newValues.filter(function (value) {
              return !oldValues.includes(value);
            }).map(valueMapper);
            var removedItems = oldValues.filter(function (value) {
              return !newValues.includes(value);
            }).map(valueMapper);
            _this.selectedItems = newValues.map(valueMapper);
            _this.tagNames = _this._getTagNames();
            addedItems.forEach(function (item) {
              return _this._notifyItemsChanged('itemAdded', _this.addCallback, item);
            });
            removedItems.forEach(function (item) {
              return _this._notifyItemsChanged('itemRemoved', _this.removeCallback, item);
            });
          }
        });
      }
      /**
       * Converts the list of selected tags into a comma-separated serialized
       * version to be used as a fallback for old services and implementations.
       *
       * @private
       * @return {string} The serialized, comma-separated version of the selected items.
       */

    }, {
      key: "_getTagNames",
      value: function _getTagNames() {
        return this.selectedItems.map(function (selectedItem) {
          return selectedItem.value;
        }).join();
      }
      /**
       * Creates a tag with the text introduced in the input.
       *
       * @param  {!Event} event The event.
       */

    }, {
      key: "_handleInputBlur",
      value: function _handleInputBlur(event) {
        var filteredItems = event.target.filteredItems;

        if (!filteredItems || filteredItems && filteredItems.length === 0) {
          var inputValue = Liferay.Util.escape(event.target.inputValue);

          if (inputValue) {
            var existingTag = this.selectedItems.find(function (tag) {
              return tag.value === inputValue;
            });

            if (existingTag) {
              return;
            }

            var item = {
              label: inputValue,
              value: inputValue
            };
            this.selectedItems = this.selectedItems.concat(item);
            this.tagNames = this._getTagNames();

            this._notifyItemsChanged('itemAdded', this.addCallback, item);
          }
        }
      }
    }, {
      key: "_handleInputFocus",
      value: function _handleInputFocus(event) {
        this.emit('inputFocus', event);
      }
      /**
       * Updates tags fallback and notifies that a new tag has been added.
       *
       * @param {!Event} event The event.
       * @private
       */

    }, {
      key: "_handleItemAdded",
      value: function _handleItemAdded(event) {
        this.selectedItems = event.data.selectedItems;
        this.tagNames = this._getTagNames();

        this._notifyItemsChanged('itemAdded', this.addCallback, event.data.item);
      }
      /**
       * Updates tags fallback and notifies that a new tag has been removed.
       *
       * @param {!Event} event The event.
       * @private
       */

    }, {
      key: "_handleItemRemoved",
      value: function _handleItemRemoved(event) {
        this.selectedItems = event.data.selectedItems;
        this.tagNames = this._getTagNames();

        this._notifyItemsChanged('itemRemoved', this.removeCallback, event.data.item);
      }
      /**
       * Responds to user input to retrieve the list of available tags from the
       * tags search service.
       *
       * @param {!string} query
       * @private
       */

    }, {
      key: "_handleQuery",
      value: function _handleQuery(query) {
        var _this2 = this;

        return new Promise(function (resolve) {
          Liferay.Service('/assettag/search', {
            end: 20,
            groupIds: _this2.groupIds,
            name: "%".concat(query === '*' ? '' : query, "%"),
            start: 0,
            tagProperties: ''
          }, function (tags) {
            return resolve(tags.map(function (tag) {
              return tag.value;
            }));
          });
        });
      }
      /**
       * Notifies changed items
       *
       * @param {!string} eventName
       * @param {!Function} callback
       * @param {!object} item
       * @private
       */

    }, {
      key: "_notifyItemsChanged",
      value: function _notifyItemsChanged(eventName, callback, item) {
        if (callback) {
          window[callback](item);
        }

        this.emit(eventName, {
          item: item,
          selectedItems: this.selectedItems
        });
      }
    }, {
      key: "syncSelectedItems",
      value: function syncSelectedItems(event) {
        this.emit('selectedItemsChange', {
          selectedItems: event
        });
      }
    }]);

    return AssetTagsSelector;
  }(_metalComponent["default"]);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  exports.AssetTagsSelector = AssetTagsSelector;
  AssetTagsSelector.STATE = {
    /**
     * Function to call every time the input value changes.
     *
     * @default _handleQuery
     * @instance
     * @memberof AssetTagsSelector
     * @type {?func}
     */
    _dataSource: _metalState.Config.func().internal(),

    /**
     * Function to call when a tag is added.
     *
     * @default undefined
     * @instance
     * @memberof AssetTagsSelector
     * @type {?string}
     */
    addCallback: _metalState.Config.string(),

    /**
     * Event name which fires when the user selects a display page using the
     * item selector.
     *
     * @default undefined
     * @instance
     * @memberof AssetTagsSelector
     * @type {?string}
     */
    eventName: _metalState.Config.string(),

    /**
     * List of group IDs where tags should be located.
     *
     * @default undefined
     * @instance
     * @memberof AssetTagsSelector
     * @type {?string}
     */
    groupIds: _metalState.Config.array().value([]),

    /**
     * URL of a portlet to display the tags.
     *
     * @default undefined
     * @instance
     * @memberof AssetTagsSelector
     * @type {?string}
     */
    portletURL: _metalState.Config.string(),

    /**
     * Function to call when a tag is removed.
     *
     * @default undefined
     * @instance
     * @memberof AssetTagsSelector
     * @type {?string}
     */
    removeCallback: _metalState.Config.string(),

    /**
     * List of the selected items.
     *
     * @default []
     * @instance
     * @memberof AssetTagsSelector
     * @type {?Array<Object>}
     */
    selectedItems: _metalState.Config.array(_metalState.Config.object()).value([]),

    /**
     * A comma separated list of selected items.
     *
     * @default undefined
     * @instance
     * @memberof AssetTagsSelector
     * @review
     * @type {?string}
     */
    tagNames: _metalState.Config.string().value('')
  };

  _metalSoy["default"].register(AssetTagsSelector, _AssetTagsSelector["default"]);

  var _default = AssetTagsSelector;
  exports["default"] = _default;
  //# sourceMappingURL=AssetTagsSelector.es.js.map
});
//# sourceMappingURL=AssetTagsSelector.es.js.map