/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.portletconfiguration.util;

import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.filter.ActionRequestWrapper;

/**
 * @author Raymond Augé
 */
public class ConfigurationActionRequest
	extends ActionRequestWrapper implements ConfigurationPortletRequest {

	public ConfigurationActionRequest(
		ActionRequest actionRequest, PortletPreferences portletPreferences) {

		super(actionRequest);

		_portletPreferences = portletPreferences;
	}

	@Override
	public PortletPreferences getPreferences() {
		return _portletPreferences;
	}

	private final PortletPreferences _portletPreferences;

}