/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderModel;
import com.liferay.document.library.kernel.model.DLFolderSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DLFolder service. Represents a row in the &quot;DLFolder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DLFolderModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLFolderImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLFolderImpl
 * @generated
 */
@JSON(strict = true)
public class DLFolderModelImpl
	extends BaseModelImpl<DLFolder> implements DLFolderModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a document library folder model instance should use the <code>DLFolder</code> interface instead.
	 */
	public static final String TABLE_NAME = "DLFolder";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"folderId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"repositoryId", Types.BIGINT},
		{"mountPoint", Types.BOOLEAN}, {"parentFolderId", Types.BIGINT},
		{"treePath", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"lastPostDate", Types.TIMESTAMP},
		{"defaultFileEntryTypeId", Types.BIGINT}, {"hidden_", Types.BOOLEAN},
		{"restrictionType", Types.INTEGER},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("folderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("repositoryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("mountPoint", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("parentFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("treePath", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPostDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("defaultFileEntryTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("hidden_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("restrictionType", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DLFolder (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,folderId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,repositoryId LONG,mountPoint BOOLEAN,parentFolderId LONG,treePath STRING null,name VARCHAR(255) null,description STRING null,lastPostDate DATE null,defaultFileEntryTypeId LONG,hidden_ BOOLEAN,restrictionType INTEGER,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table DLFolder";

	public static final String ORDER_BY_JPQL =
		" ORDER BY dlFolder.parentFolderId ASC, dlFolder.name ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DLFolder.parentFolderId ASC, DLFolder.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.entity.cache.enabled.com.liferay.document.library.kernel.model.DLFolder"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.finder.cache.enabled.com.liferay.document.library.kernel.model.DLFolder"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.column.bitmask.enabled.com.liferay.document.library.kernel.model.DLFolder"),
		true);

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long FOLDERID_COLUMN_BITMASK = 2L;

	public static final long GROUPID_COLUMN_BITMASK = 4L;

	public static final long HIDDEN_COLUMN_BITMASK = 8L;

	public static final long MOUNTPOINT_COLUMN_BITMASK = 16L;

	public static final long NAME_COLUMN_BITMASK = 32L;

	public static final long PARENTFOLDERID_COLUMN_BITMASK = 64L;

	public static final long REPOSITORYID_COLUMN_BITMASK = 128L;

	public static final long STATUS_COLUMN_BITMASK = 256L;

	public static final long TREEPATH_COLUMN_BITMASK = 512L;

	public static final long UUID_COLUMN_BITMASK = 1024L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static DLFolder toModel(DLFolderSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		DLFolder model = new DLFolderImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setUuid(soapModel.getUuid());
		model.setFolderId(soapModel.getFolderId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setRepositoryId(soapModel.getRepositoryId());
		model.setMountPoint(soapModel.isMountPoint());
		model.setParentFolderId(soapModel.getParentFolderId());
		model.setTreePath(soapModel.getTreePath());
		model.setName(soapModel.getName());
		model.setDescription(soapModel.getDescription());
		model.setLastPostDate(soapModel.getLastPostDate());
		model.setDefaultFileEntryTypeId(soapModel.getDefaultFileEntryTypeId());
		model.setHidden(soapModel.isHidden());
		model.setRestrictionType(soapModel.getRestrictionType());
		model.setLastPublishDate(soapModel.getLastPublishDate());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<DLFolder> toModels(DLFolderSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<DLFolder> models = new ArrayList<DLFolder>(soapModels.length);

		for (DLFolderSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final String MAPPING_TABLE_DLFILEENTRYTYPES_DLFOLDERS_NAME =
		"DLFileEntryTypes_DLFolders";

	public static final Object[][]
		MAPPING_TABLE_DLFILEENTRYTYPES_DLFOLDERS_COLUMNS = {
			{"companyId", Types.BIGINT}, {"fileEntryTypeId", Types.BIGINT},
			{"folderId", Types.BIGINT}
		};

	public static final String
		MAPPING_TABLE_DLFILEENTRYTYPES_DLFOLDERS_SQL_CREATE =
			"create table DLFileEntryTypes_DLFolders (companyId LONG not null,fileEntryTypeId LONG not null,folderId LONG not null,primary key (fileEntryTypeId, folderId))";

	public static final boolean
		FINDER_CACHE_ENABLED_DLFILEENTRYTYPES_DLFOLDERS = GetterUtil.getBoolean(
			com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.DLFileEntryTypes_DLFolders"),
			true);

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.document.library.kernel.model.DLFolder"));

	public DLFolderModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _folderId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setFolderId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _folderId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DLFolder.class;
	}

	@Override
	public String getModelClassName() {
		return DLFolder.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DLFolder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DLFolder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFolder, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((DLFolder)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DLFolder, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DLFolder, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DLFolder)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DLFolder, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DLFolder, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, DLFolder>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			DLFolder.class.getClassLoader(), DLFolder.class,
			ModelWrapper.class);

		try {
			Constructor<DLFolder> constructor =
				(Constructor<DLFolder>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<DLFolder, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<DLFolder, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<DLFolder, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<DLFolder, Object>>();
		Map<String, BiConsumer<DLFolder, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<DLFolder, ?>>();

		attributeGetterFunctions.put("mvccVersion", DLFolder::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<DLFolder, Long>)DLFolder::setMvccVersion);
		attributeGetterFunctions.put("uuid", DLFolder::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<DLFolder, String>)DLFolder::setUuid);
		attributeGetterFunctions.put("folderId", DLFolder::getFolderId);
		attributeSetterBiConsumers.put(
			"folderId", (BiConsumer<DLFolder, Long>)DLFolder::setFolderId);
		attributeGetterFunctions.put("groupId", DLFolder::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId", (BiConsumer<DLFolder, Long>)DLFolder::setGroupId);
		attributeGetterFunctions.put("companyId", DLFolder::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId", (BiConsumer<DLFolder, Long>)DLFolder::setCompanyId);
		attributeGetterFunctions.put("userId", DLFolder::getUserId);
		attributeSetterBiConsumers.put(
			"userId", (BiConsumer<DLFolder, Long>)DLFolder::setUserId);
		attributeGetterFunctions.put("userName", DLFolder::getUserName);
		attributeSetterBiConsumers.put(
			"userName", (BiConsumer<DLFolder, String>)DLFolder::setUserName);
		attributeGetterFunctions.put("createDate", DLFolder::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate", (BiConsumer<DLFolder, Date>)DLFolder::setCreateDate);
		attributeGetterFunctions.put("modifiedDate", DLFolder::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<DLFolder, Date>)DLFolder::setModifiedDate);
		attributeGetterFunctions.put("repositoryId", DLFolder::getRepositoryId);
		attributeSetterBiConsumers.put(
			"repositoryId",
			(BiConsumer<DLFolder, Long>)DLFolder::setRepositoryId);
		attributeGetterFunctions.put("mountPoint", DLFolder::getMountPoint);
		attributeSetterBiConsumers.put(
			"mountPoint",
			(BiConsumer<DLFolder, Boolean>)DLFolder::setMountPoint);
		attributeGetterFunctions.put(
			"parentFolderId", DLFolder::getParentFolderId);
		attributeSetterBiConsumers.put(
			"parentFolderId",
			(BiConsumer<DLFolder, Long>)DLFolder::setParentFolderId);
		attributeGetterFunctions.put("treePath", DLFolder::getTreePath);
		attributeSetterBiConsumers.put(
			"treePath", (BiConsumer<DLFolder, String>)DLFolder::setTreePath);
		attributeGetterFunctions.put("name", DLFolder::getName);
		attributeSetterBiConsumers.put(
			"name", (BiConsumer<DLFolder, String>)DLFolder::setName);
		attributeGetterFunctions.put("description", DLFolder::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<DLFolder, String>)DLFolder::setDescription);
		attributeGetterFunctions.put("lastPostDate", DLFolder::getLastPostDate);
		attributeSetterBiConsumers.put(
			"lastPostDate",
			(BiConsumer<DLFolder, Date>)DLFolder::setLastPostDate);
		attributeGetterFunctions.put(
			"defaultFileEntryTypeId", DLFolder::getDefaultFileEntryTypeId);
		attributeSetterBiConsumers.put(
			"defaultFileEntryTypeId",
			(BiConsumer<DLFolder, Long>)DLFolder::setDefaultFileEntryTypeId);
		attributeGetterFunctions.put("hidden", DLFolder::getHidden);
		attributeSetterBiConsumers.put(
			"hidden", (BiConsumer<DLFolder, Boolean>)DLFolder::setHidden);
		attributeGetterFunctions.put(
			"restrictionType", DLFolder::getRestrictionType);
		attributeSetterBiConsumers.put(
			"restrictionType",
			(BiConsumer<DLFolder, Integer>)DLFolder::setRestrictionType);
		attributeGetterFunctions.put(
			"lastPublishDate", DLFolder::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<DLFolder, Date>)DLFolder::setLastPublishDate);
		attributeGetterFunctions.put("status", DLFolder::getStatus);
		attributeSetterBiConsumers.put(
			"status", (BiConsumer<DLFolder, Integer>)DLFolder::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", DLFolder::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<DLFolder, Long>)DLFolder::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", DLFolder::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<DLFolder, String>)DLFolder::setStatusByUserName);
		attributeGetterFunctions.put("statusDate", DLFolder::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate", (BiConsumer<DLFolder, Date>)DLFolder::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getFolderId() {
		return _folderId;
	}

	@Override
	public void setFolderId(long folderId) {
		_columnBitmask |= FOLDERID_COLUMN_BITMASK;

		if (!_setOriginalFolderId) {
			_setOriginalFolderId = true;

			_originalFolderId = _folderId;
		}

		_folderId = folderId;
	}

	public long getOriginalFolderId() {
		return _originalFolderId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getRepositoryId() {
		return _repositoryId;
	}

	@Override
	public void setRepositoryId(long repositoryId) {
		_columnBitmask |= REPOSITORYID_COLUMN_BITMASK;

		if (!_setOriginalRepositoryId) {
			_setOriginalRepositoryId = true;

			_originalRepositoryId = _repositoryId;
		}

		_repositoryId = repositoryId;
	}

	public long getOriginalRepositoryId() {
		return _originalRepositoryId;
	}

	@JSON
	@Override
	public boolean getMountPoint() {
		return _mountPoint;
	}

	@JSON
	@Override
	public boolean isMountPoint() {
		return _mountPoint;
	}

	@Override
	public void setMountPoint(boolean mountPoint) {
		_columnBitmask |= MOUNTPOINT_COLUMN_BITMASK;

		if (!_setOriginalMountPoint) {
			_setOriginalMountPoint = true;

			_originalMountPoint = _mountPoint;
		}

		_mountPoint = mountPoint;
	}

	public boolean getOriginalMountPoint() {
		return _originalMountPoint;
	}

	@JSON
	@Override
	public long getParentFolderId() {
		return _parentFolderId;
	}

	@Override
	public void setParentFolderId(long parentFolderId) {
		_columnBitmask = -1L;

		if (!_setOriginalParentFolderId) {
			_setOriginalParentFolderId = true;

			_originalParentFolderId = _parentFolderId;
		}

		_parentFolderId = parentFolderId;
	}

	public long getOriginalParentFolderId() {
		return _originalParentFolderId;
	}

	@JSON
	@Override
	public String getTreePath() {
		if (_treePath == null) {
			return "";
		}
		else {
			return _treePath;
		}
	}

	@Override
	public void setTreePath(String treePath) {
		_columnBitmask |= TREEPATH_COLUMN_BITMASK;

		if (_originalTreePath == null) {
			_originalTreePath = _treePath;
		}

		_treePath = treePath;
	}

	public String getOriginalTreePath() {
		return GetterUtil.getString(_originalTreePath);
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_columnBitmask = -1L;

		if (_originalName == null) {
			_originalName = _name;
		}

		_name = name;
	}

	public String getOriginalName() {
		return GetterUtil.getString(_originalName);
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@JSON
	@Override
	public Date getLastPostDate() {
		return _lastPostDate;
	}

	@Override
	public void setLastPostDate(Date lastPostDate) {
		_lastPostDate = lastPostDate;
	}

	@JSON
	@Override
	public long getDefaultFileEntryTypeId() {
		return _defaultFileEntryTypeId;
	}

	@Override
	public void setDefaultFileEntryTypeId(long defaultFileEntryTypeId) {
		_defaultFileEntryTypeId = defaultFileEntryTypeId;
	}

	@JSON
	@Override
	public boolean getHidden() {
		return _hidden;
	}

	@JSON
	@Override
	public boolean isHidden() {
		return _hidden;
	}

	@Override
	public void setHidden(boolean hidden) {
		_columnBitmask |= HIDDEN_COLUMN_BITMASK;

		if (!_setOriginalHidden) {
			_setOriginalHidden = true;

			_originalHidden = _hidden;
		}

		_hidden = hidden;
	}

	public boolean getOriginalHidden() {
		return _originalHidden;
	}

	@JSON
	@Override
	public int getRestrictionType() {
		return _restrictionType;
	}

	@Override
	public void setRestrictionType(int restrictionType) {
		_restrictionType = restrictionType;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		_columnBitmask |= STATUS_COLUMN_BITMASK;

		if (!_setOriginalStatus) {
			_setOriginalStatus = true;

			_originalStatus = _status;
		}

		_status = status;
	}

	public int getOriginalStatus() {
		return _originalStatus;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		_statusDate = statusDate;
	}

	@Override
	public long getContainerModelId() {
		return getFolderId();
	}

	@Override
	public void setContainerModelId(long containerModelId) {
		_folderId = containerModelId;
	}

	@Override
	public long getParentContainerModelId() {
		return getParentFolderId();
	}

	@Override
	public void setParentContainerModelId(long parentContainerModelId) {
		_parentFolderId = parentContainerModelId;
	}

	@Override
	public String getContainerModelName() {
		return String.valueOf(getName());
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(DLFolder.class.getName()));
	}

	@Override
	public com.liferay.trash.kernel.model.TrashEntry getTrashEntry()
		throws PortalException {

		if (!isInTrash()) {
			return null;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return trashEntry;
		}

		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			getTrashHandler();

		if (Validator.isNotNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			ContainerModel containerModel = null;

			try {
				containerModel = trashHandler.getParentContainerModel(this);
			}
			catch (NoSuchModelException noSuchModelException) {
				return null;
			}

			while (containerModel != null) {
				if (containerModel instanceof TrashedModel) {
					TrashedModel trashedModel = (TrashedModel)containerModel;

					return trashedModel.getTrashEntry();
				}

				trashHandler =
					com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
						getTrashHandler(
							trashHandler.getContainerModelClassName(
								containerModel.getContainerModelId()));

				if (trashHandler == null) {
					return null;
				}

				containerModel = trashHandler.getContainerModel(
					containerModel.getParentContainerModelId());
			}
		}

		return null;
	}

	@Override
	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}

	/**
	 * @deprecated As of Judson (7.1.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public com.liferay.portal.kernel.trash.TrashHandler getTrashHandler() {
		return com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
			getTrashHandler(getModelClassName());
	}

	@Override
	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInTrashContainer() {
		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			getTrashHandler();

		if ((trashHandler == null) ||
			Validator.isNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			return false;
		}

		try {
			ContainerModel containerModel =
				trashHandler.getParentContainerModel(this);

			if (containerModel == null) {
				return false;
			}

			if (containerModel instanceof TrashedModel) {
				return ((TrashedModel)containerModel).isInTrash();
			}
		}
		catch (Exception exception) {
		}

		return false;
	}

	@Override
	public boolean isInTrashExplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return true;
		}

		return false;
	}

	@Override
	public boolean isInTrashImplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return false;
		}

		return true;
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DLFolder.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DLFolder toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DLFolder>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DLFolderImpl dlFolderImpl = new DLFolderImpl();

		dlFolderImpl.setMvccVersion(getMvccVersion());
		dlFolderImpl.setUuid(getUuid());
		dlFolderImpl.setFolderId(getFolderId());
		dlFolderImpl.setGroupId(getGroupId());
		dlFolderImpl.setCompanyId(getCompanyId());
		dlFolderImpl.setUserId(getUserId());
		dlFolderImpl.setUserName(getUserName());
		dlFolderImpl.setCreateDate(getCreateDate());
		dlFolderImpl.setModifiedDate(getModifiedDate());
		dlFolderImpl.setRepositoryId(getRepositoryId());
		dlFolderImpl.setMountPoint(isMountPoint());
		dlFolderImpl.setParentFolderId(getParentFolderId());
		dlFolderImpl.setTreePath(getTreePath());
		dlFolderImpl.setName(getName());
		dlFolderImpl.setDescription(getDescription());
		dlFolderImpl.setLastPostDate(getLastPostDate());
		dlFolderImpl.setDefaultFileEntryTypeId(getDefaultFileEntryTypeId());
		dlFolderImpl.setHidden(isHidden());
		dlFolderImpl.setRestrictionType(getRestrictionType());
		dlFolderImpl.setLastPublishDate(getLastPublishDate());
		dlFolderImpl.setStatus(getStatus());
		dlFolderImpl.setStatusByUserId(getStatusByUserId());
		dlFolderImpl.setStatusByUserName(getStatusByUserName());
		dlFolderImpl.setStatusDate(getStatusDate());

		dlFolderImpl.resetOriginalValues();

		return dlFolderImpl;
	}

	@Override
	public int compareTo(DLFolder dlFolder) {
		int value = 0;

		if (getParentFolderId() < dlFolder.getParentFolderId()) {
			value = -1;
		}
		else if (getParentFolderId() > dlFolder.getParentFolderId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		value = getName().compareToIgnoreCase(dlFolder.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DLFolder)) {
			return false;
		}

		DLFolder dlFolder = (DLFolder)object;

		long primaryKey = dlFolder.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_originalUuid = _uuid;

		_originalFolderId = _folderId;

		_setOriginalFolderId = false;

		_originalGroupId = _groupId;

		_setOriginalGroupId = false;

		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_setModifiedDate = false;
		_originalRepositoryId = _repositoryId;

		_setOriginalRepositoryId = false;

		_originalMountPoint = _mountPoint;

		_setOriginalMountPoint = false;

		_originalParentFolderId = _parentFolderId;

		_setOriginalParentFolderId = false;

		_originalTreePath = _treePath;

		_originalName = _name;

		_originalHidden = _hidden;

		_setOriginalHidden = false;

		_originalStatus = _status;

		_setOriginalStatus = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DLFolder> toCacheModel() {
		DLFolderCacheModel dlFolderCacheModel = new DLFolderCacheModel();

		dlFolderCacheModel.mvccVersion = getMvccVersion();

		dlFolderCacheModel.uuid = getUuid();

		String uuid = dlFolderCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			dlFolderCacheModel.uuid = null;
		}

		dlFolderCacheModel.folderId = getFolderId();

		dlFolderCacheModel.groupId = getGroupId();

		dlFolderCacheModel.companyId = getCompanyId();

		dlFolderCacheModel.userId = getUserId();

		dlFolderCacheModel.userName = getUserName();

		String userName = dlFolderCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			dlFolderCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			dlFolderCacheModel.createDate = createDate.getTime();
		}
		else {
			dlFolderCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			dlFolderCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			dlFolderCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		dlFolderCacheModel.repositoryId = getRepositoryId();

		dlFolderCacheModel.mountPoint = isMountPoint();

		dlFolderCacheModel.parentFolderId = getParentFolderId();

		dlFolderCacheModel.treePath = getTreePath();

		String treePath = dlFolderCacheModel.treePath;

		if ((treePath != null) && (treePath.length() == 0)) {
			dlFolderCacheModel.treePath = null;
		}

		dlFolderCacheModel.name = getName();

		String name = dlFolderCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			dlFolderCacheModel.name = null;
		}

		dlFolderCacheModel.description = getDescription();

		String description = dlFolderCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			dlFolderCacheModel.description = null;
		}

		Date lastPostDate = getLastPostDate();

		if (lastPostDate != null) {
			dlFolderCacheModel.lastPostDate = lastPostDate.getTime();
		}
		else {
			dlFolderCacheModel.lastPostDate = Long.MIN_VALUE;
		}

		dlFolderCacheModel.defaultFileEntryTypeId = getDefaultFileEntryTypeId();

		dlFolderCacheModel.hidden = isHidden();

		dlFolderCacheModel.restrictionType = getRestrictionType();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			dlFolderCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			dlFolderCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		dlFolderCacheModel.status = getStatus();

		dlFolderCacheModel.statusByUserId = getStatusByUserId();

		dlFolderCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = dlFolderCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			dlFolderCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			dlFolderCacheModel.statusDate = statusDate.getTime();
		}
		else {
			dlFolderCacheModel.statusDate = Long.MIN_VALUE;
		}

		return dlFolderCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DLFolder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DLFolder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFolder, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((DLFolder)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<DLFolder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<DLFolder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFolder, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((DLFolder)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DLFolder>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private String _uuid;
	private String _originalUuid;
	private long _folderId;
	private long _originalFolderId;
	private boolean _setOriginalFolderId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _repositoryId;
	private long _originalRepositoryId;
	private boolean _setOriginalRepositoryId;
	private boolean _mountPoint;
	private boolean _originalMountPoint;
	private boolean _setOriginalMountPoint;
	private long _parentFolderId;
	private long _originalParentFolderId;
	private boolean _setOriginalParentFolderId;
	private String _treePath;
	private String _originalTreePath;
	private String _name;
	private String _originalName;
	private String _description;
	private Date _lastPostDate;
	private long _defaultFileEntryTypeId;
	private boolean _hidden;
	private boolean _originalHidden;
	private boolean _setOriginalHidden;
	private int _restrictionType;
	private Date _lastPublishDate;
	private int _status;
	private int _originalStatus;
	private boolean _setOriginalStatus;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;
	private long _columnBitmask;
	private DLFolder _escapedModel;

}