/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.workflow.kaleo.forms.constants;

/**
 * Holds action key constants used in the Kaleo Forms permission system.
 *
 * @author Marcellus Tavares
 */
public class KaleoFormsActionKeys {

	/**
	 * {@value #ADD_PROCESS} is the action key to use to check permissions for
	 * adding a Kaleo process.
	 */
	public static final String ADD_PROCESS = "ADD_PROCESS";

	/**
	 * {@value #COMPLETE_FORM} is the action key to use to check permissions for
	 * completing a Kaleo process's form.
	 */
	public static final String COMPLETE_FORM = "COMPLETE_FORM";

}