/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.service.base;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetVersion;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.GroupFinder;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.ImagePersistence;
import com.liferay.portal.kernel.service.persistence.LayoutFinder;
import com.liferay.portal.kernel.service.persistence.LayoutPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetBranchPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetVersionPersistence;
import com.liferay.portal.kernel.service.persistence.PluginSettingPersistence;
import com.liferay.portal.kernel.service.persistence.VirtualHostPersistence;
import com.liferay.portal.kernel.service.version.VersionService;
import com.liferay.portal.kernel.service.version.VersionServiceListener;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;

import java.io.Serializable;

import java.lang.reflect.Field;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the layout set local service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.portal.service.impl.LayoutSetLocalServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.portal.service.impl.LayoutSetLocalServiceImpl
 * @generated
 */
public abstract class LayoutSetLocalServiceBaseImpl
	extends BaseLocalServiceImpl
	implements IdentifiableOSGiService, LayoutSetLocalService,
			   VersionService<LayoutSet, LayoutSetVersion> {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>LayoutSetLocalService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>LayoutSetLocalServiceUtil</code>.
	 */

	/**
	 * Adds the layout set to the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect LayoutSetLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param layoutSet the layout set
	 * @return the layout set that was added
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public LayoutSet addLayoutSet(LayoutSet layoutSet) {
		layoutSet.setNew(true);

		return layoutSetPersistence.update(layoutSet);
	}

	/**
	 * Creates a new layout set. Does not add the layout set to the database.
	 *
	 * @return the new layout set
	 */
	@Override
	@Transactional(enabled = false)
	public LayoutSet create() {
		long primaryKey = counterLocalService.increment(
			LayoutSet.class.getName());

		LayoutSet draftLayoutSet = layoutSetPersistence.create(primaryKey);

		draftLayoutSet.setHeadId(primaryKey);

		return draftLayoutSet;
	}

	/**
	 * Deletes the layout set with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect LayoutSetLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param layoutSetId the primary key of the layout set
	 * @return the layout set that was removed
	 * @throws PortalException if a layout set with the primary key could not be found
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public LayoutSet deleteLayoutSet(long layoutSetId) throws PortalException {
		LayoutSet layoutSet = layoutSetPersistence.fetchByPrimaryKey(
			layoutSetId);

		if (layoutSet != null) {
			delete(layoutSet);
		}

		return layoutSet;
	}

	/**
	 * Deletes the layout set from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect LayoutSetLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param layoutSet the layout set
	 * @return the layout set that was removed
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public LayoutSet deleteLayoutSet(LayoutSet layoutSet) {
		try {
			delete(layoutSet);

			return layoutSet;
		}
		catch (PortalException portalException) {
			throw new SystemException(portalException);
		}
	}

	@Override
	public DynamicQuery dynamicQuery() {
		Class<?> clazz = getClass();

		return DynamicQueryFactoryUtil.forClass(
			LayoutSet.class, clazz.getClassLoader());
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
		return layoutSetPersistence.findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.LayoutSetModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end) {

		return layoutSetPersistence.findWithDynamicQuery(
			dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.LayoutSetModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator<T> orderByComparator) {

		return layoutSetPersistence.findWithDynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(DynamicQuery dynamicQuery) {
		return layoutSetPersistence.countWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		DynamicQuery dynamicQuery, Projection projection) {

		return layoutSetPersistence.countWithDynamicQuery(
			dynamicQuery, projection);
	}

	@Override
	public LayoutSet fetchLayoutSet(long layoutSetId) {
		return layoutSetPersistence.fetchByPrimaryKey(layoutSetId);
	}

	/**
	 * Returns the layout set with the primary key.
	 *
	 * @param layoutSetId the primary key of the layout set
	 * @return the layout set
	 * @throws PortalException if a layout set with the primary key could not be found
	 */
	@Override
	public LayoutSet getLayoutSet(long layoutSetId) throws PortalException {
		return layoutSetPersistence.findByPrimaryKey(layoutSetId);
	}

	@Override
	public ActionableDynamicQuery getActionableDynamicQuery() {
		ActionableDynamicQuery actionableDynamicQuery =
			new DefaultActionableDynamicQuery();

		actionableDynamicQuery.setBaseLocalService(layoutSetLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(LayoutSet.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName("layoutSetId");

		return actionableDynamicQuery;
	}

	@Override
	public IndexableActionableDynamicQuery
		getIndexableActionableDynamicQuery() {

		IndexableActionableDynamicQuery indexableActionableDynamicQuery =
			new IndexableActionableDynamicQuery();

		indexableActionableDynamicQuery.setBaseLocalService(
			layoutSetLocalService);
		indexableActionableDynamicQuery.setClassLoader(getClassLoader());
		indexableActionableDynamicQuery.setModelClass(LayoutSet.class);

		indexableActionableDynamicQuery.setPrimaryKeyPropertyName(
			"layoutSetId");

		return indexableActionableDynamicQuery;
	}

	protected void initActionableDynamicQuery(
		ActionableDynamicQuery actionableDynamicQuery) {

		actionableDynamicQuery.setBaseLocalService(layoutSetLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(LayoutSet.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName("layoutSetId");
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel deletePersistedModel(PersistedModel persistedModel)
		throws PortalException {

		return layoutSetLocalService.deleteLayoutSet((LayoutSet)persistedModel);
	}

	public BasePersistence<LayoutSet> getBasePersistence() {
		return layoutSetPersistence;
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel getPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return layoutSetPersistence.findByPrimaryKey(primaryKeyObj);
	}

	/**
	 * Returns a range of all the layout sets.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.LayoutSetModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of layout sets
	 * @param end the upper bound of the range of layout sets (not inclusive)
	 * @return the range of layout sets
	 */
	@Override
	public List<LayoutSet> getLayoutSets(int start, int end) {
		return layoutSetPersistence.findAll(start, end);
	}

	/**
	 * Returns the number of layout sets.
	 *
	 * @return the number of layout sets
	 */
	@Override
	public int getLayoutSetsCount() {
		return layoutSetPersistence.countAll();
	}

	/**
	 * Updates the layout set in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect LayoutSetLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param layoutSet the layout set
	 * @return the layout set that was updated
	 * @throws PortalException
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public LayoutSet updateLayoutSet(LayoutSet draftLayoutSet)
		throws PortalException {

		return updateDraft(draftLayoutSet);
	}

	/**
	 * Returns the layout set local service.
	 *
	 * @return the layout set local service
	 */
	public LayoutSetLocalService getLayoutSetLocalService() {
		return layoutSetLocalService;
	}

	/**
	 * Sets the layout set local service.
	 *
	 * @param layoutSetLocalService the layout set local service
	 */
	public void setLayoutSetLocalService(
		LayoutSetLocalService layoutSetLocalService) {

		this.layoutSetLocalService = layoutSetLocalService;
	}

	/**
	 * Returns the layout set persistence.
	 *
	 * @return the layout set persistence
	 */
	public LayoutSetPersistence getLayoutSetPersistence() {
		return layoutSetPersistence;
	}

	/**
	 * Sets the layout set persistence.
	 *
	 * @param layoutSetPersistence the layout set persistence
	 */
	public void setLayoutSetPersistence(
		LayoutSetPersistence layoutSetPersistence) {

		this.layoutSetPersistence = layoutSetPersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	/**
	 * Returns the group local service.
	 *
	 * @return the group local service
	 */
	public com.liferay.portal.kernel.service.GroupLocalService
		getGroupLocalService() {

		return groupLocalService;
	}

	/**
	 * Sets the group local service.
	 *
	 * @param groupLocalService the group local service
	 */
	public void setGroupLocalService(
		com.liferay.portal.kernel.service.GroupLocalService groupLocalService) {

		this.groupLocalService = groupLocalService;
	}

	/**
	 * Returns the group persistence.
	 *
	 * @return the group persistence
	 */
	public GroupPersistence getGroupPersistence() {
		return groupPersistence;
	}

	/**
	 * Sets the group persistence.
	 *
	 * @param groupPersistence the group persistence
	 */
	public void setGroupPersistence(GroupPersistence groupPersistence) {
		this.groupPersistence = groupPersistence;
	}

	/**
	 * Returns the group finder.
	 *
	 * @return the group finder
	 */
	public GroupFinder getGroupFinder() {
		return groupFinder;
	}

	/**
	 * Sets the group finder.
	 *
	 * @param groupFinder the group finder
	 */
	public void setGroupFinder(GroupFinder groupFinder) {
		this.groupFinder = groupFinder;
	}

	/**
	 * Returns the image local service.
	 *
	 * @return the image local service
	 */
	public com.liferay.portal.kernel.service.ImageLocalService
		getImageLocalService() {

		return imageLocalService;
	}

	/**
	 * Sets the image local service.
	 *
	 * @param imageLocalService the image local service
	 */
	public void setImageLocalService(
		com.liferay.portal.kernel.service.ImageLocalService imageLocalService) {

		this.imageLocalService = imageLocalService;
	}

	/**
	 * Returns the image persistence.
	 *
	 * @return the image persistence
	 */
	public ImagePersistence getImagePersistence() {
		return imagePersistence;
	}

	/**
	 * Sets the image persistence.
	 *
	 * @param imagePersistence the image persistence
	 */
	public void setImagePersistence(ImagePersistence imagePersistence) {
		this.imagePersistence = imagePersistence;
	}

	/**
	 * Returns the layout local service.
	 *
	 * @return the layout local service
	 */
	public com.liferay.portal.kernel.service.LayoutLocalService
		getLayoutLocalService() {

		return layoutLocalService;
	}

	/**
	 * Sets the layout local service.
	 *
	 * @param layoutLocalService the layout local service
	 */
	public void setLayoutLocalService(
		com.liferay.portal.kernel.service.LayoutLocalService
			layoutLocalService) {

		this.layoutLocalService = layoutLocalService;
	}

	/**
	 * Returns the layout persistence.
	 *
	 * @return the layout persistence
	 */
	public LayoutPersistence getLayoutPersistence() {
		return layoutPersistence;
	}

	/**
	 * Sets the layout persistence.
	 *
	 * @param layoutPersistence the layout persistence
	 */
	public void setLayoutPersistence(LayoutPersistence layoutPersistence) {
		this.layoutPersistence = layoutPersistence;
	}

	/**
	 * Returns the layout finder.
	 *
	 * @return the layout finder
	 */
	public LayoutFinder getLayoutFinder() {
		return layoutFinder;
	}

	/**
	 * Sets the layout finder.
	 *
	 * @param layoutFinder the layout finder
	 */
	public void setLayoutFinder(LayoutFinder layoutFinder) {
		this.layoutFinder = layoutFinder;
	}

	/**
	 * Returns the layout set version persistence.
	 *
	 * @return the layout set version persistence
	 */
	public LayoutSetVersionPersistence getLayoutSetVersionPersistence() {
		return layoutSetVersionPersistence;
	}

	/**
	 * Sets the layout set version persistence.
	 *
	 * @param layoutSetVersionPersistence the layout set version persistence
	 */
	public void setLayoutSetVersionPersistence(
		LayoutSetVersionPersistence layoutSetVersionPersistence) {

		this.layoutSetVersionPersistence = layoutSetVersionPersistence;
	}

	/**
	 * Returns the layout set branch local service.
	 *
	 * @return the layout set branch local service
	 */
	public com.liferay.portal.kernel.service.LayoutSetBranchLocalService
		getLayoutSetBranchLocalService() {

		return layoutSetBranchLocalService;
	}

	/**
	 * Sets the layout set branch local service.
	 *
	 * @param layoutSetBranchLocalService the layout set branch local service
	 */
	public void setLayoutSetBranchLocalService(
		com.liferay.portal.kernel.service.LayoutSetBranchLocalService
			layoutSetBranchLocalService) {

		this.layoutSetBranchLocalService = layoutSetBranchLocalService;
	}

	/**
	 * Returns the layout set branch persistence.
	 *
	 * @return the layout set branch persistence
	 */
	public LayoutSetBranchPersistence getLayoutSetBranchPersistence() {
		return layoutSetBranchPersistence;
	}

	/**
	 * Sets the layout set branch persistence.
	 *
	 * @param layoutSetBranchPersistence the layout set branch persistence
	 */
	public void setLayoutSetBranchPersistence(
		LayoutSetBranchPersistence layoutSetBranchPersistence) {

		this.layoutSetBranchPersistence = layoutSetBranchPersistence;
	}

	/**
	 * Returns the plugin setting local service.
	 *
	 * @return the plugin setting local service
	 */
	public com.liferay.portal.kernel.service.PluginSettingLocalService
		getPluginSettingLocalService() {

		return pluginSettingLocalService;
	}

	/**
	 * Sets the plugin setting local service.
	 *
	 * @param pluginSettingLocalService the plugin setting local service
	 */
	public void setPluginSettingLocalService(
		com.liferay.portal.kernel.service.PluginSettingLocalService
			pluginSettingLocalService) {

		this.pluginSettingLocalService = pluginSettingLocalService;
	}

	/**
	 * Returns the plugin setting persistence.
	 *
	 * @return the plugin setting persistence
	 */
	public PluginSettingPersistence getPluginSettingPersistence() {
		return pluginSettingPersistence;
	}

	/**
	 * Sets the plugin setting persistence.
	 *
	 * @param pluginSettingPersistence the plugin setting persistence
	 */
	public void setPluginSettingPersistence(
		PluginSettingPersistence pluginSettingPersistence) {

		this.pluginSettingPersistence = pluginSettingPersistence;
	}

	/**
	 * Returns the virtual host local service.
	 *
	 * @return the virtual host local service
	 */
	public com.liferay.portal.kernel.service.VirtualHostLocalService
		getVirtualHostLocalService() {

		return virtualHostLocalService;
	}

	/**
	 * Sets the virtual host local service.
	 *
	 * @param virtualHostLocalService the virtual host local service
	 */
	public void setVirtualHostLocalService(
		com.liferay.portal.kernel.service.VirtualHostLocalService
			virtualHostLocalService) {

		this.virtualHostLocalService = virtualHostLocalService;
	}

	/**
	 * Returns the virtual host persistence.
	 *
	 * @return the virtual host persistence
	 */
	public VirtualHostPersistence getVirtualHostPersistence() {
		return virtualHostPersistence;
	}

	/**
	 * Sets the virtual host persistence.
	 *
	 * @param virtualHostPersistence the virtual host persistence
	 */
	public void setVirtualHostPersistence(
		VirtualHostPersistence virtualHostPersistence) {

		this.virtualHostPersistence = virtualHostPersistence;
	}

	public void afterPropertiesSet() {
		persistedModelLocalServiceRegistry.register(
			"com.liferay.portal.kernel.model.LayoutSet", layoutSetLocalService);

		_setLocalServiceUtilService(layoutSetLocalService);
	}

	public void destroy() {
		persistedModelLocalServiceRegistry.unregister(
			"com.liferay.portal.kernel.model.LayoutSet");

		_setLocalServiceUtilService(null);
	}

	@Indexable(type = IndexableType.REINDEX)
	@Override
	public LayoutSet checkout(LayoutSet publishedLayoutSet, int version)
		throws PortalException {

		if (!publishedLayoutSet.isHead()) {
			throw new IllegalArgumentException(
				"Unable to checkout with unpublished changes " +
					publishedLayoutSet.getHeadId());
		}

		LayoutSet draftLayoutSet = layoutSetPersistence.fetchByHeadId(
			publishedLayoutSet.getPrimaryKey());

		if (draftLayoutSet != null) {
			throw new IllegalArgumentException(
				"Unable to checkout with unpublished changes " +
					publishedLayoutSet.getPrimaryKey());
		}

		LayoutSetVersion layoutSetVersion = getVersion(
			publishedLayoutSet, version);

		draftLayoutSet = _createDraft(publishedLayoutSet);

		layoutSetVersion.populateVersionedModel(draftLayoutSet);

		draftLayoutSet = layoutSetPersistence.update(draftLayoutSet);

		for (VersionServiceListener<LayoutSet, LayoutSetVersion>
				versionServiceListener : _versionServiceListeners) {

			versionServiceListener.afterCheckout(draftLayoutSet, version);
		}

		return draftLayoutSet;
	}

	@Indexable(type = IndexableType.DELETE)
	@Override
	public LayoutSet delete(LayoutSet publishedLayoutSet)
		throws PortalException {

		if (!publishedLayoutSet.isHead()) {
			throw new IllegalArgumentException(
				"LayoutSet is a draft " + publishedLayoutSet.getPrimaryKey());
		}

		LayoutSet draftLayoutSet = layoutSetPersistence.fetchByHeadId(
			publishedLayoutSet.getPrimaryKey());

		if (draftLayoutSet != null) {
			deleteDraft(draftLayoutSet);
		}

		for (LayoutSetVersion layoutSetVersion :
				getVersions(publishedLayoutSet)) {

			layoutSetVersionPersistence.remove(layoutSetVersion);
		}

		layoutSetPersistence.remove(publishedLayoutSet);

		for (VersionServiceListener<LayoutSet, LayoutSetVersion>
				versionServiceListener : _versionServiceListeners) {

			versionServiceListener.afterDelete(publishedLayoutSet);
		}

		return publishedLayoutSet;
	}

	@Indexable(type = IndexableType.DELETE)
	@Override
	public LayoutSet deleteDraft(LayoutSet draftLayoutSet)
		throws PortalException {

		if (draftLayoutSet.isHead()) {
			throw new IllegalArgumentException(
				"LayoutSet is not a draft " + draftLayoutSet.getPrimaryKey());
		}

		layoutSetPersistence.remove(draftLayoutSet);

		for (VersionServiceListener<LayoutSet, LayoutSetVersion>
				versionServiceListener : _versionServiceListeners) {

			versionServiceListener.afterDeleteDraft(draftLayoutSet);
		}

		return draftLayoutSet;
	}

	@Override
	public LayoutSetVersion deleteVersion(LayoutSetVersion layoutSetVersion)
		throws PortalException {

		LayoutSetVersion latestLayoutSetVersion =
			layoutSetVersionPersistence.findByLayoutSetId_First(
				layoutSetVersion.getVersionedModelId(), null);

		if (latestLayoutSetVersion.getVersion() ==
				layoutSetVersion.getVersion()) {

			throw new IllegalArgumentException(
				"Unable to delete latest version " +
					layoutSetVersion.getVersion());
		}

		layoutSetVersion = layoutSetVersionPersistence.remove(layoutSetVersion);

		for (VersionServiceListener<LayoutSet, LayoutSetVersion>
				versionServiceListener : _versionServiceListeners) {

			versionServiceListener.afterDeleteVersion(layoutSetVersion);
		}

		return layoutSetVersion;
	}

	@Override
	public LayoutSet fetchDraft(LayoutSet layoutSet) {
		if (layoutSet.isHead()) {
			return layoutSetPersistence.fetchByHeadId(
				layoutSet.getPrimaryKey());
		}

		return layoutSet;
	}

	@Override
	public LayoutSet fetchDraft(long primaryKey) {
		return layoutSetPersistence.fetchByHeadId(primaryKey);
	}

	@Override
	public LayoutSetVersion fetchLatestVersion(LayoutSet layoutSet) {
		long primaryKey = layoutSet.getHeadId();

		if (layoutSet.isHead()) {
			primaryKey = layoutSet.getPrimaryKey();
		}

		return layoutSetVersionPersistence.fetchByLayoutSetId_First(
			primaryKey, null);
	}

	@Override
	public LayoutSet fetchPublished(LayoutSet layoutSet) {
		if (layoutSet.isHead()) {
			return layoutSet;
		}

		if (layoutSet.getHeadId() == layoutSet.getPrimaryKey()) {
			return null;
		}

		return layoutSetPersistence.fetchByPrimaryKey(layoutSet.getHeadId());
	}

	@Override
	public LayoutSet fetchPublished(long primaryKey) {
		LayoutSet layoutSet = layoutSetPersistence.fetchByPrimaryKey(
			primaryKey);

		if ((layoutSet == null) ||
			(layoutSet.getHeadId() == layoutSet.getPrimaryKey())) {

			return null;
		}

		return layoutSet;
	}

	@Override
	public LayoutSet getDraft(LayoutSet layoutSet) throws PortalException {
		if (!layoutSet.isHead()) {
			return layoutSet;
		}

		LayoutSet draftLayoutSet = layoutSetPersistence.fetchByHeadId(
			layoutSet.getPrimaryKey());

		if (draftLayoutSet == null) {
			draftLayoutSet = layoutSetLocalService.updateDraft(
				_createDraft(layoutSet));
		}

		return draftLayoutSet;
	}

	@Override
	public LayoutSet getDraft(long primaryKey) throws PortalException {
		LayoutSet draftLayoutSet = layoutSetPersistence.fetchByHeadId(
			primaryKey);

		if (draftLayoutSet == null) {
			LayoutSet layoutSet = layoutSetPersistence.findByPrimaryKey(
				primaryKey);

			draftLayoutSet = layoutSetLocalService.updateDraft(
				_createDraft(layoutSet));
		}

		return draftLayoutSet;
	}

	@Override
	public LayoutSetVersion getVersion(LayoutSet layoutSet, int version)
		throws PortalException {

		long primaryKey = layoutSet.getHeadId();

		if (layoutSet.isHead()) {
			primaryKey = layoutSet.getPrimaryKey();
		}

		return layoutSetVersionPersistence.findByLayoutSetId_Version(
			primaryKey, version);
	}

	@Override
	public List<LayoutSetVersion> getVersions(LayoutSet layoutSet) {
		long primaryKey = layoutSet.getPrimaryKey();

		if (!layoutSet.isHead()) {
			if (layoutSet.getHeadId() == layoutSet.getPrimaryKey()) {
				return Collections.emptyList();
			}

			primaryKey = layoutSet.getHeadId();
		}

		return layoutSetVersionPersistence.findByLayoutSetId(primaryKey);
	}

	@Indexable(type = IndexableType.REINDEX)
	@Override
	public LayoutSet publishDraft(LayoutSet draftLayoutSet)
		throws PortalException {

		if (draftLayoutSet.isHead()) {
			throw new IllegalArgumentException(
				"Can only publish drafts " + draftLayoutSet.getPrimaryKey());
		}

		LayoutSet headLayoutSet = null;

		int version = 1;

		if (draftLayoutSet.getHeadId() == draftLayoutSet.getPrimaryKey()) {
			headLayoutSet = create();

			draftLayoutSet.setHeadId(headLayoutSet.getPrimaryKey());
		}
		else {
			headLayoutSet = layoutSetPersistence.findByPrimaryKey(
				draftLayoutSet.getHeadId());

			LayoutSetVersion latestLayoutSetVersion =
				layoutSetVersionPersistence.findByLayoutSetId_First(
					draftLayoutSet.getHeadId(), null);

			version = latestLayoutSetVersion.getVersion() + 1;
		}

		LayoutSetVersion layoutSetVersion = layoutSetVersionPersistence.create(
			counterLocalService.increment(LayoutSetVersion.class.getName()));

		layoutSetVersion.setVersion(version);
		layoutSetVersion.setVersionedModelId(headLayoutSet.getPrimaryKey());

		draftLayoutSet.populateVersionModel(layoutSetVersion);

		layoutSetVersionPersistence.update(layoutSetVersion);

		layoutSetVersion.populateVersionedModel(headLayoutSet);

		headLayoutSet.setHeadId(-headLayoutSet.getPrimaryKey());

		headLayoutSet = layoutSetPersistence.update(headLayoutSet);

		for (VersionServiceListener<LayoutSet, LayoutSetVersion>
				versionServiceListener : _versionServiceListeners) {

			versionServiceListener.afterPublishDraft(draftLayoutSet, version);
		}

		deleteDraft(draftLayoutSet);

		return headLayoutSet;
	}

	@Override
	public void registerListener(
		VersionServiceListener<LayoutSet, LayoutSetVersion>
			versionServiceListener) {

		_versionServiceListeners.add(versionServiceListener);
	}

	@Override
	public void unregisterListener(
		VersionServiceListener<LayoutSet, LayoutSetVersion>
			versionServiceListener) {

		_versionServiceListeners.remove(versionServiceListener);
	}

	@Indexable(type = IndexableType.REINDEX)
	@Override
	public LayoutSet updateDraft(LayoutSet draftLayoutSet)
		throws PortalException {

		if (draftLayoutSet.isHead()) {
			throw new IllegalArgumentException(
				"Can only update draft entries " +
					draftLayoutSet.getPrimaryKey());
		}

		LayoutSet previousLayoutSet = layoutSetPersistence.fetchByPrimaryKey(
			draftLayoutSet.getPrimaryKey());

		draftLayoutSet = layoutSetPersistence.update(draftLayoutSet);

		if (previousLayoutSet == null) {
			for (VersionServiceListener<LayoutSet, LayoutSetVersion>
					versionServiceListener : _versionServiceListeners) {

				versionServiceListener.afterCreateDraft(draftLayoutSet);
			}
		}
		else {
			for (VersionServiceListener<LayoutSet, LayoutSetVersion>
					versionServiceListener : _versionServiceListeners) {

				versionServiceListener.afterUpdateDraft(draftLayoutSet);
			}
		}

		return draftLayoutSet;
	}

	private LayoutSet _createDraft(LayoutSet publishedLayoutSet)
		throws PortalException {

		LayoutSet draftLayoutSet = create();

		draftLayoutSet.setHeadId(publishedLayoutSet.getPrimaryKey());
		draftLayoutSet.setGroupId(publishedLayoutSet.getGroupId());
		draftLayoutSet.setCompanyId(publishedLayoutSet.getCompanyId());
		draftLayoutSet.setCreateDate(publishedLayoutSet.getCreateDate());
		draftLayoutSet.setModifiedDate(publishedLayoutSet.getModifiedDate());
		draftLayoutSet.setPrivateLayout(publishedLayoutSet.getPrivateLayout());
		draftLayoutSet.setLogoId(publishedLayoutSet.getLogoId());
		draftLayoutSet.setThemeId(publishedLayoutSet.getThemeId());
		draftLayoutSet.setColorSchemeId(publishedLayoutSet.getColorSchemeId());
		draftLayoutSet.setCss(publishedLayoutSet.getCss());
		draftLayoutSet.setPageCount(publishedLayoutSet.getPageCount());
		draftLayoutSet.setSettings(publishedLayoutSet.getSettings());
		draftLayoutSet.setLayoutSetPrototypeUuid(
			publishedLayoutSet.getLayoutSetPrototypeUuid());
		draftLayoutSet.setLayoutSetPrototypeLinkEnabled(
			publishedLayoutSet.getLayoutSetPrototypeLinkEnabled());

		draftLayoutSet.resetOriginalValues();

		return draftLayoutSet;
	}

	private final Set<VersionServiceListener<LayoutSet, LayoutSetVersion>>
		_versionServiceListeners = Collections.newSetFromMap(
			new ConcurrentHashMap
				<VersionServiceListener<LayoutSet, LayoutSetVersion>,
				 Boolean>());

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return LayoutSetLocalService.class.getName();
	}

	protected Class<?> getModelClass() {
		return LayoutSet.class;
	}

	protected String getModelClassName() {
		return LayoutSet.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		try {
			DataSource dataSource = layoutSetPersistence.getDataSource();

			DB db = DBManagerUtil.getDB();

			sql = db.buildSQL(sql);
			sql = PortalUtil.transformSQL(sql);

			SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(
				dataSource, sql);

			sqlUpdate.update();
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	private void _setLocalServiceUtilService(
		LayoutSetLocalService layoutSetLocalService) {

		try {
			Field field = LayoutSetLocalServiceUtil.class.getDeclaredField(
				"_service");

			field.setAccessible(true);

			field.set(null, layoutSetLocalService);
		}
		catch (ReflectiveOperationException reflectiveOperationException) {
			throw new RuntimeException(reflectiveOperationException);
		}
	}

	@BeanReference(type = LayoutSetLocalService.class)
	protected LayoutSetLocalService layoutSetLocalService;

	@BeanReference(type = LayoutSetPersistence.class)
	protected LayoutSetPersistence layoutSetPersistence;

	@BeanReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	@BeanReference(
		type = com.liferay.portal.kernel.service.GroupLocalService.class
	)
	protected com.liferay.portal.kernel.service.GroupLocalService
		groupLocalService;

	@BeanReference(type = GroupPersistence.class)
	protected GroupPersistence groupPersistence;

	@BeanReference(type = GroupFinder.class)
	protected GroupFinder groupFinder;

	@BeanReference(
		type = com.liferay.portal.kernel.service.ImageLocalService.class
	)
	protected com.liferay.portal.kernel.service.ImageLocalService
		imageLocalService;

	@BeanReference(type = ImagePersistence.class)
	protected ImagePersistence imagePersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.LayoutLocalService.class
	)
	protected com.liferay.portal.kernel.service.LayoutLocalService
		layoutLocalService;

	@BeanReference(type = LayoutPersistence.class)
	protected LayoutPersistence layoutPersistence;

	@BeanReference(type = LayoutFinder.class)
	protected LayoutFinder layoutFinder;

	@BeanReference(type = LayoutSetVersionPersistence.class)
	protected LayoutSetVersionPersistence layoutSetVersionPersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.LayoutSetBranchLocalService.class
	)
	protected com.liferay.portal.kernel.service.LayoutSetBranchLocalService
		layoutSetBranchLocalService;

	@BeanReference(type = LayoutSetBranchPersistence.class)
	protected LayoutSetBranchPersistence layoutSetBranchPersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.PluginSettingLocalService.class
	)
	protected com.liferay.portal.kernel.service.PluginSettingLocalService
		pluginSettingLocalService;

	@BeanReference(type = PluginSettingPersistence.class)
	protected PluginSettingPersistence pluginSettingPersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.VirtualHostLocalService.class
	)
	protected com.liferay.portal.kernel.service.VirtualHostLocalService
		virtualHostLocalService;

	@BeanReference(type = VirtualHostPersistence.class)
	protected VirtualHostPersistence virtualHostPersistence;

	@BeanReference(type = PersistedModelLocalServiceRegistry.class)
	protected PersistedModelLocalServiceRegistry
		persistedModelLocalServiceRegistry;

}