/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.service;

/**
 * Provides a wrapper for {@link ClusterGroupLocalService}.
 *
 * @author Brian Wing Shun Chan
 * @see ClusterGroupLocalService
 * @deprecated
 * @generated
 */
@Deprecated
public class ClusterGroupLocalServiceWrapper
	implements ClusterGroupLocalService,
			   ServiceWrapper<ClusterGroupLocalService> {

	public ClusterGroupLocalServiceWrapper(
		ClusterGroupLocalService clusterGroupLocalService) {

		_clusterGroupLocalService = clusterGroupLocalService;
	}

	/**
	 * Adds the cluster group to the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect ClusterGroupLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param clusterGroup the cluster group
	 * @return the cluster group that was added
	 */
	@Override
	public com.liferay.portal.kernel.model.ClusterGroup addClusterGroup(
		com.liferay.portal.kernel.model.ClusterGroup clusterGroup) {

		return _clusterGroupLocalService.addClusterGroup(clusterGroup);
	}

	@Override
	public com.liferay.portal.kernel.model.ClusterGroup addClusterGroup(
		java.lang.String name,
		java.util.List<java.lang.String> clusterNodeIds) {

		return _clusterGroupLocalService.addClusterGroup(name, clusterNodeIds);
	}

	@Override
	public com.liferay.portal.kernel.model.ClusterGroup addWholeClusterGroup(
		java.lang.String name) {

		return _clusterGroupLocalService.addWholeClusterGroup(name);
	}

	/**
	 * Creates a new cluster group with the primary key. Does not add the cluster group to the database.
	 *
	 * @param clusterGroupId the primary key for the new cluster group
	 * @return the new cluster group
	 */
	@Override
	public com.liferay.portal.kernel.model.ClusterGroup createClusterGroup(
		long clusterGroupId) {

		return _clusterGroupLocalService.createClusterGroup(clusterGroupId);
	}

	/**
	 * Deletes the cluster group from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect ClusterGroupLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param clusterGroup the cluster group
	 * @return the cluster group that was removed
	 */
	@Override
	public com.liferay.portal.kernel.model.ClusterGroup deleteClusterGroup(
		com.liferay.portal.kernel.model.ClusterGroup clusterGroup) {

		return _clusterGroupLocalService.deleteClusterGroup(clusterGroup);
	}

	/**
	 * Deletes the cluster group with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect ClusterGroupLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param clusterGroupId the primary key of the cluster group
	 * @return the cluster group that was removed
	 * @throws PortalException if a cluster group with the primary key could not be found
	 */
	@Override
	public com.liferay.portal.kernel.model.ClusterGroup deleteClusterGroup(
			long clusterGroupId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _clusterGroupLocalService.deleteClusterGroup(clusterGroupId);
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public com.liferay.portal.kernel.model.PersistedModel deletePersistedModel(
			com.liferay.portal.kernel.model.PersistedModel persistedModel)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _clusterGroupLocalService.deletePersistedModel(persistedModel);
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
		return _clusterGroupLocalService.dynamicQuery();
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery) {

		return _clusterGroupLocalService.dynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.ClusterGroupModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end) {

		return _clusterGroupLocalService.dynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.ClusterGroupModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator<T> orderByComparator) {

		return _clusterGroupLocalService.dynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery) {

		return _clusterGroupLocalService.dynamicQueryCount(dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
		com.liferay.portal.kernel.dao.orm.Projection projection) {

		return _clusterGroupLocalService.dynamicQueryCount(
			dynamicQuery, projection);
	}

	@Override
	public com.liferay.portal.kernel.model.ClusterGroup fetchClusterGroup(
		long clusterGroupId) {

		return _clusterGroupLocalService.fetchClusterGroup(clusterGroupId);
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery
		getActionableDynamicQuery() {

		return _clusterGroupLocalService.getActionableDynamicQuery();
	}

	/**
	 * Returns the cluster group with the primary key.
	 *
	 * @param clusterGroupId the primary key of the cluster group
	 * @return the cluster group
	 * @throws PortalException if a cluster group with the primary key could not be found
	 */
	@Override
	public com.liferay.portal.kernel.model.ClusterGroup getClusterGroup(
			long clusterGroupId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _clusterGroupLocalService.getClusterGroup(clusterGroupId);
	}

	/**
	 * Returns a range of all the cluster groups.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.ClusterGroupModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of cluster groups
	 * @param end the upper bound of the range of cluster groups (not inclusive)
	 * @return the range of cluster groups
	 */
	@Override
	public java.util.List<com.liferay.portal.kernel.model.ClusterGroup>
		getClusterGroups(int start, int end) {

		return _clusterGroupLocalService.getClusterGroups(start, end);
	}

	/**
	 * Returns the number of cluster groups.
	 *
	 * @return the number of cluster groups
	 */
	@Override
	public int getClusterGroupsCount() {
		return _clusterGroupLocalService.getClusterGroupsCount();
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery
		getIndexableActionableDynamicQuery() {

		return _clusterGroupLocalService.getIndexableActionableDynamicQuery();
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public java.lang.String getOSGiServiceIdentifier() {
		return _clusterGroupLocalService.getOSGiServiceIdentifier();
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public com.liferay.portal.kernel.model.PersistedModel getPersistedModel(
			java.io.Serializable primaryKeyObj)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _clusterGroupLocalService.getPersistedModel(primaryKeyObj);
	}

	/**
	 * Updates the cluster group in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect ClusterGroupLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param clusterGroup the cluster group
	 * @return the cluster group that was updated
	 */
	@Override
	public com.liferay.portal.kernel.model.ClusterGroup updateClusterGroup(
		com.liferay.portal.kernel.model.ClusterGroup clusterGroup) {

		return _clusterGroupLocalService.updateClusterGroup(clusterGroup);
	}

	@Override
	public ClusterGroupLocalService getWrappedService() {
		return _clusterGroupLocalService;
	}

	@Override
	public void setWrappedService(
		ClusterGroupLocalService clusterGroupLocalService) {

		_clusterGroupLocalService = clusterGroupLocalService;
	}

	private ClusterGroupLocalService _clusterGroupLocalService;

}