/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.product.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CPFriendlyURLEntry service. Represents a row in the &quot;CPFriendlyURLEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.product.model.impl.CPFriendlyURLEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.product.model.impl.CPFriendlyURLEntryImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see CPFriendlyURLEntry
 * @deprecated As of Athanasius (7.3.x), replaced by {@link
 com.liferay.friendly.url.model.impl.FriendlyURLEntryImpl}
 * @generated
 */
@Deprecated
@ProviderType
public interface CPFriendlyURLEntryModel
	extends AttachedModel, BaseModel<CPFriendlyURLEntry>, GroupedModel,
			ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a cp friendly url entry model instance should use the {@link CPFriendlyURLEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this cp friendly url entry.
	 *
	 * @return the primary key of this cp friendly url entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this cp friendly url entry.
	 *
	 * @param primaryKey the primary key of this cp friendly url entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this cp friendly url entry.
	 *
	 * @return the uuid of this cp friendly url entry
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this cp friendly url entry.
	 *
	 * @param uuid the uuid of this cp friendly url entry
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the cp friendly url entry ID of this cp friendly url entry.
	 *
	 * @return the cp friendly url entry ID of this cp friendly url entry
	 */
	public long getCPFriendlyURLEntryId();

	/**
	 * Sets the cp friendly url entry ID of this cp friendly url entry.
	 *
	 * @param CPFriendlyURLEntryId the cp friendly url entry ID of this cp friendly url entry
	 */
	public void setCPFriendlyURLEntryId(long CPFriendlyURLEntryId);

	/**
	 * Returns the group ID of this cp friendly url entry.
	 *
	 * @return the group ID of this cp friendly url entry
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this cp friendly url entry.
	 *
	 * @param groupId the group ID of this cp friendly url entry
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this cp friendly url entry.
	 *
	 * @return the company ID of this cp friendly url entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this cp friendly url entry.
	 *
	 * @param companyId the company ID of this cp friendly url entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this cp friendly url entry.
	 *
	 * @return the user ID of this cp friendly url entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this cp friendly url entry.
	 *
	 * @param userId the user ID of this cp friendly url entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this cp friendly url entry.
	 *
	 * @return the user uuid of this cp friendly url entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this cp friendly url entry.
	 *
	 * @param userUuid the user uuid of this cp friendly url entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this cp friendly url entry.
	 *
	 * @return the user name of this cp friendly url entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this cp friendly url entry.
	 *
	 * @param userName the user name of this cp friendly url entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this cp friendly url entry.
	 *
	 * @return the create date of this cp friendly url entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this cp friendly url entry.
	 *
	 * @param createDate the create date of this cp friendly url entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this cp friendly url entry.
	 *
	 * @return the modified date of this cp friendly url entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this cp friendly url entry.
	 *
	 * @param modifiedDate the modified date of this cp friendly url entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the fully qualified class name of this cp friendly url entry.
	 *
	 * @return the fully qualified class name of this cp friendly url entry
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this cp friendly url entry.
	 *
	 * @return the class name ID of this cp friendly url entry
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this cp friendly url entry.
	 *
	 * @param classNameId the class name ID of this cp friendly url entry
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this cp friendly url entry.
	 *
	 * @return the class pk of this cp friendly url entry
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this cp friendly url entry.
	 *
	 * @param classPK the class pk of this cp friendly url entry
	 */
	@Override
	public void setClassPK(long classPK);

	/**
	 * Returns the language ID of this cp friendly url entry.
	 *
	 * @return the language ID of this cp friendly url entry
	 */
	@AutoEscape
	public String getLanguageId();

	/**
	 * Sets the language ID of this cp friendly url entry.
	 *
	 * @param languageId the language ID of this cp friendly url entry
	 */
	public void setLanguageId(String languageId);

	/**
	 * Returns the url title of this cp friendly url entry.
	 *
	 * @return the url title of this cp friendly url entry
	 */
	@AutoEscape
	public String getUrlTitle();

	/**
	 * Sets the url title of this cp friendly url entry.
	 *
	 * @param urlTitle the url title of this cp friendly url entry
	 */
	public void setUrlTitle(String urlTitle);

	/**
	 * Returns the main of this cp friendly url entry.
	 *
	 * @return the main of this cp friendly url entry
	 */
	public boolean getMain();

	/**
	 * Returns <code>true</code> if this cp friendly url entry is main.
	 *
	 * @return <code>true</code> if this cp friendly url entry is main; <code>false</code> otherwise
	 */
	public boolean isMain();

	/**
	 * Sets whether this cp friendly url entry is main.
	 *
	 * @param main the main of this cp friendly url entry
	 */
	public void setMain(boolean main);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(CPFriendlyURLEntry cpFriendlyURLEntry);

	@Override
	public int hashCode();

	@Override
	public CacheModel<CPFriendlyURLEntry> toCacheModel();

	@Override
	public CPFriendlyURLEntry toEscapedModel();

	@Override
	public CPFriendlyURLEntry toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}