/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.bom.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CommerceBOMEntry service. Represents a row in the &quot;CommerceBOMEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.bom.model.impl.CommerceBOMEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.bom.model.impl.CommerceBOMEntryImpl</code>.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMEntry
 * @generated
 */
@ProviderType
public interface CommerceBOMEntryModel
	extends AuditedModel, BaseModel<CommerceBOMEntry>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce bom entry model instance should use the {@link CommerceBOMEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce bom entry.
	 *
	 * @return the primary key of this commerce bom entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce bom entry.
	 *
	 * @param primaryKey the primary key of this commerce bom entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the commerce bom entry ID of this commerce bom entry.
	 *
	 * @return the commerce bom entry ID of this commerce bom entry
	 */
	public long getCommerceBOMEntryId();

	/**
	 * Sets the commerce bom entry ID of this commerce bom entry.
	 *
	 * @param commerceBOMEntryId the commerce bom entry ID of this commerce bom entry
	 */
	public void setCommerceBOMEntryId(long commerceBOMEntryId);

	/**
	 * Returns the company ID of this commerce bom entry.
	 *
	 * @return the company ID of this commerce bom entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce bom entry.
	 *
	 * @param companyId the company ID of this commerce bom entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce bom entry.
	 *
	 * @return the user ID of this commerce bom entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce bom entry.
	 *
	 * @param userId the user ID of this commerce bom entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce bom entry.
	 *
	 * @return the user uuid of this commerce bom entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce bom entry.
	 *
	 * @param userUuid the user uuid of this commerce bom entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce bom entry.
	 *
	 * @return the user name of this commerce bom entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce bom entry.
	 *
	 * @param userName the user name of this commerce bom entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce bom entry.
	 *
	 * @return the create date of this commerce bom entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce bom entry.
	 *
	 * @param createDate the create date of this commerce bom entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce bom entry.
	 *
	 * @return the modified date of this commerce bom entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce bom entry.
	 *
	 * @param modifiedDate the modified date of this commerce bom entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the number of this commerce bom entry.
	 *
	 * @return the number of this commerce bom entry
	 */
	public int getNumber();

	/**
	 * Sets the number of this commerce bom entry.
	 *
	 * @param number the number of this commerce bom entry
	 */
	public void setNumber(int number);

	/**
	 * Returns the cp instance uuid of this commerce bom entry.
	 *
	 * @return the cp instance uuid of this commerce bom entry
	 */
	@AutoEscape
	public String getCPInstanceUuid();

	/**
	 * Sets the cp instance uuid of this commerce bom entry.
	 *
	 * @param CPInstanceUuid the cp instance uuid of this commerce bom entry
	 */
	public void setCPInstanceUuid(String CPInstanceUuid);

	/**
	 * Returns the c product ID of this commerce bom entry.
	 *
	 * @return the c product ID of this commerce bom entry
	 */
	public long getCProductId();

	/**
	 * Sets the c product ID of this commerce bom entry.
	 *
	 * @param CProductId the c product ID of this commerce bom entry
	 */
	public void setCProductId(long CProductId);

	/**
	 * Returns the commerce bom definition ID of this commerce bom entry.
	 *
	 * @return the commerce bom definition ID of this commerce bom entry
	 */
	public long getCommerceBOMDefinitionId();

	/**
	 * Sets the commerce bom definition ID of this commerce bom entry.
	 *
	 * @param commerceBOMDefinitionId the commerce bom definition ID of this commerce bom entry
	 */
	public void setCommerceBOMDefinitionId(long commerceBOMDefinitionId);

	/**
	 * Returns the position x of this commerce bom entry.
	 *
	 * @return the position x of this commerce bom entry
	 */
	public double getPositionX();

	/**
	 * Sets the position x of this commerce bom entry.
	 *
	 * @param positionX the position x of this commerce bom entry
	 */
	public void setPositionX(double positionX);

	/**
	 * Returns the position y of this commerce bom entry.
	 *
	 * @return the position y of this commerce bom entry
	 */
	public double getPositionY();

	/**
	 * Sets the position y of this commerce bom entry.
	 *
	 * @param positionY the position y of this commerce bom entry
	 */
	public void setPositionY(double positionY);

	/**
	 * Returns the radius of this commerce bom entry.
	 *
	 * @return the radius of this commerce bom entry
	 */
	public double getRadius();

	/**
	 * Sets the radius of this commerce bom entry.
	 *
	 * @param radius the radius of this commerce bom entry
	 */
	public void setRadius(double radius);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(CommerceBOMEntry commerceBOMEntry);

	@Override
	public int hashCode();

	@Override
	public CacheModel<CommerceBOMEntry> toCacheModel();

	@Override
	public CommerceBOMEntry toEscapedModel();

	@Override
	public CommerceBOMEntry toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}