/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.asset.list.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedGroupedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the AssetListEntrySegmentsEntryRel service. Represents a row in the &quot;AssetListEntrySegmentsEntryRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.asset.list.model.impl.AssetListEntrySegmentsEntryRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.asset.list.model.impl.AssetListEntrySegmentsEntryRelImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AssetListEntrySegmentsEntryRel
 * @generated
 */
@ProviderType
public interface AssetListEntrySegmentsEntryRelModel
	extends BaseModel<AssetListEntrySegmentsEntryRel>, MVCCModel, ShardedModel,
			StagedGroupedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a asset list entry segments entry rel model instance should use the {@link AssetListEntrySegmentsEntryRel} interface instead.
	 */

	/**
	 * Returns the primary key of this asset list entry segments entry rel.
	 *
	 * @return the primary key of this asset list entry segments entry rel
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this asset list entry segments entry rel.
	 *
	 * @param primaryKey the primary key of this asset list entry segments entry rel
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this asset list entry segments entry rel.
	 *
	 * @return the mvcc version of this asset list entry segments entry rel
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this asset list entry segments entry rel.
	 *
	 * @param mvccVersion the mvcc version of this asset list entry segments entry rel
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this asset list entry segments entry rel.
	 *
	 * @return the uuid of this asset list entry segments entry rel
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this asset list entry segments entry rel.
	 *
	 * @param uuid the uuid of this asset list entry segments entry rel
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the asset list entry segments entry rel ID of this asset list entry segments entry rel.
	 *
	 * @return the asset list entry segments entry rel ID of this asset list entry segments entry rel
	 */
	public long getAssetListEntrySegmentsEntryRelId();

	/**
	 * Sets the asset list entry segments entry rel ID of this asset list entry segments entry rel.
	 *
	 * @param assetListEntrySegmentsEntryRelId the asset list entry segments entry rel ID of this asset list entry segments entry rel
	 */
	public void setAssetListEntrySegmentsEntryRelId(
		long assetListEntrySegmentsEntryRelId);

	/**
	 * Returns the group ID of this asset list entry segments entry rel.
	 *
	 * @return the group ID of this asset list entry segments entry rel
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this asset list entry segments entry rel.
	 *
	 * @param groupId the group ID of this asset list entry segments entry rel
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this asset list entry segments entry rel.
	 *
	 * @return the company ID of this asset list entry segments entry rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this asset list entry segments entry rel.
	 *
	 * @param companyId the company ID of this asset list entry segments entry rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this asset list entry segments entry rel.
	 *
	 * @return the user ID of this asset list entry segments entry rel
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this asset list entry segments entry rel.
	 *
	 * @param userId the user ID of this asset list entry segments entry rel
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this asset list entry segments entry rel.
	 *
	 * @return the user uuid of this asset list entry segments entry rel
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this asset list entry segments entry rel.
	 *
	 * @param userUuid the user uuid of this asset list entry segments entry rel
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this asset list entry segments entry rel.
	 *
	 * @return the user name of this asset list entry segments entry rel
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this asset list entry segments entry rel.
	 *
	 * @param userName the user name of this asset list entry segments entry rel
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this asset list entry segments entry rel.
	 *
	 * @return the create date of this asset list entry segments entry rel
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this asset list entry segments entry rel.
	 *
	 * @param createDate the create date of this asset list entry segments entry rel
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this asset list entry segments entry rel.
	 *
	 * @return the modified date of this asset list entry segments entry rel
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this asset list entry segments entry rel.
	 *
	 * @param modifiedDate the modified date of this asset list entry segments entry rel
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the asset list entry ID of this asset list entry segments entry rel.
	 *
	 * @return the asset list entry ID of this asset list entry segments entry rel
	 */
	public long getAssetListEntryId();

	/**
	 * Sets the asset list entry ID of this asset list entry segments entry rel.
	 *
	 * @param assetListEntryId the asset list entry ID of this asset list entry segments entry rel
	 */
	public void setAssetListEntryId(long assetListEntryId);

	/**
	 * Returns the segments entry ID of this asset list entry segments entry rel.
	 *
	 * @return the segments entry ID of this asset list entry segments entry rel
	 */
	public long getSegmentsEntryId();

	/**
	 * Sets the segments entry ID of this asset list entry segments entry rel.
	 *
	 * @param segmentsEntryId the segments entry ID of this asset list entry segments entry rel
	 */
	public void setSegmentsEntryId(long segmentsEntryId);

	/**
	 * Returns the type settings of this asset list entry segments entry rel.
	 *
	 * @return the type settings of this asset list entry segments entry rel
	 */
	@AutoEscape
	public String getTypeSettings();

	/**
	 * Sets the type settings of this asset list entry segments entry rel.
	 *
	 * @param typeSettings the type settings of this asset list entry segments entry rel
	 */
	public void setTypeSettings(String typeSettings);

	/**
	 * Returns the last publish date of this asset list entry segments entry rel.
	 *
	 * @return the last publish date of this asset list entry segments entry rel
	 */
	@Override
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this asset list entry segments entry rel.
	 *
	 * @param lastPublishDate the last publish date of this asset list entry segments entry rel
	 */
	@Override
	public void setLastPublishDate(Date lastPublishDate);

}