Liferay.Loader.define("frontend-taglib@4.1.5/cards_treeview/CardsTreeview.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './CardsTreeview.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _CardsTreeview = _interopRequireDefault(require("./CardsTreeview.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * CardsTreeview
   *
   * This is an extension of the default TreeView component that adds
   * the following features:
   *
   * - Node selection management, both single and multiple
   * - Custom tree node template using Lexicon Horizontal Cards
   * - Improved accessibility for keyboard navigation following common tree widget patterns
   * @review
   */
  var CardsTreeview = /*#__PURE__*/function (_Treeview) {
    _inherits(CardsTreeview, _Treeview);

    function CardsTreeview() {
      _classCallCheck(this, CardsTreeview);

      return _possibleConstructorReturn(this, _getPrototypeOf(CardsTreeview).apply(this, arguments));
    }

    _createClass(CardsTreeview, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        this.expandSelectedNodesParentNodes_(this.nodes);
        this.addSelectedNodes_(this.nodes);
      }
      /**
       * Adds nodes with selected attribute to selectedNodes list in case when
       * they are still not there.
       * @param nodes Nodes to check and add to selectedNodes list.
       * @protected
       * @review
       */

    }, {
      key: "addSelectedNodes_",
      value: function addSelectedNodes_(nodes) {
        var _this = this;

        nodes.forEach(function (node) {
          if (node.children) {
            _this.addSelectedNodes_(node.children);
          }

          if (node.selected) {
            _this.selectNode_(node);
          }
        });
      }
      /**
       * Deselects all selected tree nodes
       * @protected
       * @review
       */

    }, {
      key: "deselectAll_",
      value: function deselectAll_() {
        for (var i = this.selectedNodes.length - 1; i >= 0; i--) {
          this.selectedNodes[i].selected = false;
          this.selectedNodes.pop();
        }
      }
      /**
       * Selects specific nodes
       * @param node to deselect.
       * @protected
       * @review
       */

    }, {
      key: "deselectNode_",
      value: function deselectNode_(node) {
        node.selected = false;
        this.selectedNodes.splice(this.selectedNodes.indexOf(node), 1);
        this.selectedNodes = this.selectedNodes;
      }
      /**
       * Expands all parent nodes of expanded children.
       * @param nodes List of nodes to expand all parent nodes of expanded children.
       * @protected
       * @review
       */

    }, {
      key: "expandSelectedNodesParentNodes_",
      value: function expandSelectedNodesParentNodes_(nodes) {
        var _this2 = this;

        var expanded;
        var expandedParent;
        nodes.forEach(function (node) {
          expanded = node.expanded;

          if (node.selected) {
            expandedParent = true;
          }

          if (node.children) {
            expanded = _this2.expandSelectedNodesParentNodes_(node.children) || expanded;
          }

          node.expanded = expanded;
        }, this);
        return expandedParent;
      }
      /**
       * Focus the given tree node.
       * @param {!Object} nodeObj
       * @protected
       * @review
       */

    }, {
      key: "focus_",
      value: function focus_(nodeObj) {
        if (nodeObj) {
          this.element.querySelector('[data-treeitemid="' + nodeObj.id + '"] .card').focus();
        }
      }
      /**
       * Focus the next tree node of given tree node.
       * @param {!Element} node
       * @protected
       * @review
       */

    }, {
      key: "focusNextNode_",
      value: function focusNextNode_(node) {
        var path = node.getAttribute('data-treeview-path').split('-');
        var nodeObj = this.getNodeObj(path);
        var nextNodeObj;

        if (nodeObj.children && nodeObj.expanded) {
          path.push(0);
          nextNodeObj = this.getNodeObj(path);
        } else {
          while (!nextNodeObj && path.length > 0) {
            path[path.length - 1]++;
            nextNodeObj = this.getNodeObj(path);
            path.pop();
          }
        }

        this.focus_(nextNodeObj);
      }
      /**
       * Focus the previous tree node of given tree node.
       * @param {!Element} node
       * @protected
       * @review
       */

    }, {
      key: "focusPrevNode_",
      value: function focusPrevNode_(node) {
        var path = node.getAttribute('data-treeview-path').split('-');
        var prevNodeObj;

        if (path[path.length - 1] === '0') {
          path.pop();
          prevNodeObj = this.getNodeObj(path);
        } else {
          path[path.length - 1]--;
          prevNodeObj = this.getNodeObj(path);

          while (prevNodeObj.children && prevNodeObj.expanded) {
            prevNodeObj = prevNodeObj.children[prevNodeObj.children.length - 1];
          }
        }

        this.focus_(prevNodeObj);
      }
      /**
       * This is called when one of this tree view's nodes is clicked.
       * @param {!Event} event
       * @protected
       * @review
       */

    }, {
      key: "handleNodeClicked_",
      value: function handleNodeClicked_(event) {
        var path = event.delegateTarget.parentNode.parentNode.parentNode.getAttribute('data-treeview-path').split('-');
        var node = this.getNodeObj(path);

        if (node.disabled) {
          return;
        }

        if (this.multiSelection) {
          if (node.selected) {
            this.deselectNode_(node);
          } else {
            this.selectNode_(node);
          }
        } else if (!node.selected) {
          this.deselectAll_();
          this.selectNode_(node);
        }

        this.nodes = this.nodes;
      }
      /**
       * This is called when one of this tree view's nodes receives a keypress.
       * Depending on the pressed key, the tree will:
       * - ENTER or SPACE: Select the current node
       * - DOWN ARROW: Focus the next node
       * - UP ARROW: Focus the previous node
       * - LEFT ARROW: Collapse the current node
       * - RIGHT ARROW: Expand the current node
       * @param {!Event} event
       * @protected
       * @review
       */

    }, {
      key: "handleNodeKeyUp_",
      value: function handleNodeKeyUp_(event) {
        var node = event.delegateTarget.parentNode.parentNode.parentNode;

        if (event.keyCode === 37) {
          this.setNodeExpandedState_(node, {
            expanded: false
          });
        } else if (event.keyCode === 38) {
          this.focusPrevNode_(node);
        } else if (event.keyCode === 39) {
          this.setNodeExpandedState_(node, {
            expanded: true
          });
        } else if (event.keyCode === 40) {
          this.focusNextNode_(node);
        } else if (event.keyCode === 13 || event.keyCode === 32) {
          this.handleNodeClicked_(event);
        }
      }
      /**
       * This is called when one of this tree view's nodes toggler is clicked.
       * @param {!Event} event
       * @protected
       * @review
       */

    }, {
      key: "handleNodeTogglerClicked_",
      value: function handleNodeTogglerClicked_(event) {
        this.toggleExpandedState_(event.delegateTarget.parentNode.parentNode.parentNode);
      }
      /**
       * Selects specific node.
       * @param node to select.
       * @protected
       * @review
       */

    }, {
      key: "selectNode_",
      value: function selectNode_(node) {
        node.selected = true;
        this.selectedNodes.push(node);
        this.selectedNodes = this.selectedNodes;
      }
      /**
       * Sets the expanded state of a node
       * @param {!Element} node The tree node we want to change the expanded state to
       * @param {!Object} state A state object with the new value of the expanded state
       * @protected
       * @review
       */

    }, {
      key: "setNodeExpandedState_",
      value: function setNodeExpandedState_(node, state) {
        var path = node.getAttribute('data-treeview-path').split('-');
        var nodeObj = this.getNodeObj(path);
        nodeObj.expanded = state.expanded;
        this.nodes = this.nodes;
      }
    }]);

    return CardsTreeview;
  }(_frontendJsWeb.Treeview);
  /**
   * CardsTreeview state definition.
   * @type {!Object}
   * @review
   * @static
   */

  CardsTreeview.STATE = {
    /**
     * Enables multiple selection of tree elements
     * @review
     * @type {boolean}
     */
    multiSelection: _metalState.Config.bool().value(false),

    /**
     * List of selected nodes
     * @review
     * @type {Array.<Object>}
     */
    selectedNodes: _metalState.Config.array().value([]),

    /**
     * Type of view to render. Accepted values are 'tree' and 'flat'
     * @review
     * @type {String}
     */
    viewType: _metalState.Config.string().value('tree')
  };

  _metalSoy["default"].register(CardsTreeview, _CardsTreeview["default"]);

  var _default = CardsTreeview;
  exports["default"] = _default;
  //# sourceMappingURL=CardsTreeview.es.js.map
});
//# sourceMappingURL=CardsTreeview.es.js.map