/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
'use strict';

Liferay.Loader.define("commerce-frontend-taglib@9.0.1/user_roles_modal/UserRolesModal.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './UserRolesModal.soy', 'frontend-taglib-clay$clay-modal', './RoleInputItem.es', './RoleListItem.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.UserRolesModal = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  var _UserRolesModal = _interopRequireDefault(require("./UserRolesModal.soy"));

  require("frontend-taglib-clay$clay-modal");

  require("./RoleInputItem.es");

  require("./RoleListItem.es");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var UserRolesModal = /*#__PURE__*/function (_Component) {
    _inherits(UserRolesModal, _Component);

    function UserRolesModal() {
      _classCallCheck(this, UserRolesModal);

      return _possibleConstructorReturn(this, _getPrototypeOf(UserRolesModal).apply(this, arguments));
    }

    _createClass(UserRolesModal, [{
      key: "syncSelectedRoles",
      value: function syncSelectedRoles() {
        var contentWrapper = this.element.querySelector('.autocomplete-input__content');
        this.element.querySelector('.autocomplete-input__box').focus();

        if (contentWrapper.scrollTo) {
          contentWrapper.scrollTo(0, contentWrapper.offsetHeight);
        }
      }
    }, {
      key: "_handleCloseModal",
      value: function _handleCloseModal(e) {
        e.preventDefault();
        this._modalVisible = false;
      }
    }, {
      key: "syncQuery",
      value: function syncQuery() {
        return this._filterRoles();
      }
    }, {
      key: "_handleFormSubmit",
      value: function _handleFormSubmit(evt) {
        evt.preventDefault();
        var result = false;

        if (this.filteredRoles.length) {
          this._toggleItem(this.filteredRoles[0]);

          this.query = '';
          result = true;
        }

        return result;
      }
    }, {
      key: "_handleInputBox",
      value: function _handleInputBox(evt) {
        if (evt.keyCode === 8 && !this.query.length) {
          this.selectedRoles = this.selectedRoles.slice(0, -1);
        } else {
          this.query = evt.target.value;
        }

        return evt;
      }
    }, {
      key: "_toggleItem",
      value: function _toggleItem(item) {
        if (!item.id) {
          this.query = '';
        }

        var roleAlreadyAdded = this.selectedRoles.reduce(function (alreadyAdded, role) {
          return alreadyAdded || role.id === item.id;
        }, false);
        this.selectedRoles = roleAlreadyAdded ? this.selectedRoles.filter(function (role) {
          return role.id !== item.id;
        }) : [].concat(_toConsumableArray(this.selectedRoles), [item]);
        return this.selectedRoles;
      }
    }, {
      key: "_filterRoles",
      value: function _filterRoles() {
        var _this = this;

        this.filteredRoles = this.roles.filter(function (role) {
          return role.name.toLowerCase().indexOf(_this.query.toLowerCase()) > -1;
        });
        return this.filteredRoles;
      }
    }, {
      key: "_updateRoles",
      value: function _updateRoles() {
        this.emit('updateRoles', this.selectedRoles);
      }
    }, {
      key: "toggle",
      value: function toggle() {
        this._modalVisible = !this._modalVisible;
        return this._modalVisible;
      }
    }, {
      key: "open",
      value: function open() {
        this._modalVisible = true;
        return this._modalVisible;
      }
    }, {
      key: "close",
      value: function close() {
        this._modalVisible = false;
        return this._modalVisible;
      }
    }]);

    return UserRolesModal;
  }(_metalComponent["default"]);

  exports.UserRolesModal = UserRolesModal;

  _metalSoy["default"].register(UserRolesModal, _UserRolesModal["default"]);

  var ROLE_SCHEMA = _metalSoy.Config.shapeOf({
    id: _metalSoy.Config.oneOfType([_metalSoy.Config.number(), _metalSoy.Config.string()]).required(),
    name: _metalSoy.Config.string().required()
  });

  UserRolesModal.STATE = {
    _modalVisible: _metalSoy.Config.bool().internal().value(false),
    filteredRoles: _metalSoy.Config.array(ROLE_SCHEMA).value([]),
    query: _metalSoy.Config.string().value(''),
    roles: _metalSoy.Config.array(ROLE_SCHEMA).value([]),
    selectedRoles: _metalSoy.Config.array(ROLE_SCHEMA).value([]),
    spritemap: _metalSoy.Config.string()
  };
  var _default = UserRolesModal;
  exports["default"] = _default;
  //# sourceMappingURL=UserRolesModal.es.js.map
});
//# sourceMappingURL=UserRolesModal.es.js.map