Liferay.Loader.define("commerce-frontend-taglib@9.0.1/search_bar/SearchBar.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-icon', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './SearchBar.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.SearchBar = void 0;

  require("frontend-taglib-clay$clay-icon");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  var _SearchBar = _interopRequireDefault(require("./SearchBar.soy"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var SearchBar = /*#__PURE__*/function (_Component) {
    _inherits(SearchBar, _Component);

    function SearchBar() {
      _classCallCheck(this, SearchBar);

      return _possibleConstructorReturn(this, _getPrototypeOf(SearchBar).apply(this, arguments));
    }

    _createClass(SearchBar, [{
      key: "created",
      value: function created() {
        this._handleDocumentKeypress = this._handleDocumentKeypress.bind(this);
        this._handleClickOutside = this._handleClickOutside.bind(this);
        this.toggle = this.toggle.bind(this);
        document.addEventListener('keydown', this._handleDocumentKeypress);

        this._addOpenButtonListener();
      }
    }, {
      key: "detached",
      value: function detached() {
        document.removeEventListener('keydown', this._handleDocumentKeypress);
      }
    }, {
      key: "_addOpenButtonListener",
      value: function _addOpenButtonListener() {
        var _this = this;

        return Array.from(document.querySelectorAll('.js-toggle-search')).map(function (el) {
          return el.addEventListener('click', _this.toggle);
        });
      }
    }, {
      key: "_removeOpenButtonListener",
      value: function _removeOpenButtonListener() {
        var _this2 = this;

        return Array.from(document.querySelectorAll('.js-toggle-search')).map(function (el) {
          return el.removeEventListener('click', _this2.toggle);
        });
      }
    }, {
      key: "_handleClickOutside",
      value: function _handleClickOutside(e) {
        var suggestions = document.querySelector('.commerce-suggestions');

        if (!(this.element.contains(e.target) || suggestions && suggestions.contains(e.target))) {
          this.toggle();
        }
      }
    }, {
      key: "_handleDocumentKeypress",
      value: function _handleDocumentKeypress(evt) {
        if (this.active && evt.key === 'Escape') {
          this.close();
        }

        var noModalsActive = !Array.from(document.querySelectorAll('.modal.show')).length;

        if (!this.active && evt.key === '/' && evt.target.tagName !== 'INPUT' && noModalsActive) {
          evt.preventDefault();
          this.open();
        }
      }
    }, {
      key: "_handleResetQuery",
      value: function _handleResetQuery(_evt) {
        this._updateQuery('');
      }
    }, {
      key: "_handleKeyDown",
      value: function _handleKeyDown(evt) {
        if (evt.key === 'ArrowDown' || evt.key === 'ArrowUp') {
          evt.preventDefault();
        }
      }
    }, {
      key: "_handleKeyUp",
      value: function _handleKeyUp(evt) {
        this._updateQuery(evt.target.value);
      }
    }, {
      key: "_handleSubmit",
      value: function _handleSubmit(evt) {
        evt.preventDefault();
        window.Liferay.fire('search-term-submit', {
          term: this.query
        });
      }
    }, {
      key: "_updateQuery",
      value: function _updateQuery(query) {
        if (query !== this.query) {
          this.open();
          this.query = query;
          window.Liferay.fire('search-term-update', {
            term: query
          });
        }
      }
    }, {
      key: "syncActive",
      value: function syncActive() {
        var _this3 = this;

        if (this.active) {
          window.addEventListener('click', this._handleClickOutside);
          setTimeout(function () {
            _this3._removeOpenButtonListener();

            _this3.refs.searchInput.focus();
          }, 0);
        } else {
          window.removeEventListener('click', this._handleClickOutside);
          setTimeout(function () {
            _this3._addOpenButtonListener();

            _this3.refs.searchInput.blur();
          }, 0);
        }

        this.emit('toggled', this.active);
      }
    }, {
      key: "open",
      value: function open() {
        this.active = true;
      }
    }, {
      key: "close",
      value: function close() {
        this.active = false;
      }
    }, {
      key: "toggle",
      value: function toggle() {
        return this.active ? this.close() : this.open();
      }
    }]);

    return SearchBar;
  }(_metalComponent["default"]);

  exports.SearchBar = SearchBar;

  _metalSoy["default"].register(SearchBar, _SearchBar["default"]);

  SearchBar.STATE = {
    active: _metalSoy.Config.bool(),
    placeholder: _metalSoy.Config.value(''),
    query: _metalSoy.Config.string()
  };
  var _default = SearchBar;
  exports["default"] = _default;
  //# sourceMappingURL=SearchBar.es.js.map
});
//# sourceMappingURL=SearchBar.es.js.map