Liferay.Loader.define("flags-taglib@4.2.20/flags/js/components/FlagsModal.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../ThemeContext.es', '../constants.es', '../utils.es', './Captcha.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _modal = _interopRequireDefault(require("@frontend-taglib-clay$clayui/modal"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _ThemeContext = _interopRequireDefault(require("../ThemeContext.es"));

  var _constants = require("../constants.es");

  var _utils = require("../utils.es");

  var _Captcha = _interopRequireDefault(require("./Captcha.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var ModalContentForm = function ModalContentForm(_ref) {
    var captchaURI = _ref.captchaURI,
        error = _ref.error,
        handleClose = _ref.handleClose,
        handleInputChange = _ref.handleInputChange,
        handleSubmit = _ref.handleSubmit,
        isSending = _ref.isSending,
        pathTermsOfUse = _ref.pathTermsOfUse,
        reasons = _ref.reasons,
        selectedReason = _ref.selectedReason,
        signedIn = _ref.signedIn;

    var _useContext = (0, _react.useContext)(_ThemeContext["default"]),
        namespace = _useContext.namespace;

    return _react["default"].createElement("form", {
      onSubmit: handleSubmit
    }, _react["default"].createElement(_modal["default"].Body, null, error && _react["default"].createElement(_alert["default"], {
      displayType: "danger",
      title: Liferay.Language.get('error')
    }, error), _react["default"].createElement("p", null, (0, _utils.sub)(Liferay.Language.get('you-are-about-to-report-a-violation-of-our-x.-all-reports-are-strictly-confidential'), [_react["default"].createElement("a", {
      href: pathTermsOfUse,
      key: pathTermsOfUse
    }, Liferay.Language.get('terms-of-use'))], false)), _react["default"].createElement("div", {
      className: "form-group"
    }, _react["default"].createElement("label", {
      className: "control-label",
      htmlFor: "".concat(namespace, "selectedReason")
    }, Liferay.Language.get('reason-for-the-report')), _react["default"].createElement("select", {
      className: "form-control",
      id: "".concat(namespace, "selectedReason"),
      name: "selectedReason",
      onChange: handleInputChange,
      value: selectedReason
    }, Object.entries(reasons).map(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
          value = _ref3[0],
          text = _ref3[1];

      return _react["default"].createElement("option", {
        key: value,
        value: value
      }, text);
    }), _react["default"].createElement("option", {
      value: _constants.OTHER_REASON_VALUE
    }, Liferay.Language.get('other-reason')))), selectedReason === _constants.OTHER_REASON_VALUE && _react["default"].createElement("div", {
      className: "form-group"
    }, _react["default"].createElement("label", {
      className: "control-label",
      htmlFor: "".concat(namespace, "otherReason")
    }, Liferay.Language.get('other-reason')), _react["default"].createElement("input", {
      autoFocus: true,
      className: "form-control",
      id: "".concat(namespace, "otherReason"),
      name: "otherReason",
      onChange: handleInputChange
    })), !signedIn && _react["default"].createElement("div", {
      className: "form-group"
    }, _react["default"].createElement("label", {
      className: "control-label",
      htmlFor: "".concat(namespace, "otherRreporterEmailAddresseason")
    }, Liferay.Language.get('email-address')), _react["default"].createElement("input", {
      className: "form-control",
      id: "".concat(namespace, "otherRreporterEmailAddresseason"),
      name: "reporterEmailAddress",
      onChange: handleInputChange,
      type: "email"
    })), captchaURI && _react["default"].createElement(_Captcha["default"], {
      uri: captchaURI
    })), _react["default"].createElement(_modal["default"].Footer, {
      last: _react["default"].createElement(_button["default"].Group, {
        spaced: true
      }, _react["default"].createElement(_button["default"], {
        displayType: "secondary",
        onClick: handleClose
      }, Liferay.Language.get('cancel')), _react["default"].createElement(_button["default"], {
        disabled: isSending,
        displayType: "primary",
        type: "submit"
      }, Liferay.Language.get('report')))
    }));
  };

  var ModalBodySuccess = function ModalBodySuccess(_ref4) {
    var companyName = _ref4.companyName;
    return _react["default"].createElement(_modal["default"].Body, null, _react["default"].createElement("p", null, _react["default"].createElement("strong", null, Liferay.Language.get('thank-you-for-your-report'))), _react["default"].createElement("p", null, (0, _utils.sub)(Liferay.Language.get('although-we-cannot-disclose-our-final-decision,-we-do-review-every-report-and-appreciate-your-effort-to-make-sure-x-is-a-safe-environment-for-everyone'), [companyName])));
  };

  var ModalBodyError = function ModalBodyError() {
    return _react["default"].createElement(_modal["default"].Body, null, _react["default"].createElement("p", null, _react["default"].createElement("strong", null, Liferay.Language.get('an-error-occurred-while-sending-the-report.-please-try-again-in-a-few-minutes'))));
  };

  var ModalBodyLogin = function ModalBodyLogin() {
    return _react["default"].createElement(_modal["default"].Body, null, _react["default"].createElement("p", null, _react["default"].createElement("strong", null, Liferay.Language.get('please-sign-in-to-flag-this-as-inappropriate'))));
  };

  var ModalBody = function ModalBody(_ref5) {
    var companyName = _ref5.companyName,
        status = _ref5.status;

    switch (status) {
      case _constants.STATUS_LOGIN:
        return _react["default"].createElement(ModalBodyLogin, null);

      case _constants.STATUS_SUCCESS:
        return _react["default"].createElement(ModalBodySuccess, {
          companyName: companyName
        });

      case _constants.STATUS_ERROR:
      default:
        return _react["default"].createElement(ModalBodyError, null);
    }
  };

  var FlagsModal = function FlagsModal(_ref6) {
    var captchaURI = _ref6.captchaURI,
        companyName = _ref6.companyName,
        error = _ref6.error,
        handleClose = _ref6.handleClose,
        handleInputChange = _ref6.handleInputChange,
        handleSubmit = _ref6.handleSubmit,
        isSending = _ref6.isSending,
        observer = _ref6.observer,
        pathTermsOfUse = _ref6.pathTermsOfUse,
        reasons = _ref6.reasons,
        selectedReason = _ref6.selectedReason,
        signedIn = _ref6.signedIn,
        status = _ref6.status;
    return _react["default"].createElement(_modal["default"], {
      observer: observer,
      size: "md"
    }, _react["default"].createElement(_modal["default"].Header, null, Liferay.Language.get('report-inappropriate-content')), status === _constants.STATUS_REPORT ? _react["default"].createElement(ModalContentForm, {
      captchaURI: captchaURI,
      error: error,
      handleClose: handleClose,
      handleInputChange: handleInputChange,
      handleSubmit: handleSubmit,
      isSending: isSending,
      pathTermsOfUse: pathTermsOfUse,
      reasons: reasons,
      selectedReason: selectedReason,
      signedIn: signedIn
    }) : _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(ModalBody, {
      companyName: companyName,
      handleClose: handleClose,
      status: status
    }), _react["default"].createElement(_modal["default"].Footer, {
      last: _react["default"].createElement(_button["default"], {
        displayType: "secondary",
        onClick: handleClose
      }, Liferay.Language.get('close'))
    })));
  };

  var _default = FlagsModal;
  exports["default"] = _default;
  //# sourceMappingURL=FlagsModal.es.js.map
});
//# sourceMappingURL=FlagsModal.es.js.map