/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.workflow.kaleo.designer.web.internal.constants;

/**
 * Provides the Kaleo Designer request attribute keys.
 *
 * @author Eduardo Lundgren
 */
public class KaleoDesignerWebKeys {

	public static final String KALEO_DESIGNER_DISPLAY_CONTEXT =
		"KALEO_DESIGNER_DISPLAY_CONTEXT";

	/**
	 * {@value #KALEO_DRAFT_DEFINITION} is used to retrieve the Kaleo draft
	 * definition from the request attribute.
	 */
	public static final String KALEO_DRAFT_DEFINITION =
		"KALEO_DRAFT_DEFINITION";

	/**
	 * {@value #KALEO_DRAFT_DEFINITION_CONTENT} is used to retrieve the Kaleo
	 * draft definition's content from the request attribute.
	 */
	public static final String KALEO_DRAFT_DEFINITION_CONTENT =
		"KALEO_DRAFT_DEFINITION_CONTENT";

	/**
	 * {@value #KALEO_DRAFT_DEFINITION_ID} is used to retrieve the Kaleo draft
	 * definition's primary key from the request attribute.
	 */
	public static final String KALEO_DRAFT_DEFINITION_ID =
		"KALEO_DRAFT_DEFINITION_ID";

	public static final String PUBLISH_DEFINITION_ACTION =
		"PUBLISH_DEFINITION_ACTION";

}