/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutVersion;
import com.liferay.portal.kernel.model.LayoutVersionModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the LayoutVersion service. Represents a row in the &quot;LayoutVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>LayoutVersionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutVersionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutVersionImpl
 * @generated
 */
public class LayoutVersionModelImpl
	extends BaseModelImpl<LayoutVersion> implements LayoutVersionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout version model instance should use the <code>LayoutVersion</code> interface instead.
	 */
	public static final String TABLE_NAME = "LayoutVersion";

	public static final Object[][] TABLE_COLUMNS = {
		{"layoutVersionId", Types.BIGINT}, {"version", Types.INTEGER},
		{"uuid_", Types.VARCHAR}, {"plid", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"parentPlid", Types.BIGINT}, {"privateLayout", Types.BOOLEAN},
		{"layoutId", Types.BIGINT}, {"parentLayoutId", Types.BIGINT},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"name", Types.VARCHAR}, {"title", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"keywords", Types.VARCHAR},
		{"robots", Types.VARCHAR}, {"type_", Types.VARCHAR},
		{"typeSettings", Types.CLOB}, {"hidden_", Types.BOOLEAN},
		{"system_", Types.BOOLEAN}, {"friendlyURL", Types.VARCHAR},
		{"iconImageId", Types.BIGINT}, {"themeId", Types.VARCHAR},
		{"colorSchemeId", Types.VARCHAR}, {"css", Types.CLOB},
		{"priority", Types.INTEGER}, {"layoutPrototypeUuid", Types.VARCHAR},
		{"layoutPrototypeLinkEnabled", Types.BOOLEAN},
		{"sourcePrototypeLayoutUuid", Types.VARCHAR},
		{"publishDate", Types.TIMESTAMP}, {"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("layoutVersionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("version", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("plid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("parentPlid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("privateLayout", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("layoutId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentLayoutId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("keywords", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("robots", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("typeSettings", Types.CLOB);
		TABLE_COLUMNS_MAP.put("hidden_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("system_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("friendlyURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("iconImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("themeId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("colorSchemeId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("css", Types.CLOB);
		TABLE_COLUMNS_MAP.put("priority", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("layoutPrototypeUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("layoutPrototypeLinkEnabled", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("sourcePrototypeLayoutUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("publishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table LayoutVersion (layoutVersionId LONG not null primary key,version INTEGER,uuid_ VARCHAR(75) null,plid LONG,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,parentPlid LONG,privateLayout BOOLEAN,layoutId LONG,parentLayoutId LONG,classNameId LONG,classPK LONG,name STRING null,title STRING null,description STRING null,keywords STRING null,robots STRING null,type_ VARCHAR(75) null,typeSettings TEXT null,hidden_ BOOLEAN,system_ BOOLEAN,friendlyURL VARCHAR(255) null,iconImageId LONG,themeId VARCHAR(75) null,colorSchemeId VARCHAR(75) null,css TEXT null,priority INTEGER,layoutPrototypeUuid VARCHAR(75) null,layoutPrototypeLinkEnabled BOOLEAN,sourcePrototypeLayoutUuid VARCHAR(75) null,publishDate DATE null,lastPublishDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table LayoutVersion";

	public static final String ORDER_BY_JPQL =
		" ORDER BY layoutVersion.version DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY LayoutVersion.version DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.entity.cache.enabled.com.liferay.portal.kernel.model.LayoutVersion"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.finder.cache.enabled.com.liferay.portal.kernel.model.LayoutVersion"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.column.bitmask.enabled.com.liferay.portal.kernel.model.LayoutVersion"),
		true);

	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	public static final long FRIENDLYURL_COLUMN_BITMASK = 8L;

	public static final long GROUPID_COLUMN_BITMASK = 16L;

	public static final long HIDDEN_COLUMN_BITMASK = 32L;

	public static final long ICONIMAGEID_COLUMN_BITMASK = 64L;

	public static final long LAYOUTID_COLUMN_BITMASK = 128L;

	public static final long LAYOUTPROTOTYPEUUID_COLUMN_BITMASK = 256L;

	public static final long PARENTLAYOUTID_COLUMN_BITMASK = 512L;

	public static final long PARENTPLID_COLUMN_BITMASK = 1024L;

	public static final long PLID_COLUMN_BITMASK = 2048L;

	public static final long PRIORITY_COLUMN_BITMASK = 4096L;

	public static final long PRIVATELAYOUT_COLUMN_BITMASK = 8192L;

	public static final long SOURCEPROTOTYPELAYOUTUUID_COLUMN_BITMASK = 16384L;

	public static final long TYPE_COLUMN_BITMASK = 32768L;

	public static final long UUID_COLUMN_BITMASK = 65536L;

	public static final long VERSION_COLUMN_BITMASK = 131072L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.LayoutVersion"));

	public LayoutVersionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _layoutVersionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setLayoutVersionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _layoutVersionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return LayoutVersion.class;
	}

	@Override
	public String getModelClassName() {
		return LayoutVersion.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<LayoutVersion, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<LayoutVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutVersion, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((LayoutVersion)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<LayoutVersion, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<LayoutVersion, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(LayoutVersion)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<LayoutVersion, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<LayoutVersion, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, LayoutVersion>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			LayoutVersion.class.getClassLoader(), LayoutVersion.class,
			ModelWrapper.class);

		try {
			Constructor<LayoutVersion> constructor =
				(Constructor<LayoutVersion>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<LayoutVersion, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<LayoutVersion, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<LayoutVersion, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<LayoutVersion, Object>>();
		Map<String, BiConsumer<LayoutVersion, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<LayoutVersion, ?>>();

		attributeGetterFunctions.put(
			"layoutVersionId", LayoutVersion::getLayoutVersionId);
		attributeSetterBiConsumers.put(
			"layoutVersionId",
			(BiConsumer<LayoutVersion, Long>)LayoutVersion::setLayoutVersionId);
		attributeGetterFunctions.put("version", LayoutVersion::getVersion);
		attributeSetterBiConsumers.put(
			"version",
			(BiConsumer<LayoutVersion, Integer>)LayoutVersion::setVersion);
		attributeGetterFunctions.put("uuid", LayoutVersion::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<LayoutVersion, String>)LayoutVersion::setUuid);
		attributeGetterFunctions.put("plid", LayoutVersion::getPlid);
		attributeSetterBiConsumers.put(
			"plid", (BiConsumer<LayoutVersion, Long>)LayoutVersion::setPlid);
		attributeGetterFunctions.put("groupId", LayoutVersion::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<LayoutVersion, Long>)LayoutVersion::setGroupId);
		attributeGetterFunctions.put("companyId", LayoutVersion::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<LayoutVersion, Long>)LayoutVersion::setCompanyId);
		attributeGetterFunctions.put("userId", LayoutVersion::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<LayoutVersion, Long>)LayoutVersion::setUserId);
		attributeGetterFunctions.put("userName", LayoutVersion::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<LayoutVersion, String>)LayoutVersion::setUserName);
		attributeGetterFunctions.put(
			"createDate", LayoutVersion::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<LayoutVersion, Date>)LayoutVersion::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", LayoutVersion::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<LayoutVersion, Date>)LayoutVersion::setModifiedDate);
		attributeGetterFunctions.put(
			"parentPlid", LayoutVersion::getParentPlid);
		attributeSetterBiConsumers.put(
			"parentPlid",
			(BiConsumer<LayoutVersion, Long>)LayoutVersion::setParentPlid);
		attributeGetterFunctions.put(
			"privateLayout", LayoutVersion::getPrivateLayout);
		attributeSetterBiConsumers.put(
			"privateLayout",
			(BiConsumer<LayoutVersion, Boolean>)
				LayoutVersion::setPrivateLayout);
		attributeGetterFunctions.put("layoutId", LayoutVersion::getLayoutId);
		attributeSetterBiConsumers.put(
			"layoutId",
			(BiConsumer<LayoutVersion, Long>)LayoutVersion::setLayoutId);
		attributeGetterFunctions.put(
			"parentLayoutId", LayoutVersion::getParentLayoutId);
		attributeSetterBiConsumers.put(
			"parentLayoutId",
			(BiConsumer<LayoutVersion, Long>)LayoutVersion::setParentLayoutId);
		attributeGetterFunctions.put(
			"classNameId", LayoutVersion::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<LayoutVersion, Long>)LayoutVersion::setClassNameId);
		attributeGetterFunctions.put("classPK", LayoutVersion::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK",
			(BiConsumer<LayoutVersion, Long>)LayoutVersion::setClassPK);
		attributeGetterFunctions.put("name", LayoutVersion::getName);
		attributeSetterBiConsumers.put(
			"name", (BiConsumer<LayoutVersion, String>)LayoutVersion::setName);
		attributeGetterFunctions.put("title", LayoutVersion::getTitle);
		attributeSetterBiConsumers.put(
			"title",
			(BiConsumer<LayoutVersion, String>)LayoutVersion::setTitle);
		attributeGetterFunctions.put(
			"description", LayoutVersion::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<LayoutVersion, String>)LayoutVersion::setDescription);
		attributeGetterFunctions.put("keywords", LayoutVersion::getKeywords);
		attributeSetterBiConsumers.put(
			"keywords",
			(BiConsumer<LayoutVersion, String>)LayoutVersion::setKeywords);
		attributeGetterFunctions.put("robots", LayoutVersion::getRobots);
		attributeSetterBiConsumers.put(
			"robots",
			(BiConsumer<LayoutVersion, String>)LayoutVersion::setRobots);
		attributeGetterFunctions.put("type", LayoutVersion::getType);
		attributeSetterBiConsumers.put(
			"type", (BiConsumer<LayoutVersion, String>)LayoutVersion::setType);
		attributeGetterFunctions.put(
			"typeSettings", LayoutVersion::getTypeSettings);
		attributeSetterBiConsumers.put(
			"typeSettings",
			(BiConsumer<LayoutVersion, String>)LayoutVersion::setTypeSettings);
		attributeGetterFunctions.put("hidden", LayoutVersion::getHidden);
		attributeSetterBiConsumers.put(
			"hidden",
			(BiConsumer<LayoutVersion, Boolean>)LayoutVersion::setHidden);
		attributeGetterFunctions.put("system", LayoutVersion::getSystem);
		attributeSetterBiConsumers.put(
			"system",
			(BiConsumer<LayoutVersion, Boolean>)LayoutVersion::setSystem);
		attributeGetterFunctions.put(
			"friendlyURL", LayoutVersion::getFriendlyURL);
		attributeSetterBiConsumers.put(
			"friendlyURL",
			(BiConsumer<LayoutVersion, String>)LayoutVersion::setFriendlyURL);
		attributeGetterFunctions.put(
			"iconImageId", LayoutVersion::getIconImageId);
		attributeSetterBiConsumers.put(
			"iconImageId",
			(BiConsumer<LayoutVersion, Long>)LayoutVersion::setIconImageId);
		attributeGetterFunctions.put("themeId", LayoutVersion::getThemeId);
		attributeSetterBiConsumers.put(
			"themeId",
			(BiConsumer<LayoutVersion, String>)LayoutVersion::setThemeId);
		attributeGetterFunctions.put(
			"colorSchemeId", LayoutVersion::getColorSchemeId);
		attributeSetterBiConsumers.put(
			"colorSchemeId",
			(BiConsumer<LayoutVersion, String>)LayoutVersion::setColorSchemeId);
		attributeGetterFunctions.put("css", LayoutVersion::getCss);
		attributeSetterBiConsumers.put(
			"css", (BiConsumer<LayoutVersion, String>)LayoutVersion::setCss);
		attributeGetterFunctions.put("priority", LayoutVersion::getPriority);
		attributeSetterBiConsumers.put(
			"priority",
			(BiConsumer<LayoutVersion, Integer>)LayoutVersion::setPriority);
		attributeGetterFunctions.put(
			"layoutPrototypeUuid", LayoutVersion::getLayoutPrototypeUuid);
		attributeSetterBiConsumers.put(
			"layoutPrototypeUuid",
			(BiConsumer<LayoutVersion, String>)
				LayoutVersion::setLayoutPrototypeUuid);
		attributeGetterFunctions.put(
			"layoutPrototypeLinkEnabled",
			LayoutVersion::getLayoutPrototypeLinkEnabled);
		attributeSetterBiConsumers.put(
			"layoutPrototypeLinkEnabled",
			(BiConsumer<LayoutVersion, Boolean>)
				LayoutVersion::setLayoutPrototypeLinkEnabled);
		attributeGetterFunctions.put(
			"sourcePrototypeLayoutUuid",
			LayoutVersion::getSourcePrototypeLayoutUuid);
		attributeSetterBiConsumers.put(
			"sourcePrototypeLayoutUuid",
			(BiConsumer<LayoutVersion, String>)
				LayoutVersion::setSourcePrototypeLayoutUuid);
		attributeGetterFunctions.put(
			"publishDate", LayoutVersion::getPublishDate);
		attributeSetterBiConsumers.put(
			"publishDate",
			(BiConsumer<LayoutVersion, Date>)LayoutVersion::setPublishDate);
		attributeGetterFunctions.put(
			"lastPublishDate", LayoutVersion::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<LayoutVersion, Date>)LayoutVersion::setLastPublishDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getVersionedModelId() {
		return getPlid();
	}

	@Override
	public void populateVersionedModel(Layout layout) {
		layout.setUuid(getUuid());
		layout.setGroupId(getGroupId());
		layout.setCompanyId(getCompanyId());
		layout.setUserId(getUserId());
		layout.setUserName(getUserName());
		layout.setCreateDate(getCreateDate());
		layout.setModifiedDate(getModifiedDate());
		layout.setParentPlid(getParentPlid());
		layout.setPrivateLayout(getPrivateLayout());
		layout.setLayoutId(getLayoutId());
		layout.setParentLayoutId(getParentLayoutId());
		layout.setClassNameId(getClassNameId());
		layout.setClassPK(getClassPK());
		layout.setName(getName());
		layout.setTitle(getTitle());
		layout.setDescription(getDescription());
		layout.setKeywords(getKeywords());
		layout.setRobots(getRobots());
		layout.setType(getType());
		layout.setTypeSettings(getTypeSettings());
		layout.setHidden(getHidden());
		layout.setSystem(getSystem());
		layout.setFriendlyURL(getFriendlyURL());
		layout.setIconImageId(getIconImageId());
		layout.setThemeId(getThemeId());
		layout.setColorSchemeId(getColorSchemeId());
		layout.setCss(getCss());
		layout.setPriority(getPriority());
		layout.setLayoutPrototypeUuid(getLayoutPrototypeUuid());
		layout.setLayoutPrototypeLinkEnabled(getLayoutPrototypeLinkEnabled());
		layout.setSourcePrototypeLayoutUuid(getSourcePrototypeLayoutUuid());
		layout.setPublishDate(getPublishDate());
		layout.setLastPublishDate(getLastPublishDate());
	}

	@Override
	public void setVersionedModelId(long plid) {
		setPlid(plid);
	}

	@Override
	public Layout toVersionedModel() {
		Layout layout = new LayoutImpl();

		layout.setPrimaryKey(getVersionedModelId());
		layout.setHeadId(-getVersionedModelId());

		populateVersionedModel(layout);

		return layout;
	}

	@Override
	public long getLayoutVersionId() {
		return _layoutVersionId;
	}

	@Override
	public void setLayoutVersionId(long layoutVersionId) {
		_layoutVersionId = layoutVersionId;
	}

	@Override
	public int getVersion() {
		return _version;
	}

	@Override
	public void setVersion(int version) {
		_columnBitmask |= VERSION_COLUMN_BITMASK;

		if (!_setOriginalVersion) {
			_setOriginalVersion = true;

			_originalVersion = _version;
		}

		_version = version;
	}

	public int getOriginalVersion() {
		return _originalVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@Override
	public long getPlid() {
		return _plid;
	}

	@Override
	public void setPlid(long plid) {
		_columnBitmask |= PLID_COLUMN_BITMASK;

		if (!_setOriginalPlid) {
			_setOriginalPlid = true;

			_originalPlid = _plid;
		}

		_plid = plid;
	}

	public long getOriginalPlid() {
		return _originalPlid;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getParentPlid() {
		return _parentPlid;
	}

	@Override
	public void setParentPlid(long parentPlid) {
		_columnBitmask |= PARENTPLID_COLUMN_BITMASK;

		if (!_setOriginalParentPlid) {
			_setOriginalParentPlid = true;

			_originalParentPlid = _parentPlid;
		}

		_parentPlid = parentPlid;
	}

	public long getOriginalParentPlid() {
		return _originalParentPlid;
	}

	@Override
	public boolean getPrivateLayout() {
		return _privateLayout;
	}

	@Override
	public boolean isPrivateLayout() {
		return _privateLayout;
	}

	@Override
	public void setPrivateLayout(boolean privateLayout) {
		_columnBitmask |= PRIVATELAYOUT_COLUMN_BITMASK;

		if (!_setOriginalPrivateLayout) {
			_setOriginalPrivateLayout = true;

			_originalPrivateLayout = _privateLayout;
		}

		_privateLayout = privateLayout;
	}

	public boolean getOriginalPrivateLayout() {
		return _originalPrivateLayout;
	}

	@Override
	public long getLayoutId() {
		return _layoutId;
	}

	@Override
	public void setLayoutId(long layoutId) {
		_columnBitmask |= LAYOUTID_COLUMN_BITMASK;

		if (!_setOriginalLayoutId) {
			_setOriginalLayoutId = true;

			_originalLayoutId = _layoutId;
		}

		_layoutId = layoutId;
	}

	public long getOriginalLayoutId() {
		return _originalLayoutId;
	}

	@Override
	public long getParentLayoutId() {
		return _parentLayoutId;
	}

	@Override
	public void setParentLayoutId(long parentLayoutId) {
		_columnBitmask |= PARENTLAYOUTID_COLUMN_BITMASK;

		if (!_setOriginalParentLayoutId) {
			_setOriginalParentLayoutId = true;

			_originalParentLayoutId = _parentLayoutId;
		}

		_parentLayoutId = parentLayoutId;
	}

	public long getOriginalParentLayoutId() {
		return _originalParentLayoutId;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		_columnBitmask |= CLASSNAMEID_COLUMN_BITMASK;

		if (!_setOriginalClassNameId) {
			_setOriginalClassNameId = true;

			_originalClassNameId = _classNameId;
		}

		_classNameId = classNameId;
	}

	public long getOriginalClassNameId() {
		return _originalClassNameId;
	}

	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		_columnBitmask |= CLASSPK_COLUMN_BITMASK;

		if (!_setOriginalClassPK) {
			_setOriginalClassPK = true;

			_originalClassPK = _classPK;
		}

		_classPK = classPK;
	}

	public long getOriginalClassPK() {
		return _originalClassPK;
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public String getTitle(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId);
	}

	@Override
	public String getTitle(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId, useDefault);
	}

	@Override
	public String getTitle(String languageId) {
		return LocalizationUtil.getLocalization(getTitle(), languageId);
	}

	@Override
	public String getTitle(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getTitle(), languageId, useDefault);
	}

	@Override
	public String getTitleCurrentLanguageId() {
		return _titleCurrentLanguageId;
	}

	@JSON
	@Override
	public String getTitleCurrentValue() {
		Locale locale = getLocale(_titleCurrentLanguageId);

		return getTitle(locale);
	}

	@Override
	public Map<Locale, String> getTitleMap() {
		return LocalizationUtil.getLocalizationMap(getTitle());
	}

	@Override
	public void setTitle(String title) {
		_title = title;
	}

	@Override
	public void setTitle(String title, Locale locale) {
		setTitle(title, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setTitle(String title, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(title)) {
			setTitle(
				LocalizationUtil.updateLocalization(
					getTitle(), "Title", title, languageId, defaultLanguageId));
		}
		else {
			setTitle(
				LocalizationUtil.removeLocalization(
					getTitle(), "Title", languageId));
		}
	}

	@Override
	public void setTitleCurrentLanguageId(String languageId) {
		_titleCurrentLanguageId = languageId;
	}

	@Override
	public void setTitleMap(Map<Locale, String> titleMap) {
		setTitleMap(titleMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setTitleMap(
		Map<Locale, String> titleMap, Locale defaultLocale) {

		if (titleMap == null) {
			return;
		}

		setTitle(
			LocalizationUtil.updateLocalization(
				titleMap, getTitle(), "Title",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public String getDescription(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId);
	}

	@Override
	public String getDescription(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId, useDefault);
	}

	@Override
	public String getDescription(String languageId) {
		return LocalizationUtil.getLocalization(getDescription(), languageId);
	}

	@Override
	public String getDescription(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getDescription(), languageId, useDefault);
	}

	@Override
	public String getDescriptionCurrentLanguageId() {
		return _descriptionCurrentLanguageId;
	}

	@JSON
	@Override
	public String getDescriptionCurrentValue() {
		Locale locale = getLocale(_descriptionCurrentLanguageId);

		return getDescription(locale);
	}

	@Override
	public Map<Locale, String> getDescriptionMap() {
		return LocalizationUtil.getLocalizationMap(getDescription());
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@Override
	public void setDescription(String description, Locale locale) {
		setDescription(description, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setDescription(
		String description, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(description)) {
			setDescription(
				LocalizationUtil.updateLocalization(
					getDescription(), "Description", description, languageId,
					defaultLanguageId));
		}
		else {
			setDescription(
				LocalizationUtil.removeLocalization(
					getDescription(), "Description", languageId));
		}
	}

	@Override
	public void setDescriptionCurrentLanguageId(String languageId) {
		_descriptionCurrentLanguageId = languageId;
	}

	@Override
	public void setDescriptionMap(Map<Locale, String> descriptionMap) {
		setDescriptionMap(descriptionMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setDescriptionMap(
		Map<Locale, String> descriptionMap, Locale defaultLocale) {

		if (descriptionMap == null) {
			return;
		}

		setDescription(
			LocalizationUtil.updateLocalization(
				descriptionMap, getDescription(), "Description",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public String getKeywords() {
		if (_keywords == null) {
			return "";
		}
		else {
			return _keywords;
		}
	}

	@Override
	public String getKeywords(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getKeywords(languageId);
	}

	@Override
	public String getKeywords(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getKeywords(languageId, useDefault);
	}

	@Override
	public String getKeywords(String languageId) {
		return LocalizationUtil.getLocalization(getKeywords(), languageId);
	}

	@Override
	public String getKeywords(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getKeywords(), languageId, useDefault);
	}

	@Override
	public String getKeywordsCurrentLanguageId() {
		return _keywordsCurrentLanguageId;
	}

	@JSON
	@Override
	public String getKeywordsCurrentValue() {
		Locale locale = getLocale(_keywordsCurrentLanguageId);

		return getKeywords(locale);
	}

	@Override
	public Map<Locale, String> getKeywordsMap() {
		return LocalizationUtil.getLocalizationMap(getKeywords());
	}

	@Override
	public void setKeywords(String keywords) {
		_keywords = keywords;
	}

	@Override
	public void setKeywords(String keywords, Locale locale) {
		setKeywords(keywords, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setKeywords(
		String keywords, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(keywords)) {
			setKeywords(
				LocalizationUtil.updateLocalization(
					getKeywords(), "Keywords", keywords, languageId,
					defaultLanguageId));
		}
		else {
			setKeywords(
				LocalizationUtil.removeLocalization(
					getKeywords(), "Keywords", languageId));
		}
	}

	@Override
	public void setKeywordsCurrentLanguageId(String languageId) {
		_keywordsCurrentLanguageId = languageId;
	}

	@Override
	public void setKeywordsMap(Map<Locale, String> keywordsMap) {
		setKeywordsMap(keywordsMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setKeywordsMap(
		Map<Locale, String> keywordsMap, Locale defaultLocale) {

		if (keywordsMap == null) {
			return;
		}

		setKeywords(
			LocalizationUtil.updateLocalization(
				keywordsMap, getKeywords(), "Keywords",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public String getRobots() {
		if (_robots == null) {
			return "";
		}
		else {
			return _robots;
		}
	}

	@Override
	public String getRobots(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getRobots(languageId);
	}

	@Override
	public String getRobots(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getRobots(languageId, useDefault);
	}

	@Override
	public String getRobots(String languageId) {
		return LocalizationUtil.getLocalization(getRobots(), languageId);
	}

	@Override
	public String getRobots(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getRobots(), languageId, useDefault);
	}

	@Override
	public String getRobotsCurrentLanguageId() {
		return _robotsCurrentLanguageId;
	}

	@JSON
	@Override
	public String getRobotsCurrentValue() {
		Locale locale = getLocale(_robotsCurrentLanguageId);

		return getRobots(locale);
	}

	@Override
	public Map<Locale, String> getRobotsMap() {
		return LocalizationUtil.getLocalizationMap(getRobots());
	}

	@Override
	public void setRobots(String robots) {
		_robots = robots;
	}

	@Override
	public void setRobots(String robots, Locale locale) {
		setRobots(robots, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setRobots(String robots, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(robots)) {
			setRobots(
				LocalizationUtil.updateLocalization(
					getRobots(), "Robots", robots, languageId,
					defaultLanguageId));
		}
		else {
			setRobots(
				LocalizationUtil.removeLocalization(
					getRobots(), "Robots", languageId));
		}
	}

	@Override
	public void setRobotsCurrentLanguageId(String languageId) {
		_robotsCurrentLanguageId = languageId;
	}

	@Override
	public void setRobotsMap(Map<Locale, String> robotsMap) {
		setRobotsMap(robotsMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setRobotsMap(
		Map<Locale, String> robotsMap, Locale defaultLocale) {

		if (robotsMap == null) {
			return;
		}

		setRobots(
			LocalizationUtil.updateLocalization(
				robotsMap, getRobots(), "Robots",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		_columnBitmask |= TYPE_COLUMN_BITMASK;

		if (_originalType == null) {
			_originalType = _type;
		}

		_type = type;
	}

	public String getOriginalType() {
		return GetterUtil.getString(_originalType);
	}

	@Override
	public String getTypeSettings() {
		if (_typeSettings == null) {
			return "";
		}
		else {
			return _typeSettings;
		}
	}

	@Override
	public void setTypeSettings(String typeSettings) {
		_typeSettings = typeSettings;
	}

	@Override
	public boolean getHidden() {
		return _hidden;
	}

	@Override
	public boolean isHidden() {
		return _hidden;
	}

	@Override
	public void setHidden(boolean hidden) {
		_columnBitmask |= HIDDEN_COLUMN_BITMASK;

		if (!_setOriginalHidden) {
			_setOriginalHidden = true;

			_originalHidden = _hidden;
		}

		_hidden = hidden;
	}

	public boolean getOriginalHidden() {
		return _originalHidden;
	}

	@Override
	public boolean getSystem() {
		return _system;
	}

	@Override
	public boolean isSystem() {
		return _system;
	}

	@Override
	public void setSystem(boolean system) {
		_system = system;
	}

	@Override
	public String getFriendlyURL() {
		if (_friendlyURL == null) {
			return "";
		}
		else {
			return _friendlyURL;
		}
	}

	@Override
	public void setFriendlyURL(String friendlyURL) {
		_columnBitmask |= FRIENDLYURL_COLUMN_BITMASK;

		if (_originalFriendlyURL == null) {
			_originalFriendlyURL = _friendlyURL;
		}

		_friendlyURL = friendlyURL;
	}

	public String getOriginalFriendlyURL() {
		return GetterUtil.getString(_originalFriendlyURL);
	}

	@Override
	public long getIconImageId() {
		return _iconImageId;
	}

	@Override
	public void setIconImageId(long iconImageId) {
		_columnBitmask |= ICONIMAGEID_COLUMN_BITMASK;

		if (!_setOriginalIconImageId) {
			_setOriginalIconImageId = true;

			_originalIconImageId = _iconImageId;
		}

		_iconImageId = iconImageId;
	}

	public long getOriginalIconImageId() {
		return _originalIconImageId;
	}

	@Override
	public String getThemeId() {
		if (_themeId == null) {
			return "";
		}
		else {
			return _themeId;
		}
	}

	@Override
	public void setThemeId(String themeId) {
		_themeId = themeId;
	}

	@Override
	public String getColorSchemeId() {
		if (_colorSchemeId == null) {
			return "";
		}
		else {
			return _colorSchemeId;
		}
	}

	@Override
	public void setColorSchemeId(String colorSchemeId) {
		_colorSchemeId = colorSchemeId;
	}

	@Override
	public String getCss() {
		if (_css == null) {
			return "";
		}
		else {
			return _css;
		}
	}

	@Override
	public void setCss(String css) {
		_css = css;
	}

	@Override
	public int getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(int priority) {
		_columnBitmask |= PRIORITY_COLUMN_BITMASK;

		if (!_setOriginalPriority) {
			_setOriginalPriority = true;

			_originalPriority = _priority;
		}

		_priority = priority;
	}

	public int getOriginalPriority() {
		return _originalPriority;
	}

	@Override
	public String getLayoutPrototypeUuid() {
		if (_layoutPrototypeUuid == null) {
			return "";
		}
		else {
			return _layoutPrototypeUuid;
		}
	}

	@Override
	public void setLayoutPrototypeUuid(String layoutPrototypeUuid) {
		_columnBitmask |= LAYOUTPROTOTYPEUUID_COLUMN_BITMASK;

		if (_originalLayoutPrototypeUuid == null) {
			_originalLayoutPrototypeUuid = _layoutPrototypeUuid;
		}

		_layoutPrototypeUuid = layoutPrototypeUuid;
	}

	public String getOriginalLayoutPrototypeUuid() {
		return GetterUtil.getString(_originalLayoutPrototypeUuid);
	}

	@Override
	public boolean getLayoutPrototypeLinkEnabled() {
		return _layoutPrototypeLinkEnabled;
	}

	@Override
	public boolean isLayoutPrototypeLinkEnabled() {
		return _layoutPrototypeLinkEnabled;
	}

	@Override
	public void setLayoutPrototypeLinkEnabled(
		boolean layoutPrototypeLinkEnabled) {

		_layoutPrototypeLinkEnabled = layoutPrototypeLinkEnabled;
	}

	@Override
	public String getSourcePrototypeLayoutUuid() {
		if (_sourcePrototypeLayoutUuid == null) {
			return "";
		}
		else {
			return _sourcePrototypeLayoutUuid;
		}
	}

	@Override
	public void setSourcePrototypeLayoutUuid(String sourcePrototypeLayoutUuid) {
		_columnBitmask |= SOURCEPROTOTYPELAYOUTUUID_COLUMN_BITMASK;

		if (_originalSourcePrototypeLayoutUuid == null) {
			_originalSourcePrototypeLayoutUuid = _sourcePrototypeLayoutUuid;
		}

		_sourcePrototypeLayoutUuid = sourcePrototypeLayoutUuid;
	}

	public String getOriginalSourcePrototypeLayoutUuid() {
		return GetterUtil.getString(_originalSourcePrototypeLayoutUuid);
	}

	@Override
	public Date getPublishDate() {
		return _publishDate;
	}

	@Override
	public void setPublishDate(Date publishDate) {
		_publishDate = publishDate;
	}

	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		_lastPublishDate = lastPublishDate;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), LayoutVersion.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> titleMap = getTitleMap();

		for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> descriptionMap = getDescriptionMap();

		for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> keywordsMap = getKeywordsMap();

		for (Map.Entry<Locale, String> entry : keywordsMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> robotsMap = getRobotsMap();

		for (Map.Entry<Locale, String> entry : robotsMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			LayoutVersion.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}

		String title = getTitle(defaultLocale);

		if (Validator.isNull(title)) {
			setTitle(getTitle(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setTitle(getTitle(defaultLocale), defaultLocale, defaultLocale);
		}

		String description = getDescription(defaultLocale);

		if (Validator.isNull(description)) {
			setDescription(
				getDescription(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setDescription(
				getDescription(defaultLocale), defaultLocale, defaultLocale);
		}

		String keywords = getKeywords(defaultLocale);

		if (Validator.isNull(keywords)) {
			setKeywords(getKeywords(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setKeywords(
				getKeywords(defaultLocale), defaultLocale, defaultLocale);
		}

		String robots = getRobots(defaultLocale);

		if (Validator.isNull(robots)) {
			setRobots(getRobots(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setRobots(getRobots(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public LayoutVersion toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, LayoutVersion>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		LayoutVersionImpl layoutVersionImpl = new LayoutVersionImpl();

		layoutVersionImpl.setLayoutVersionId(getLayoutVersionId());
		layoutVersionImpl.setVersion(getVersion());
		layoutVersionImpl.setUuid(getUuid());
		layoutVersionImpl.setPlid(getPlid());
		layoutVersionImpl.setGroupId(getGroupId());
		layoutVersionImpl.setCompanyId(getCompanyId());
		layoutVersionImpl.setUserId(getUserId());
		layoutVersionImpl.setUserName(getUserName());
		layoutVersionImpl.setCreateDate(getCreateDate());
		layoutVersionImpl.setModifiedDate(getModifiedDate());
		layoutVersionImpl.setParentPlid(getParentPlid());
		layoutVersionImpl.setPrivateLayout(isPrivateLayout());
		layoutVersionImpl.setLayoutId(getLayoutId());
		layoutVersionImpl.setParentLayoutId(getParentLayoutId());
		layoutVersionImpl.setClassNameId(getClassNameId());
		layoutVersionImpl.setClassPK(getClassPK());
		layoutVersionImpl.setName(getName());
		layoutVersionImpl.setTitle(getTitle());
		layoutVersionImpl.setDescription(getDescription());
		layoutVersionImpl.setKeywords(getKeywords());
		layoutVersionImpl.setRobots(getRobots());
		layoutVersionImpl.setType(getType());
		layoutVersionImpl.setTypeSettings(getTypeSettings());
		layoutVersionImpl.setHidden(isHidden());
		layoutVersionImpl.setSystem(isSystem());
		layoutVersionImpl.setFriendlyURL(getFriendlyURL());
		layoutVersionImpl.setIconImageId(getIconImageId());
		layoutVersionImpl.setThemeId(getThemeId());
		layoutVersionImpl.setColorSchemeId(getColorSchemeId());
		layoutVersionImpl.setCss(getCss());
		layoutVersionImpl.setPriority(getPriority());
		layoutVersionImpl.setLayoutPrototypeUuid(getLayoutPrototypeUuid());
		layoutVersionImpl.setLayoutPrototypeLinkEnabled(
			isLayoutPrototypeLinkEnabled());
		layoutVersionImpl.setSourcePrototypeLayoutUuid(
			getSourcePrototypeLayoutUuid());
		layoutVersionImpl.setPublishDate(getPublishDate());
		layoutVersionImpl.setLastPublishDate(getLastPublishDate());

		layoutVersionImpl.resetOriginalValues();

		return layoutVersionImpl;
	}

	@Override
	public int compareTo(LayoutVersion layoutVersion) {
		int value = 0;

		if (getVersion() < layoutVersion.getVersion()) {
			value = -1;
		}
		else if (getVersion() > layoutVersion.getVersion()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof LayoutVersion)) {
			return false;
		}

		LayoutVersion layoutVersion = (LayoutVersion)object;

		long primaryKey = layoutVersion.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_originalVersion = _version;

		_setOriginalVersion = false;

		_originalUuid = _uuid;

		_originalPlid = _plid;

		_setOriginalPlid = false;

		_originalGroupId = _groupId;

		_setOriginalGroupId = false;

		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_setModifiedDate = false;
		_originalParentPlid = _parentPlid;

		_setOriginalParentPlid = false;

		_originalPrivateLayout = _privateLayout;

		_setOriginalPrivateLayout = false;

		_originalLayoutId = _layoutId;

		_setOriginalLayoutId = false;

		_originalParentLayoutId = _parentLayoutId;

		_setOriginalParentLayoutId = false;

		_originalClassNameId = _classNameId;

		_setOriginalClassNameId = false;

		_originalClassPK = _classPK;

		_setOriginalClassPK = false;

		_originalType = _type;

		_originalHidden = _hidden;

		_setOriginalHidden = false;

		_originalFriendlyURL = _friendlyURL;

		_originalIconImageId = _iconImageId;

		_setOriginalIconImageId = false;

		_originalPriority = _priority;

		_setOriginalPriority = false;

		_originalLayoutPrototypeUuid = _layoutPrototypeUuid;

		_originalSourcePrototypeLayoutUuid = _sourcePrototypeLayoutUuid;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<LayoutVersion> toCacheModel() {
		LayoutVersionCacheModel layoutVersionCacheModel =
			new LayoutVersionCacheModel();

		layoutVersionCacheModel.layoutVersionId = getLayoutVersionId();

		layoutVersionCacheModel.version = getVersion();

		layoutVersionCacheModel.uuid = getUuid();

		String uuid = layoutVersionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			layoutVersionCacheModel.uuid = null;
		}

		layoutVersionCacheModel.plid = getPlid();

		layoutVersionCacheModel.groupId = getGroupId();

		layoutVersionCacheModel.companyId = getCompanyId();

		layoutVersionCacheModel.userId = getUserId();

		layoutVersionCacheModel.userName = getUserName();

		String userName = layoutVersionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			layoutVersionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			layoutVersionCacheModel.createDate = createDate.getTime();
		}
		else {
			layoutVersionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			layoutVersionCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			layoutVersionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		layoutVersionCacheModel.parentPlid = getParentPlid();

		layoutVersionCacheModel.privateLayout = isPrivateLayout();

		layoutVersionCacheModel.layoutId = getLayoutId();

		layoutVersionCacheModel.parentLayoutId = getParentLayoutId();

		layoutVersionCacheModel.classNameId = getClassNameId();

		layoutVersionCacheModel.classPK = getClassPK();

		layoutVersionCacheModel.name = getName();

		String name = layoutVersionCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			layoutVersionCacheModel.name = null;
		}

		layoutVersionCacheModel.title = getTitle();

		String title = layoutVersionCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			layoutVersionCacheModel.title = null;
		}

		layoutVersionCacheModel.description = getDescription();

		String description = layoutVersionCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			layoutVersionCacheModel.description = null;
		}

		layoutVersionCacheModel.keywords = getKeywords();

		String keywords = layoutVersionCacheModel.keywords;

		if ((keywords != null) && (keywords.length() == 0)) {
			layoutVersionCacheModel.keywords = null;
		}

		layoutVersionCacheModel.robots = getRobots();

		String robots = layoutVersionCacheModel.robots;

		if ((robots != null) && (robots.length() == 0)) {
			layoutVersionCacheModel.robots = null;
		}

		layoutVersionCacheModel.type = getType();

		String type = layoutVersionCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			layoutVersionCacheModel.type = null;
		}

		layoutVersionCacheModel.typeSettings = getTypeSettings();

		String typeSettings = layoutVersionCacheModel.typeSettings;

		if ((typeSettings != null) && (typeSettings.length() == 0)) {
			layoutVersionCacheModel.typeSettings = null;
		}

		layoutVersionCacheModel.hidden = isHidden();

		layoutVersionCacheModel.system = isSystem();

		layoutVersionCacheModel.friendlyURL = getFriendlyURL();

		String friendlyURL = layoutVersionCacheModel.friendlyURL;

		if ((friendlyURL != null) && (friendlyURL.length() == 0)) {
			layoutVersionCacheModel.friendlyURL = null;
		}

		layoutVersionCacheModel.iconImageId = getIconImageId();

		layoutVersionCacheModel.themeId = getThemeId();

		String themeId = layoutVersionCacheModel.themeId;

		if ((themeId != null) && (themeId.length() == 0)) {
			layoutVersionCacheModel.themeId = null;
		}

		layoutVersionCacheModel.colorSchemeId = getColorSchemeId();

		String colorSchemeId = layoutVersionCacheModel.colorSchemeId;

		if ((colorSchemeId != null) && (colorSchemeId.length() == 0)) {
			layoutVersionCacheModel.colorSchemeId = null;
		}

		layoutVersionCacheModel.css = getCss();

		String css = layoutVersionCacheModel.css;

		if ((css != null) && (css.length() == 0)) {
			layoutVersionCacheModel.css = null;
		}

		layoutVersionCacheModel.priority = getPriority();

		layoutVersionCacheModel.layoutPrototypeUuid = getLayoutPrototypeUuid();

		String layoutPrototypeUuid =
			layoutVersionCacheModel.layoutPrototypeUuid;

		if ((layoutPrototypeUuid != null) &&
			(layoutPrototypeUuid.length() == 0)) {

			layoutVersionCacheModel.layoutPrototypeUuid = null;
		}

		layoutVersionCacheModel.layoutPrototypeLinkEnabled =
			isLayoutPrototypeLinkEnabled();

		layoutVersionCacheModel.sourcePrototypeLayoutUuid =
			getSourcePrototypeLayoutUuid();

		String sourcePrototypeLayoutUuid =
			layoutVersionCacheModel.sourcePrototypeLayoutUuid;

		if ((sourcePrototypeLayoutUuid != null) &&
			(sourcePrototypeLayoutUuid.length() == 0)) {

			layoutVersionCacheModel.sourcePrototypeLayoutUuid = null;
		}

		Date publishDate = getPublishDate();

		if (publishDate != null) {
			layoutVersionCacheModel.publishDate = publishDate.getTime();
		}
		else {
			layoutVersionCacheModel.publishDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			layoutVersionCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			layoutVersionCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return layoutVersionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<LayoutVersion, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(4 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<LayoutVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutVersion, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((LayoutVersion)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<LayoutVersion, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<LayoutVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutVersion, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((LayoutVersion)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, LayoutVersion>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _layoutVersionId;
	private int _version;
	private int _originalVersion;
	private boolean _setOriginalVersion;
	private String _uuid;
	private String _originalUuid;
	private long _plid;
	private long _originalPlid;
	private boolean _setOriginalPlid;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _parentPlid;
	private long _originalParentPlid;
	private boolean _setOriginalParentPlid;
	private boolean _privateLayout;
	private boolean _originalPrivateLayout;
	private boolean _setOriginalPrivateLayout;
	private long _layoutId;
	private long _originalLayoutId;
	private boolean _setOriginalLayoutId;
	private long _parentLayoutId;
	private long _originalParentLayoutId;
	private boolean _setOriginalParentLayoutId;
	private long _classNameId;
	private long _originalClassNameId;
	private boolean _setOriginalClassNameId;
	private long _classPK;
	private long _originalClassPK;
	private boolean _setOriginalClassPK;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _title;
	private String _titleCurrentLanguageId;
	private String _description;
	private String _descriptionCurrentLanguageId;
	private String _keywords;
	private String _keywordsCurrentLanguageId;
	private String _robots;
	private String _robotsCurrentLanguageId;
	private String _type;
	private String _originalType;
	private String _typeSettings;
	private boolean _hidden;
	private boolean _originalHidden;
	private boolean _setOriginalHidden;
	private boolean _system;
	private String _friendlyURL;
	private String _originalFriendlyURL;
	private long _iconImageId;
	private long _originalIconImageId;
	private boolean _setOriginalIconImageId;
	private String _themeId;
	private String _colorSchemeId;
	private String _css;
	private int _priority;
	private int _originalPriority;
	private boolean _setOriginalPriority;
	private String _layoutPrototypeUuid;
	private String _originalLayoutPrototypeUuid;
	private boolean _layoutPrototypeLinkEnabled;
	private String _sourcePrototypeLayoutUuid;
	private String _originalSourcePrototypeLayoutUuid;
	private Date _publishDate;
	private Date _lastPublishDate;
	private long _columnBitmask;
	private LayoutVersion _escapedModel;

}