/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.version.VersionModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the LayoutVersion service. Represents a row in the &quot;LayoutVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portal.model.impl.LayoutVersionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portal.model.impl.LayoutVersionImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutVersion
 * @generated
 */
@ProviderType
public interface LayoutVersionModel
	extends AttachedModel, BaseModel<LayoutVersion>, GroupedModel,
			LocalizedModel, ShardedModel, VersionModel<Layout> {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a layout version model instance should use the {@link LayoutVersion} interface instead.
	 */

	/**
	 * Returns the primary key of this layout version.
	 *
	 * @return the primary key of this layout version
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this layout version.
	 *
	 * @param primaryKey the primary key of this layout version
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the layout version ID of this layout version.
	 *
	 * @return the layout version ID of this layout version
	 */
	public long getLayoutVersionId();

	/**
	 * Sets the layout version ID of this layout version.
	 *
	 * @param layoutVersionId the layout version ID of this layout version
	 */
	public void setLayoutVersionId(long layoutVersionId);

	/**
	 * Returns the version of this layout version.
	 *
	 * @return the version of this layout version
	 */
	@Override
	public int getVersion();

	/**
	 * Sets the version of this layout version.
	 *
	 * @param version the version of this layout version
	 */
	@Override
	public void setVersion(int version);

	/**
	 * Returns the uuid of this layout version.
	 *
	 * @return the uuid of this layout version
	 */
	@AutoEscape
	public String getUuid();

	/**
	 * Sets the uuid of this layout version.
	 *
	 * @param uuid the uuid of this layout version
	 */
	public void setUuid(String uuid);

	/**
	 * Returns the plid of this layout version.
	 *
	 * @return the plid of this layout version
	 */
	public long getPlid();

	/**
	 * Sets the plid of this layout version.
	 *
	 * @param plid the plid of this layout version
	 */
	public void setPlid(long plid);

	/**
	 * Returns the group ID of this layout version.
	 *
	 * @return the group ID of this layout version
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this layout version.
	 *
	 * @param groupId the group ID of this layout version
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this layout version.
	 *
	 * @return the company ID of this layout version
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this layout version.
	 *
	 * @param companyId the company ID of this layout version
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this layout version.
	 *
	 * @return the user ID of this layout version
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this layout version.
	 *
	 * @param userId the user ID of this layout version
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this layout version.
	 *
	 * @return the user uuid of this layout version
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this layout version.
	 *
	 * @param userUuid the user uuid of this layout version
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this layout version.
	 *
	 * @return the user name of this layout version
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this layout version.
	 *
	 * @param userName the user name of this layout version
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this layout version.
	 *
	 * @return the create date of this layout version
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this layout version.
	 *
	 * @param createDate the create date of this layout version
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this layout version.
	 *
	 * @return the modified date of this layout version
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this layout version.
	 *
	 * @param modifiedDate the modified date of this layout version
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the parent plid of this layout version.
	 *
	 * @return the parent plid of this layout version
	 */
	public long getParentPlid();

	/**
	 * Sets the parent plid of this layout version.
	 *
	 * @param parentPlid the parent plid of this layout version
	 */
	public void setParentPlid(long parentPlid);

	/**
	 * Returns the private layout of this layout version.
	 *
	 * @return the private layout of this layout version
	 */
	public boolean getPrivateLayout();

	/**
	 * Returns <code>true</code> if this layout version is private layout.
	 *
	 * @return <code>true</code> if this layout version is private layout; <code>false</code> otherwise
	 */
	public boolean isPrivateLayout();

	/**
	 * Sets whether this layout version is private layout.
	 *
	 * @param privateLayout the private layout of this layout version
	 */
	public void setPrivateLayout(boolean privateLayout);

	/**
	 * Returns the layout ID of this layout version.
	 *
	 * @return the layout ID of this layout version
	 */
	public long getLayoutId();

	/**
	 * Sets the layout ID of this layout version.
	 *
	 * @param layoutId the layout ID of this layout version
	 */
	public void setLayoutId(long layoutId);

	/**
	 * Returns the parent layout ID of this layout version.
	 *
	 * @return the parent layout ID of this layout version
	 */
	public long getParentLayoutId();

	/**
	 * Sets the parent layout ID of this layout version.
	 *
	 * @param parentLayoutId the parent layout ID of this layout version
	 */
	public void setParentLayoutId(long parentLayoutId);

	/**
	 * Returns the fully qualified class name of this layout version.
	 *
	 * @return the fully qualified class name of this layout version
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this layout version.
	 *
	 * @return the class name ID of this layout version
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this layout version.
	 *
	 * @param classNameId the class name ID of this layout version
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this layout version.
	 *
	 * @return the class pk of this layout version
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this layout version.
	 *
	 * @param classPK the class pk of this layout version
	 */
	@Override
	public void setClassPK(long classPK);

	/**
	 * Returns the name of this layout version.
	 *
	 * @return the name of this layout version
	 */
	public String getName();

	/**
	 * Returns the localized name of this layout version in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized name of this layout version
	 */
	@AutoEscape
	public String getName(Locale locale);

	/**
	 * Returns the localized name of this layout version in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this layout version. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getName(Locale locale, boolean useDefault);

	/**
	 * Returns the localized name of this layout version in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized name of this layout version
	 */
	@AutoEscape
	public String getName(String languageId);

	/**
	 * Returns the localized name of this layout version in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this layout version
	 */
	@AutoEscape
	public String getName(String languageId, boolean useDefault);

	@AutoEscape
	public String getNameCurrentLanguageId();

	@AutoEscape
	public String getNameCurrentValue();

	/**
	 * Returns a map of the locales and localized names of this layout version.
	 *
	 * @return the locales and localized names of this layout version
	 */
	public Map<Locale, String> getNameMap();

	/**
	 * Sets the name of this layout version.
	 *
	 * @param name the name of this layout version
	 */
	public void setName(String name);

	/**
	 * Sets the localized name of this layout version in the language.
	 *
	 * @param name the localized name of this layout version
	 * @param locale the locale of the language
	 */
	public void setName(String name, Locale locale);

	/**
	 * Sets the localized name of this layout version in the language, and sets the default locale.
	 *
	 * @param name the localized name of this layout version
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setName(String name, Locale locale, Locale defaultLocale);

	public void setNameCurrentLanguageId(String languageId);

	/**
	 * Sets the localized names of this layout version from the map of locales and localized names.
	 *
	 * @param nameMap the locales and localized names of this layout version
	 */
	public void setNameMap(Map<Locale, String> nameMap);

	/**
	 * Sets the localized names of this layout version from the map of locales and localized names, and sets the default locale.
	 *
	 * @param nameMap the locales and localized names of this layout version
	 * @param defaultLocale the default locale
	 */
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale);

	/**
	 * Returns the title of this layout version.
	 *
	 * @return the title of this layout version
	 */
	public String getTitle();

	/**
	 * Returns the localized title of this layout version in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized title of this layout version
	 */
	@AutoEscape
	public String getTitle(Locale locale);

	/**
	 * Returns the localized title of this layout version in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized title of this layout version. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getTitle(Locale locale, boolean useDefault);

	/**
	 * Returns the localized title of this layout version in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized title of this layout version
	 */
	@AutoEscape
	public String getTitle(String languageId);

	/**
	 * Returns the localized title of this layout version in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized title of this layout version
	 */
	@AutoEscape
	public String getTitle(String languageId, boolean useDefault);

	@AutoEscape
	public String getTitleCurrentLanguageId();

	@AutoEscape
	public String getTitleCurrentValue();

	/**
	 * Returns a map of the locales and localized titles of this layout version.
	 *
	 * @return the locales and localized titles of this layout version
	 */
	public Map<Locale, String> getTitleMap();

	/**
	 * Sets the title of this layout version.
	 *
	 * @param title the title of this layout version
	 */
	public void setTitle(String title);

	/**
	 * Sets the localized title of this layout version in the language.
	 *
	 * @param title the localized title of this layout version
	 * @param locale the locale of the language
	 */
	public void setTitle(String title, Locale locale);

	/**
	 * Sets the localized title of this layout version in the language, and sets the default locale.
	 *
	 * @param title the localized title of this layout version
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setTitle(String title, Locale locale, Locale defaultLocale);

	public void setTitleCurrentLanguageId(String languageId);

	/**
	 * Sets the localized titles of this layout version from the map of locales and localized titles.
	 *
	 * @param titleMap the locales and localized titles of this layout version
	 */
	public void setTitleMap(Map<Locale, String> titleMap);

	/**
	 * Sets the localized titles of this layout version from the map of locales and localized titles, and sets the default locale.
	 *
	 * @param titleMap the locales and localized titles of this layout version
	 * @param defaultLocale the default locale
	 */
	public void setTitleMap(Map<Locale, String> titleMap, Locale defaultLocale);

	/**
	 * Returns the description of this layout version.
	 *
	 * @return the description of this layout version
	 */
	public String getDescription();

	/**
	 * Returns the localized description of this layout version in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized description of this layout version
	 */
	@AutoEscape
	public String getDescription(Locale locale);

	/**
	 * Returns the localized description of this layout version in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized description of this layout version. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getDescription(Locale locale, boolean useDefault);

	/**
	 * Returns the localized description of this layout version in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized description of this layout version
	 */
	@AutoEscape
	public String getDescription(String languageId);

	/**
	 * Returns the localized description of this layout version in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized description of this layout version
	 */
	@AutoEscape
	public String getDescription(String languageId, boolean useDefault);

	@AutoEscape
	public String getDescriptionCurrentLanguageId();

	@AutoEscape
	public String getDescriptionCurrentValue();

	/**
	 * Returns a map of the locales and localized descriptions of this layout version.
	 *
	 * @return the locales and localized descriptions of this layout version
	 */
	public Map<Locale, String> getDescriptionMap();

	/**
	 * Sets the description of this layout version.
	 *
	 * @param description the description of this layout version
	 */
	public void setDescription(String description);

	/**
	 * Sets the localized description of this layout version in the language.
	 *
	 * @param description the localized description of this layout version
	 * @param locale the locale of the language
	 */
	public void setDescription(String description, Locale locale);

	/**
	 * Sets the localized description of this layout version in the language, and sets the default locale.
	 *
	 * @param description the localized description of this layout version
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setDescription(
		String description, Locale locale, Locale defaultLocale);

	public void setDescriptionCurrentLanguageId(String languageId);

	/**
	 * Sets the localized descriptions of this layout version from the map of locales and localized descriptions.
	 *
	 * @param descriptionMap the locales and localized descriptions of this layout version
	 */
	public void setDescriptionMap(Map<Locale, String> descriptionMap);

	/**
	 * Sets the localized descriptions of this layout version from the map of locales and localized descriptions, and sets the default locale.
	 *
	 * @param descriptionMap the locales and localized descriptions of this layout version
	 * @param defaultLocale the default locale
	 */
	public void setDescriptionMap(
		Map<Locale, String> descriptionMap, Locale defaultLocale);

	/**
	 * Returns the keywords of this layout version.
	 *
	 * @return the keywords of this layout version
	 */
	public String getKeywords();

	/**
	 * Returns the localized keywords of this layout version in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized keywords of this layout version
	 */
	@AutoEscape
	public String getKeywords(Locale locale);

	/**
	 * Returns the localized keywords of this layout version in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized keywords of this layout version. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getKeywords(Locale locale, boolean useDefault);

	/**
	 * Returns the localized keywords of this layout version in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized keywords of this layout version
	 */
	@AutoEscape
	public String getKeywords(String languageId);

	/**
	 * Returns the localized keywords of this layout version in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized keywords of this layout version
	 */
	@AutoEscape
	public String getKeywords(String languageId, boolean useDefault);

	@AutoEscape
	public String getKeywordsCurrentLanguageId();

	@AutoEscape
	public String getKeywordsCurrentValue();

	/**
	 * Returns a map of the locales and localized keywordses of this layout version.
	 *
	 * @return the locales and localized keywordses of this layout version
	 */
	public Map<Locale, String> getKeywordsMap();

	/**
	 * Sets the keywords of this layout version.
	 *
	 * @param keywords the keywords of this layout version
	 */
	public void setKeywords(String keywords);

	/**
	 * Sets the localized keywords of this layout version in the language.
	 *
	 * @param keywords the localized keywords of this layout version
	 * @param locale the locale of the language
	 */
	public void setKeywords(String keywords, Locale locale);

	/**
	 * Sets the localized keywords of this layout version in the language, and sets the default locale.
	 *
	 * @param keywords the localized keywords of this layout version
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setKeywords(
		String keywords, Locale locale, Locale defaultLocale);

	public void setKeywordsCurrentLanguageId(String languageId);

	/**
	 * Sets the localized keywordses of this layout version from the map of locales and localized keywordses.
	 *
	 * @param keywordsMap the locales and localized keywordses of this layout version
	 */
	public void setKeywordsMap(Map<Locale, String> keywordsMap);

	/**
	 * Sets the localized keywordses of this layout version from the map of locales and localized keywordses, and sets the default locale.
	 *
	 * @param keywordsMap the locales and localized keywordses of this layout version
	 * @param defaultLocale the default locale
	 */
	public void setKeywordsMap(
		Map<Locale, String> keywordsMap, Locale defaultLocale);

	/**
	 * Returns the robots of this layout version.
	 *
	 * @return the robots of this layout version
	 */
	public String getRobots();

	/**
	 * Returns the localized robots of this layout version in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized robots of this layout version
	 */
	@AutoEscape
	public String getRobots(Locale locale);

	/**
	 * Returns the localized robots of this layout version in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized robots of this layout version. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getRobots(Locale locale, boolean useDefault);

	/**
	 * Returns the localized robots of this layout version in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized robots of this layout version
	 */
	@AutoEscape
	public String getRobots(String languageId);

	/**
	 * Returns the localized robots of this layout version in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized robots of this layout version
	 */
	@AutoEscape
	public String getRobots(String languageId, boolean useDefault);

	@AutoEscape
	public String getRobotsCurrentLanguageId();

	@AutoEscape
	public String getRobotsCurrentValue();

	/**
	 * Returns a map of the locales and localized robotses of this layout version.
	 *
	 * @return the locales and localized robotses of this layout version
	 */
	public Map<Locale, String> getRobotsMap();

	/**
	 * Sets the robots of this layout version.
	 *
	 * @param robots the robots of this layout version
	 */
	public void setRobots(String robots);

	/**
	 * Sets the localized robots of this layout version in the language.
	 *
	 * @param robots the localized robots of this layout version
	 * @param locale the locale of the language
	 */
	public void setRobots(String robots, Locale locale);

	/**
	 * Sets the localized robots of this layout version in the language, and sets the default locale.
	 *
	 * @param robots the localized robots of this layout version
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setRobots(String robots, Locale locale, Locale defaultLocale);

	public void setRobotsCurrentLanguageId(String languageId);

	/**
	 * Sets the localized robotses of this layout version from the map of locales and localized robotses.
	 *
	 * @param robotsMap the locales and localized robotses of this layout version
	 */
	public void setRobotsMap(Map<Locale, String> robotsMap);

	/**
	 * Sets the localized robotses of this layout version from the map of locales and localized robotses, and sets the default locale.
	 *
	 * @param robotsMap the locales and localized robotses of this layout version
	 * @param defaultLocale the default locale
	 */
	public void setRobotsMap(
		Map<Locale, String> robotsMap, Locale defaultLocale);

	/**
	 * Returns the type of this layout version.
	 *
	 * @return the type of this layout version
	 */
	@AutoEscape
	public String getType();

	/**
	 * Sets the type of this layout version.
	 *
	 * @param type the type of this layout version
	 */
	public void setType(String type);

	/**
	 * Returns the type settings of this layout version.
	 *
	 * @return the type settings of this layout version
	 */
	@AutoEscape
	public String getTypeSettings();

	/**
	 * Sets the type settings of this layout version.
	 *
	 * @param typeSettings the type settings of this layout version
	 */
	public void setTypeSettings(String typeSettings);

	/**
	 * Returns the hidden of this layout version.
	 *
	 * @return the hidden of this layout version
	 */
	public boolean getHidden();

	/**
	 * Returns <code>true</code> if this layout version is hidden.
	 *
	 * @return <code>true</code> if this layout version is hidden; <code>false</code> otherwise
	 */
	public boolean isHidden();

	/**
	 * Sets whether this layout version is hidden.
	 *
	 * @param hidden the hidden of this layout version
	 */
	public void setHidden(boolean hidden);

	/**
	 * Returns the system of this layout version.
	 *
	 * @return the system of this layout version
	 */
	public boolean getSystem();

	/**
	 * Returns <code>true</code> if this layout version is system.
	 *
	 * @return <code>true</code> if this layout version is system; <code>false</code> otherwise
	 */
	public boolean isSystem();

	/**
	 * Sets whether this layout version is system.
	 *
	 * @param system the system of this layout version
	 */
	public void setSystem(boolean system);

	/**
	 * Returns the friendly url of this layout version.
	 *
	 * @return the friendly url of this layout version
	 */
	@AutoEscape
	public String getFriendlyURL();

	/**
	 * Sets the friendly url of this layout version.
	 *
	 * @param friendlyURL the friendly url of this layout version
	 */
	public void setFriendlyURL(String friendlyURL);

	/**
	 * Returns the icon image ID of this layout version.
	 *
	 * @return the icon image ID of this layout version
	 */
	public long getIconImageId();

	/**
	 * Sets the icon image ID of this layout version.
	 *
	 * @param iconImageId the icon image ID of this layout version
	 */
	public void setIconImageId(long iconImageId);

	/**
	 * Returns the theme ID of this layout version.
	 *
	 * @return the theme ID of this layout version
	 */
	@AutoEscape
	public String getThemeId();

	/**
	 * Sets the theme ID of this layout version.
	 *
	 * @param themeId the theme ID of this layout version
	 */
	public void setThemeId(String themeId);

	/**
	 * Returns the color scheme ID of this layout version.
	 *
	 * @return the color scheme ID of this layout version
	 */
	@AutoEscape
	public String getColorSchemeId();

	/**
	 * Sets the color scheme ID of this layout version.
	 *
	 * @param colorSchemeId the color scheme ID of this layout version
	 */
	public void setColorSchemeId(String colorSchemeId);

	/**
	 * Returns the css of this layout version.
	 *
	 * @return the css of this layout version
	 */
	@AutoEscape
	public String getCss();

	/**
	 * Sets the css of this layout version.
	 *
	 * @param css the css of this layout version
	 */
	public void setCss(String css);

	/**
	 * Returns the priority of this layout version.
	 *
	 * @return the priority of this layout version
	 */
	public int getPriority();

	/**
	 * Sets the priority of this layout version.
	 *
	 * @param priority the priority of this layout version
	 */
	public void setPriority(int priority);

	/**
	 * Returns the layout prototype uuid of this layout version.
	 *
	 * @return the layout prototype uuid of this layout version
	 */
	@AutoEscape
	public String getLayoutPrototypeUuid();

	/**
	 * Sets the layout prototype uuid of this layout version.
	 *
	 * @param layoutPrototypeUuid the layout prototype uuid of this layout version
	 */
	public void setLayoutPrototypeUuid(String layoutPrototypeUuid);

	/**
	 * Returns the layout prototype link enabled of this layout version.
	 *
	 * @return the layout prototype link enabled of this layout version
	 */
	public boolean getLayoutPrototypeLinkEnabled();

	/**
	 * Returns <code>true</code> if this layout version is layout prototype link enabled.
	 *
	 * @return <code>true</code> if this layout version is layout prototype link enabled; <code>false</code> otherwise
	 */
	public boolean isLayoutPrototypeLinkEnabled();

	/**
	 * Sets whether this layout version is layout prototype link enabled.
	 *
	 * @param layoutPrototypeLinkEnabled the layout prototype link enabled of this layout version
	 */
	public void setLayoutPrototypeLinkEnabled(
		boolean layoutPrototypeLinkEnabled);

	/**
	 * Returns the source prototype layout uuid of this layout version.
	 *
	 * @return the source prototype layout uuid of this layout version
	 */
	@AutoEscape
	public String getSourcePrototypeLayoutUuid();

	/**
	 * Sets the source prototype layout uuid of this layout version.
	 *
	 * @param sourcePrototypeLayoutUuid the source prototype layout uuid of this layout version
	 */
	public void setSourcePrototypeLayoutUuid(String sourcePrototypeLayoutUuid);

	/**
	 * Returns the publish date of this layout version.
	 *
	 * @return the publish date of this layout version
	 */
	public Date getPublishDate();

	/**
	 * Sets the publish date of this layout version.
	 *
	 * @param publishDate the publish date of this layout version
	 */
	public void setPublishDate(Date publishDate);

	/**
	 * Returns the last publish date of this layout version.
	 *
	 * @return the last publish date of this layout version
	 */
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this layout version.
	 *
	 * @param lastPublishDate the last publish date of this layout version
	 */
	public void setLastPublishDate(Date lastPublishDate);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

}