/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.product.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CProduct service. Represents a row in the &quot;CProduct&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.product.model.impl.CProductModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.product.model.impl.CProductImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see CProduct
 * @generated
 */
@ProviderType
public interface CProductModel
	extends BaseModel<CProduct>, GroupedModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a c product model instance should use the {@link CProduct} interface instead.
	 */

	/**
	 * Returns the primary key of this c product.
	 *
	 * @return the primary key of this c product
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this c product.
	 *
	 * @param primaryKey the primary key of this c product
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this c product.
	 *
	 * @return the uuid of this c product
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this c product.
	 *
	 * @param uuid the uuid of this c product
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the external reference code of this c product.
	 *
	 * @return the external reference code of this c product
	 */
	@AutoEscape
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this c product.
	 *
	 * @param externalReferenceCode the external reference code of this c product
	 */
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the c product ID of this c product.
	 *
	 * @return the c product ID of this c product
	 */
	public long getCProductId();

	/**
	 * Sets the c product ID of this c product.
	 *
	 * @param CProductId the c product ID of this c product
	 */
	public void setCProductId(long CProductId);

	/**
	 * Returns the group ID of this c product.
	 *
	 * @return the group ID of this c product
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this c product.
	 *
	 * @param groupId the group ID of this c product
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this c product.
	 *
	 * @return the company ID of this c product
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this c product.
	 *
	 * @param companyId the company ID of this c product
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this c product.
	 *
	 * @return the user ID of this c product
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this c product.
	 *
	 * @param userId the user ID of this c product
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this c product.
	 *
	 * @return the user uuid of this c product
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this c product.
	 *
	 * @param userUuid the user uuid of this c product
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this c product.
	 *
	 * @return the user name of this c product
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this c product.
	 *
	 * @param userName the user name of this c product
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this c product.
	 *
	 * @return the create date of this c product
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this c product.
	 *
	 * @param createDate the create date of this c product
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this c product.
	 *
	 * @return the modified date of this c product
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this c product.
	 *
	 * @param modifiedDate the modified date of this c product
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the published cp definition ID of this c product.
	 *
	 * @return the published cp definition ID of this c product
	 */
	public long getPublishedCPDefinitionId();

	/**
	 * Sets the published cp definition ID of this c product.
	 *
	 * @param publishedCPDefinitionId the published cp definition ID of this c product
	 */
	public void setPublishedCPDefinitionId(long publishedCPDefinitionId);

	/**
	 * Returns the latest version of this c product.
	 *
	 * @return the latest version of this c product
	 */
	public int getLatestVersion();

	/**
	 * Sets the latest version of this c product.
	 *
	 * @param latestVersion the latest version of this c product
	 */
	public void setLatestVersion(int latestVersion);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(CProduct cProduct);

	@Override
	public int hashCode();

	@Override
	public CacheModel<CProduct> toCacheModel();

	@Override
	public CProduct toEscapedModel();

	@Override
	public CProduct toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}