/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.inventory.service;

import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

/**
 * Provides the local service utility for CommerceInventoryBookedQuantity. This utility wraps
 * <code>com.liferay.commerce.inventory.service.impl.CommerceInventoryBookedQuantityLocalServiceImpl</code> and
 * is an access point for service operations in application layer code running
 * on the local server. Methods of this service will not have security checks
 * based on the propagated JAAS credentials because this service can only be
 * accessed from within the same VM.
 *
 * @author Luca Pellizzon
 * @see CommerceInventoryBookedQuantityLocalService
 * @generated
 */
public class CommerceInventoryBookedQuantityLocalServiceUtil {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Add custom service methods to <code>com.liferay.commerce.inventory.service.impl.CommerceInventoryBookedQuantityLocalServiceImpl</code> and rerun ServiceBuilder to regenerate this class.
	 */
	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
				addCommerceBookedQuantity(
					long userId, String sku, int quantity,
					java.util.Date expirationDate,
					java.util.Map<String, String> context)
			throws com.liferay.portal.kernel.exception.PortalException {

		return getService().addCommerceBookedQuantity(
			userId, sku, quantity, expirationDate, context);
	}

	/**
	 * Adds the commerce inventory booked quantity to the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect CommerceInventoryBookedQuantityLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param commerceInventoryBookedQuantity the commerce inventory booked quantity
	 * @return the commerce inventory booked quantity that was added
	 */
	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
			addCommerceInventoryBookedQuantity(
				com.liferay.commerce.inventory.model.
					CommerceInventoryBookedQuantity
						commerceInventoryBookedQuantity) {

		return getService().addCommerceInventoryBookedQuantity(
			commerceInventoryBookedQuantity);
	}

	public static void checkCommerceInventoryBookedQuantities() {
		getService().checkCommerceInventoryBookedQuantities();
	}

	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
				consumeCommerceBookedQuantity(
					long commerceBookedQuantityId, int quantity)
			throws com.liferay.commerce.inventory.exception.
				NoSuchInventoryBookedQuantityException {

		return getService().consumeCommerceBookedQuantity(
			commerceBookedQuantityId, quantity);
	}

	/**
	 * Creates a new commerce inventory booked quantity with the primary key. Does not add the commerce inventory booked quantity to the database.
	 *
	 * @param commerceInventoryBookedQuantityId the primary key for the new commerce inventory booked quantity
	 * @return the new commerce inventory booked quantity
	 */
	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
			createCommerceInventoryBookedQuantity(
				long commerceInventoryBookedQuantityId) {

		return getService().createCommerceInventoryBookedQuantity(
			commerceInventoryBookedQuantityId);
	}

	/**
	 * Deletes the commerce inventory booked quantity from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect CommerceInventoryBookedQuantityLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param commerceInventoryBookedQuantity the commerce inventory booked quantity
	 * @return the commerce inventory booked quantity that was removed
	 */
	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
			deleteCommerceInventoryBookedQuantity(
				com.liferay.commerce.inventory.model.
					CommerceInventoryBookedQuantity
						commerceInventoryBookedQuantity) {

		return getService().deleteCommerceInventoryBookedQuantity(
			commerceInventoryBookedQuantity);
	}

	/**
	 * Deletes the commerce inventory booked quantity with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect CommerceInventoryBookedQuantityLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param commerceInventoryBookedQuantityId the primary key of the commerce inventory booked quantity
	 * @return the commerce inventory booked quantity that was removed
	 * @throws PortalException if a commerce inventory booked quantity with the primary key could not be found
	 */
	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
				deleteCommerceInventoryBookedQuantity(
					long commerceInventoryBookedQuantityId)
			throws com.liferay.portal.kernel.exception.PortalException {

		return getService().deleteCommerceInventoryBookedQuantity(
			commerceInventoryBookedQuantityId);
	}

	/**
	 * @throws PortalException
	 */
	public static com.liferay.portal.kernel.model.PersistedModel
			deletePersistedModel(
				com.liferay.portal.kernel.model.PersistedModel persistedModel)
		throws com.liferay.portal.kernel.exception.PortalException {

		return getService().deletePersistedModel(persistedModel);
	}

	public static com.liferay.portal.kernel.dao.orm.DynamicQuery
		dynamicQuery() {

		return getService().dynamicQuery();
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	public static <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery) {

		return getService().dynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.commerce.inventory.model.impl.CommerceInventoryBookedQuantityModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	public static <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end) {

		return getService().dynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.commerce.inventory.model.impl.CommerceInventoryBookedQuantityModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	public static <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator<T> orderByComparator) {

		return getService().dynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	public static long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery) {

		return getService().dynamicQueryCount(dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	public static long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
		com.liferay.portal.kernel.dao.orm.Projection projection) {

		return getService().dynamicQueryCount(dynamicQuery, projection);
	}

	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
			fetchCommerceInventoryBookedQuantity(
				long commerceInventoryBookedQuantityId) {

		return getService().fetchCommerceInventoryBookedQuantity(
			commerceInventoryBookedQuantityId);
	}

	public static com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery
		getActionableDynamicQuery() {

		return getService().getActionableDynamicQuery();
	}

	public static int getCommerceBookedQuantity(long companyId, String sku) {
		return getService().getCommerceBookedQuantity(companyId, sku);
	}

	/**
	 * Returns a range of all the commerce inventory booked quantities.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.commerce.inventory.model.impl.CommerceInventoryBookedQuantityModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of commerce inventory booked quantities
	 * @param end the upper bound of the range of commerce inventory booked quantities (not inclusive)
	 * @return the range of commerce inventory booked quantities
	 */
	public static java.util.List
		<com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity>
			getCommerceInventoryBookedQuantities(int start, int end) {

		return getService().getCommerceInventoryBookedQuantities(start, end);
	}

	public static java.util.List
		<com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity>
			getCommerceInventoryBookedQuantities(
				long companyId, String sku, int start, int end) {

		return getService().getCommerceInventoryBookedQuantities(
			companyId, sku, start, end);
	}

	/**
	 * Returns the number of commerce inventory booked quantities.
	 *
	 * @return the number of commerce inventory booked quantities
	 */
	public static int getCommerceInventoryBookedQuantitiesCount() {
		return getService().getCommerceInventoryBookedQuantitiesCount();
	}

	public static int getCommerceInventoryBookedQuantitiesCount(
		long companyId, String sku) {

		return getService().getCommerceInventoryBookedQuantitiesCount(
			companyId, sku);
	}

	/**
	 * Returns the commerce inventory booked quantity with the primary key.
	 *
	 * @param commerceInventoryBookedQuantityId the primary key of the commerce inventory booked quantity
	 * @return the commerce inventory booked quantity
	 * @throws PortalException if a commerce inventory booked quantity with the primary key could not be found
	 */
	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
				getCommerceInventoryBookedQuantity(
					long commerceInventoryBookedQuantityId)
			throws com.liferay.portal.kernel.exception.PortalException {

		return getService().getCommerceInventoryBookedQuantity(
			commerceInventoryBookedQuantityId);
	}

	public static
		com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery
			getIndexableActionableDynamicQuery() {

		return getService().getIndexableActionableDynamicQuery();
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	public static String getOSGiServiceIdentifier() {
		return getService().getOSGiServiceIdentifier();
	}

	/**
	 * @throws PortalException
	 */
	public static com.liferay.portal.kernel.model.PersistedModel
			getPersistedModel(java.io.Serializable primaryKeyObj)
		throws com.liferay.portal.kernel.exception.PortalException {

		return getService().getPersistedModel(primaryKeyObj);
	}

	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
				resetCommerceBookedQuantity(
					long commerceBookedQuantityId, long userId, String sku,
					int quantity, java.util.Date expirationDate,
					java.util.Map<String, String> context)
			throws com.liferay.portal.kernel.exception.PortalException {

		return getService().resetCommerceBookedQuantity(
			commerceBookedQuantityId, userId, sku, quantity, expirationDate,
			context);
	}

	/**
	 * Updates the commerce inventory booked quantity in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect CommerceInventoryBookedQuantityLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param commerceInventoryBookedQuantity the commerce inventory booked quantity
	 * @return the commerce inventory booked quantity that was updated
	 */
	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
			updateCommerceInventoryBookedQuantity(
				com.liferay.commerce.inventory.model.
					CommerceInventoryBookedQuantity
						commerceInventoryBookedQuantity) {

		return getService().updateCommerceInventoryBookedQuantity(
			commerceInventoryBookedQuantity);
	}

	public static
		com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity
				updateCommerceInventoryBookedQuantity(
					long userId, long commerceInventoryBookedQuantityId,
					int quantity, java.util.Map<String, String> context,
					long mvccVersion)
			throws com.liferay.portal.kernel.exception.PortalException {

		return getService().updateCommerceInventoryBookedQuantity(
			userId, commerceInventoryBookedQuantityId, quantity, context,
			mvccVersion);
	}

	public static CommerceInventoryBookedQuantityLocalService getService() {
		return _serviceTracker.getService();
	}

	private static ServiceTracker
		<CommerceInventoryBookedQuantityLocalService,
		 CommerceInventoryBookedQuantityLocalService> _serviceTracker;

	static {
		Bundle bundle = FrameworkUtil.getBundle(
			CommerceInventoryBookedQuantityLocalService.class);

		ServiceTracker
			<CommerceInventoryBookedQuantityLocalService,
			 CommerceInventoryBookedQuantityLocalService> serviceTracker =
				new ServiceTracker
					<CommerceInventoryBookedQuantityLocalService,
					 CommerceInventoryBookedQuantityLocalService>(
						 bundle.getBundleContext(),
						 CommerceInventoryBookedQuantityLocalService.class,
						 null);

		serviceTracker.open();

		_serviceTracker = serviceTracker;
	}

}