/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.application.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CommerceApplicationModel service. Represents a row in the &quot;CommerceApplicationModel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.application.model.impl.CommerceApplicationModelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.application.model.impl.CommerceApplicationModelImpl</code>.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceApplicationModel
 * @generated
 */
@ProviderType
public interface CommerceApplicationModelModel
	extends AuditedModel, BaseModel<CommerceApplicationModel>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce application model model instance should use the {@link CommerceApplicationModel} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce application model.
	 *
	 * @return the primary key of this commerce application model
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce application model.
	 *
	 * @param primaryKey the primary key of this commerce application model
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the commerce application model ID of this commerce application model.
	 *
	 * @return the commerce application model ID of this commerce application model
	 */
	public long getCommerceApplicationModelId();

	/**
	 * Sets the commerce application model ID of this commerce application model.
	 *
	 * @param commerceApplicationModelId the commerce application model ID of this commerce application model
	 */
	public void setCommerceApplicationModelId(long commerceApplicationModelId);

	/**
	 * Returns the company ID of this commerce application model.
	 *
	 * @return the company ID of this commerce application model
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce application model.
	 *
	 * @param companyId the company ID of this commerce application model
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce application model.
	 *
	 * @return the user ID of this commerce application model
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce application model.
	 *
	 * @param userId the user ID of this commerce application model
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce application model.
	 *
	 * @return the user uuid of this commerce application model
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce application model.
	 *
	 * @param userUuid the user uuid of this commerce application model
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce application model.
	 *
	 * @return the user name of this commerce application model
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce application model.
	 *
	 * @param userName the user name of this commerce application model
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce application model.
	 *
	 * @return the create date of this commerce application model
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce application model.
	 *
	 * @param createDate the create date of this commerce application model
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce application model.
	 *
	 * @return the modified date of this commerce application model
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce application model.
	 *
	 * @param modifiedDate the modified date of this commerce application model
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce application brand ID of this commerce application model.
	 *
	 * @return the commerce application brand ID of this commerce application model
	 */
	public long getCommerceApplicationBrandId();

	/**
	 * Sets the commerce application brand ID of this commerce application model.
	 *
	 * @param commerceApplicationBrandId the commerce application brand ID of this commerce application model
	 */
	public void setCommerceApplicationBrandId(long commerceApplicationBrandId);

	/**
	 * Returns the name of this commerce application model.
	 *
	 * @return the name of this commerce application model
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this commerce application model.
	 *
	 * @param name the name of this commerce application model
	 */
	public void setName(String name);

	/**
	 * Returns the year of this commerce application model.
	 *
	 * @return the year of this commerce application model
	 */
	@AutoEscape
	public String getYear();

	/**
	 * Sets the year of this commerce application model.
	 *
	 * @param year the year of this commerce application model
	 */
	public void setYear(String year);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(CommerceApplicationModel commerceApplicationModel);

	@Override
	public int hashCode();

	@Override
	public CacheModel<CommerceApplicationModel> toCacheModel();

	@Override
	public CommerceApplicationModel toEscapedModel();

	@Override
	public CommerceApplicationModel toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}