/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.application.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CommerceApplicationModelCProductRel service. Represents a row in the &quot;CAModelCProductRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.application.model.impl.CommerceApplicationModelCProductRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.application.model.impl.CommerceApplicationModelCProductRelImpl</code>.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceApplicationModelCProductRel
 * @generated
 */
@ProviderType
public interface CommerceApplicationModelCProductRelModel
	extends AuditedModel, BaseModel<CommerceApplicationModelCProductRel>,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce application model c product rel model instance should use the {@link CommerceApplicationModelCProductRel} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce application model c product rel.
	 *
	 * @return the primary key of this commerce application model c product rel
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce application model c product rel.
	 *
	 * @param primaryKey the primary key of this commerce application model c product rel
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the commerce application model c product rel ID of this commerce application model c product rel.
	 *
	 * @return the commerce application model c product rel ID of this commerce application model c product rel
	 */
	public long getCommerceApplicationModelCProductRelId();

	/**
	 * Sets the commerce application model c product rel ID of this commerce application model c product rel.
	 *
	 * @param commerceApplicationModelCProductRelId the commerce application model c product rel ID of this commerce application model c product rel
	 */
	public void setCommerceApplicationModelCProductRelId(
		long commerceApplicationModelCProductRelId);

	/**
	 * Returns the company ID of this commerce application model c product rel.
	 *
	 * @return the company ID of this commerce application model c product rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce application model c product rel.
	 *
	 * @param companyId the company ID of this commerce application model c product rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce application model c product rel.
	 *
	 * @return the user ID of this commerce application model c product rel
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce application model c product rel.
	 *
	 * @param userId the user ID of this commerce application model c product rel
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce application model c product rel.
	 *
	 * @return the user uuid of this commerce application model c product rel
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce application model c product rel.
	 *
	 * @param userUuid the user uuid of this commerce application model c product rel
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce application model c product rel.
	 *
	 * @return the user name of this commerce application model c product rel
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce application model c product rel.
	 *
	 * @param userName the user name of this commerce application model c product rel
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce application model c product rel.
	 *
	 * @return the create date of this commerce application model c product rel
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce application model c product rel.
	 *
	 * @param createDate the create date of this commerce application model c product rel
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce application model c product rel.
	 *
	 * @return the modified date of this commerce application model c product rel
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce application model c product rel.
	 *
	 * @param modifiedDate the modified date of this commerce application model c product rel
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce application model ID of this commerce application model c product rel.
	 *
	 * @return the commerce application model ID of this commerce application model c product rel
	 */
	public long getCommerceApplicationModelId();

	/**
	 * Sets the commerce application model ID of this commerce application model c product rel.
	 *
	 * @param commerceApplicationModelId the commerce application model ID of this commerce application model c product rel
	 */
	public void setCommerceApplicationModelId(long commerceApplicationModelId);

	/**
	 * Returns the c product ID of this commerce application model c product rel.
	 *
	 * @return the c product ID of this commerce application model c product rel
	 */
	public long getCProductId();

	/**
	 * Sets the c product ID of this commerce application model c product rel.
	 *
	 * @param CProductId the c product ID of this commerce application model c product rel
	 */
	public void setCProductId(long CProductId);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(
		CommerceApplicationModelCProductRel
			commerceApplicationModelCProductRel);

	@Override
	public int hashCode();

	@Override
	public CacheModel<CommerceApplicationModelCProductRel> toCacheModel();

	@Override
	public CommerceApplicationModelCProductRel toEscapedModel();

	@Override
	public CommerceApplicationModelCProductRel toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}