/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet.filters;

import com.liferay.portal.kernel.servlet.Header;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.util.servlet.filters.CacheResponseData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;

public class CacheResponseUtil {
    public static void setHeaders(HttpServletResponse httpServletResponse, Map<String, Set<Header>> headers) {
        if (httpServletResponse.isCommitted()) {
            return;
        }
        for (Map.Entry<String, Set<Header>> entry : headers.entrySet()) {
            String key = entry.getKey();
            boolean first = true;
            for (Header header : entry.getValue()) {
                if (first) {
                    header.setToResponse(key, httpServletResponse);
                    first = false;
                    continue;
                }
                header.addToResponse(key, httpServletResponse);
            }
        }
    }

    public static void write(HttpServletResponse httpServletResponse, CacheResponseData cacheResponseData) throws IOException {
        CacheResponseUtil.setHeaders(httpServletResponse, cacheResponseData.getHeaders());
        httpServletResponse.setContentType(cacheResponseData.getContentType());
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (ByteBuffer)cacheResponseData.getByteBuffer());
    }
}

